/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.TextRecognition;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.util.FileChooserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010/\u001a\u00020-\u0012\u0006\u0010,\u001a\u00020)\u0012\u0006\u0010(\u001a\u00020%\u0012\u0006\u0010$\u001a\u00020!\u00a2\u0006\u0004\b0\u00101J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0003\u001a\u00020\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0004\b\u0003\u0010\tJ+\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J+\u0010\u0016\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u000fJ3\u0010\u0019\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ3\u0010\u001b\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u0016\u0010$\u001a\u00020!8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010(\u001a\u00020%8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010,\u001a\u00020)8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010/\u001a\u00020-8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010.\u00a8\u00062"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "Lio/scanbot/sdk/entity/Document;", "a", "()Lio/scanbot/sdk/entity/Document;", "", "Lio/scanbot/sdk/entity/Language;", "languages", "", "(Ljava/util/Set;)V", "", "Landroid/net/Uri;", "imageFileUris", "Lio/scanbot/sdk/ocr/process/OcrResult;", "recognizeTextFromUris", "(Ljava/util/List;Ljava/util/Set;)Lio/scanbot/sdk/ocr/process/OcrResult;", "Landroid/graphics/Bitmap;", "bitmap", "recognizeTextFromBitmap", "(Landroid/graphics/Bitmap;Ljava/util/Set;)Lio/scanbot/sdk/ocr/process/OcrResult;", "Lio/scanbot/sdk/persistence/Page;", "pages", "recognizeTextFromPages", "Lio/scanbot/sdk/process/PDFPageSize;", "pageSize", "recognizeTextWithPdfFromUris", "(Ljava/util/List;Lio/scanbot/sdk/process/PDFPageSize;Ljava/util/Set;)Lio/scanbot/sdk/ocr/process/OcrResult;", "recognizeTextWithPdfFromPages", "Ljava/io/File;", "getLanguageDataPath", "()Ljava/io/File;", "getInstalledLanguages", "()Ljava/util/Set;", "Lio/scanbot/sdk/persistence/PageFileStorage;", "d", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageFileStorage", "Lio/scanbot/sdk/blob/BlobManager;", "c", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sdk/ocr/process/TextRecognition;", "b", "Lio/scanbot/sdk/ocr/process/TextRecognition;", "textRecognition", "Landroid/content/Context;", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;Lio/scanbot/sdk/ocr/process/TextRecognition;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "sdk-ocr_release"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    private final Context a;
    private final TextRecognition b;
    private final BlobManager c;
    private final PageFileStorage d;

    private final Document a() {
        Document document;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = document;
        document = new Document();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        document.id = string;
        document.name = ((Document)scanbotOpticalCharacterRecognizer).id + ".pdf";
        document.ocrStatus = OcrStatus.PENDING;
        return document;
    }

    private final void a(Set<? extends Language> languages) {
        if (!((this = SetsKt.minus(languages, ((ScanbotOpticalCharacterRecognizer)this).getInstalledLanguages())).isEmpty() ^ true)) {
            return;
        }
        throw new LanguageNotFoundException(this + " Provided set of languages was not presented on device");
    }

    /*
     * WARNING - void declaration
     */
    public ScanbotOpticalCharacterRecognizer(@NotNull Context context, @NotNull TextRecognition textRecognition, @NotNull BlobManager blobManager, @NotNull PageFileStorage pageFileStorage) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"textRecognition");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pageFileStorage");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull Set<? extends Language> languages) {
        ArrayList<Page> arrayList;
        Iterator iterator;
        void var2_2;
        void v0 = var2_2;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"languages");
        this.a((Set<? extends Language>)v0);
        ArrayList<Page> arrayList2 = arrayList;
        arrayList = new ArrayList<Page>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = imageFileUris.iterator();
        while (iterator.hasNext()) {
            ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
            Object object = (Uri)iterator.next();
            object = BitmapFactory.decodeFile((String)FileChooserUtils.getPath((Context)scanbotOpticalCharacterRecognizer.a, (Uri)object));
            PageFileStorage pageFileStorage = scanbotOpticalCharacterRecognizer.d;
            Uri uri = object;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"bitmap");
            object = pageFileStorage.add((Bitmap)uri);
            arrayList2.add(new Page((String)object, null, null, 6, null));
        }
        return this.b.withoutPDF(arrayList2, (Set<Language>)var2_2).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromBitmap(@NotNull Bitmap bitmap, @NotNull Set<? extends Language> languages) {
        void var1_1;
        void var2_2;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        void v1 = var2_2;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"languages");
        scanbotOpticalCharacterRecognizer.a((Set<? extends Language>)v1);
        return scanbotOpticalCharacterRecognizer.b.onBitmap((Bitmap)var1_1, (Set<Language>)var2_2).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        void var1_1;
        void var2_2;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        void v1 = var2_2;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"languages");
        scanbotOpticalCharacterRecognizer.a((Set<? extends Language>)v1);
        return scanbotOpticalCharacterRecognizer.b.withoutPDF((List<Page>)var1_1, (Set<Language>)var2_2).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        ArrayList<Page> arrayList;
        ArrayList<Page> arrayList2;
        Iterator iterator;
        void var3_3;
        void v0 = var3_3;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)arrayList2, (String)"pageSize");
        Intrinsics.checkNotNullParameter((Object)v0, (String)"languages");
        this.a((Set<? extends Language>)v0);
        arrayList2 = arrayList;
        arrayList = new ArrayList<Page>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = imageFileUris.iterator();
        while (iterator.hasNext()) {
            ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
            Object object = (Uri)iterator.next();
            object = BitmapFactory.decodeFile((String)FileChooserUtils.getPath((Context)scanbotOpticalCharacterRecognizer.a, (Uri)object));
            PageFileStorage pageFileStorage = scanbotOpticalCharacterRecognizer.d;
            Uri uri = object;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"bitmap");
            object = pageFileStorage.add((Bitmap)uri);
            arrayList2.add(new Page((String)object, null, null, 6, null));
        }
        return this.b.withPDF(this.a(), arrayList2, (Set<Language>)var3_3).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        void var2_2;
        void var1_1;
        void var3_3;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        void v1 = var3_3;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageSize");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"languages");
        scanbotOpticalCharacterRecognizer.a((Set<? extends Language>)v1);
        return scanbotOpticalCharacterRecognizer.b.withPDF(this.a(), (List<Page>)var1_1, (Set<Language>)var3_3).recognize();
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        return this.c.getOcrBlobsDirectory();
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        return this.c.getAllLanguagesWithAvailableOcrBlobs();
    }
}

