/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import androidx.annotation.FloatRange;
import com.googlecode.leptonica.android.Pix;

public class Binarize {
    public static final int OTSU_SIZE_X = 32;
    public static final int OTSU_SIZE_Y = 32;
    public static final int OTSU_SMOOTH_X = 2;
    public static final int OTSU_SMOOTH_Y = 2;
    public static final float OTSU_SCORE_FRACTION = 0.1f;
    public static final int SAUVOLA_DEFAULT_WINDOW_HALFWIDTH = 8;
    public static final float SAUVOLA_DEFAULT_REDUCTION_FACTOR = 0.35f;
    public static final int SAUVOLA_DEFAULT_NUM_TILES_X = 1;
    public static final int SAUVOLA_DEFAULT_NUM_TILES_Y = 1;

    public static Pix otsuAdaptiveThreshold(Pix pixs) {
        return Binarize.otsuAdaptiveThreshold(pixs, 32, 32, 2, 2, 0.1f);
    }

    /*
     * WARNING - void declaration
     */
    public static Pix otsuAdaptiveThreshold(Pix pixs, int sizeX, int sizeY, int smoothX, int smoothY, @FloatRange(from=0.0, to=1.0) float scoreFraction) {
        if (pixs != null) {
            Pix pix;
            if (pix.getDepth() == 8) {
                void var5_6;
                void var4_5;
                void var3_4;
                void var2_3;
                void var1_2;
                long l = Binarize.nativeOtsuAdaptiveThreshold(pix.getNativePix(), (int)var1_2, (int)var2_3, (int)var3_4, (int)var4_5, (float)var5_6);
                if (l != 0L) {
                    return new Pix(l);
                }
                throw new RuntimeException("Failed to perform Otsu adaptive threshold on image");
            }
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static Pix sauvolaBinarizeTiled(Pix pixs) {
        return Binarize.sauvolaBinarizeTiled(pixs, 8, 0.35f, 1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static Pix sauvolaBinarizeTiled(Pix pixs, int whsize, @FloatRange(from=0.0) float factor, int nx, int ny) {
        if (pixs != null) {
            Pix pix;
            if (pix.getDepth() == 8) {
                void var4_5;
                void var3_4;
                void var2_3;
                void var1_2;
                long l = Binarize.nativeSauvolaBinarizeTiled(pix.getNativePix(), (int)var1_2, (float)var2_3, (int)var3_4, (int)var4_5);
                if (l != 0L) {
                    return new Pix(l);
                }
                throw new RuntimeException("Failed to perform Sauvola binarization on image");
            }
            throw new IllegalArgumentException("Source pix depth must be 8bpp");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    private static native long nativeOtsuAdaptiveThreshold(long var0, int var2, int var3, int var4, int var5, float var6);

    private static native long nativeSauvolaBinarizeTiled(long var0, int var2, float var3, int var4, int var5);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }
}

