/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerConfig;
import io.scanbot.sdk.docprocessing.compose.PdfRendererInput;
import io.scanbot.sdk.docprocessing.compose.PdfRendererPagesInput;
import io.scanbot.sdk.docprocessing.compose.PdfRendererUriInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.OcrBlobException;
import io.scanbot.sdk.ocr.intelligence.OcrInput;
import io.scanbot.sdk.ocr.intelligence.OcrPagesInput;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.intelligence.OcrUrisInput;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010%\u001a\u00020#\u0012\u0006\u0010\u001f\u001a\u00020\u001d\u0012\u0006\u0010\u001c\u001a\u00020\u0019\u0012\u0006\u0010-\u001a\u00020*\u0012\u0006\u0010)\u001a\u00020&\u00a2\u0006\u0004\b.\u0010/J/\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ/\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000bJ!\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u0010J\u001f\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\n\u0010\u0013J\u0017\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\n\u0010\u0014J'\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001c\u001a\u00020\u00198\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001f\u001a\u00020\u001d8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001eR\u0016\u0010\"\u001a\u00020 8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010!R\u0016\u0010%\u001a\u00020#8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010$R\u0016\u0010)\u001a\u00020&8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010-\u001a\u00020*8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u00060"}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "Lio/scanbot/sdk/entity/Document;", "document", "Lio/scanbot/sdk/docprocessing/compose/PdfRendererInput;", "input", "", "Lio/scanbot/sdk/entity/Language;", "availableLanguages", "", "a", "(Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/docprocessing/compose/PdfRendererInput;Ljava/util/Set;)Ljava/lang/String;", "c", "b", "detectedText", "", "(Lio/scanbot/sdk/entity/Document;Ljava/lang/String;)V", "", "ocrStartedMillis", "(Lio/scanbot/sdk/entity/Document;J)V", "(Lio/scanbot/sdk/entity/Document;)V", "Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;", "config", "composeDocument", "(Lio/scanbot/sdk/entity/Document;Lio/scanbot/sdk/docprocessing/compose/PdfRendererInput;Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;)V", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "d", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "simpleComposer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "pdfRenderer", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/blob/BlobManager;", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "f", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "Lio/scanbot/sap/SapManager;", "e", "Lio/scanbot/sap/SapManager;", "sapManager", "<init>", "(Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    private final Logger a;
    private final BlobManager b;
    private final OcrPdfRenderer c;
    private final SimpleComposer d;
    private final SapManager e;
    private final OcrSettings f;

    /*
     * WARNING - void declaration
     */
    private final String a(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.c((Document)var1_1, (PdfRendererInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final String c(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        this.a.d("OCR", "Starting OCR with languages: " + var3_3);
        return this.b((Document)var1_1, (PdfRendererInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String b(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        OcrPdfRenderer.RenderIterator renderIterator;
        List list;
        OcrInput ocrInput;
        if (input instanceof PdfRendererPagesInput) {
            OcrPagesInput ocrPagesInput;
            ocrInput = ocrPagesInput;
            ocrPagesInput = new OcrPagesInput(((PdfRendererPagesInput)list).getPages());
        } else {
            OcrUrisInput ocrUrisInput;
            if (!(list instanceof PdfRendererUriInput)) {
                throw new NoWhenBranchMatchedException();
            }
            ocrInput = ocrUrisInput;
            PdfRendererUriInput pdfRendererUriInput = (PdfRendererUriInput)list;
            list = pdfRendererUriInput.getUris();
            ocrUrisInput = new OcrUrisInput(list, pdfRendererUriInput.getInputEncrypted());
        }
        renderIterator = this.c.startRender((Document)renderIterator, ocrInput, (Collection<? extends Language>)var3_3, this.f);
        try {
            while (renderIterator.renderNextPage()) {
                this.a.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
            }
            String string = renderIterator.getDetectedText();
            renderIterator.recycle();
            return string;
        }
        catch (Throwable throwable) {
            renderIterator.recycle();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Document document, String detectedText) {
        void var1_1;
        void var2_2;
        var1_1.ocrStatus = OcrStatus.DONE;
        var1_1.ocrText = var2_2;
        this.a((Document)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Document document, long ocrStartedMillis) {
        void var2_3;
        if (document.language == null) {
            return;
        }
        long l = SystemClock.elapsedRealtime() - var2_3;
        this.a.d("OCR", "Ocr total: " + (float)l / 1000.0f + " sec");
    }

    private final void a(Document document) {
        if (document.language != null) {
            String string;
            void v0 = string;
            OcrComposer ocrComposer = ocrComposer.a;
            string = "OCR";
            StringBuilder stringBuilder = new StringBuilder().append("Document language assigned: ");
            Object object = v0.language;
            object = object != null ? object.getOcrBlobLanguageTag() : null;
            ocrComposer.d(string, stringBuilder.append((String)object).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public OcrComposer(@NotNull BlobManager blobManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"ocrSettings");
        this.b = var1_1;
        this.c = var2_2;
        this.d = var3_3;
        this.e = var4_4;
        ocrComposer.f = var5_5;
        ocrComposer.a = LoggerProvider.getLogger();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void composeDocument(@NotNull Document document, @NotNull PdfRendererInput input, @NotNull ComposerConfig config) throws IOException {
        long l;
        Set set;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)set, (String)"config");
        if (!this.e.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            l = SystemClock.elapsedRealtime();
            set = this.b.getAllLanguagesWithAvailableOcrBlobs();
        }
        catch (IOException iOException) {
            Composer.DefaultImpls.composeDocument$default((Composer)this.d, (Document)var1_1, (PdfRendererInput)var2_2, null, (int)4, null);
            return;
        }
        {
            if (!set.isEmpty()) {
                this.a((Document)var1_1, this.a((Document)var1_1, (PdfRendererInput)var2_2, set));
                this.a((Document)var1_1, l);
                return;
            }
            this.a.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new OcrBlobException("OCR languages blobs are not available");
        }
    }
}

