/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerConfig;
import io.scanbot.sdk.docprocessing.compose.PdfRendererInput;
import io.scanbot.sdk.docprocessing.compose.PdfRendererPagesInput;
import io.scanbot.sdk.docprocessing.compose.PdfRendererUriInput;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.OcrBlobException;
import io.scanbot.sdk.ocr.intelligence.OcrInput;
import io.scanbot.sdk.ocr.intelligence.OcrPagesInput;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.intelligence.OcrUrisInput;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J(\u0010\u001c\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J(\u0010\u001d\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001a\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "pdfRenderer", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "simpleComposer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "sapManager", "Lio/scanbot/sap/SapManager;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "(Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "composeDocument", "", "document", "Lio/scanbot/sdk/entity/Document;", "input", "Lio/scanbot/sdk/docprocessing/compose/PdfRendererInput;", "config", "Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;", "createPDF", "", "availableLanguages", "", "Lio/scanbot/sdk/entity/Language;", "ocrWithDefaultLanguage", "performOCR", "saveMetaData", "detectedText", "trackDocument", "trackDuration", "ocrStartedMillis", "", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    @NotNull
    private final BlobManager a;
    @NotNull
    private final OcrPdfRenderer b;
    @NotNull
    private final SimpleComposer c;
    @NotNull
    private final SapManager d;
    @NotNull
    private final OcrSettings e;
    @NotNull
    private final Logger f;

    /*
     * WARNING - void declaration
     */
    public OcrComposer(@NotNull BlobManager blobManager, @NotNull OcrPdfRenderer pdfRenderer, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"ocrSettings");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
        this.d = var4_4;
        ocrComposer.e = var5_5;
        ocrComposer.f = LoggerProvider.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    private final String a(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.c((Document)var1_1, (PdfRendererInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final String c(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        this.f.d("OCR", "Starting OCR with languages: " + var3_3);
        return this.b((Document)var1_1, (PdfRendererInput)var2_2, (Set<? extends Language>)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String b(Document document, PdfRendererInput input, Set<? extends Language> availableLanguages) throws IOException {
        void var3_3;
        OcrPdfRenderer.RenderIterator renderIterator;
        List list;
        OcrInput ocrInput;
        if (input instanceof PdfRendererPagesInput) {
            OcrPagesInput ocrPagesInput;
            ocrInput = ocrPagesInput;
            ocrPagesInput = new OcrPagesInput(((PdfRendererPagesInput)list).getPages());
        } else {
            OcrUrisInput ocrUrisInput;
            if (!(list instanceof PdfRendererUriInput)) {
                throw new NoWhenBranchMatchedException();
            }
            ocrInput = ocrUrisInput;
            PdfRendererUriInput pdfRendererUriInput = (PdfRendererUriInput)list;
            list = pdfRendererUriInput.getUris();
            ocrUrisInput = new OcrUrisInput(list, pdfRendererUriInput.getInputEncrypted());
        }
        renderIterator = this.b.startRender((Document)renderIterator, ocrInput, (Collection<? extends Language>)var3_3, this.e);
        try {
            while (renderIterator.renderNextPage()) {
                this.f.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
            }
            String string = renderIterator.getDetectedText();
            renderIterator.recycle();
            return string;
        }
        catch (Throwable throwable) {
            renderIterator.recycle();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Document document, String detectedText) {
        void var1_1;
        void var2_2;
        var1_1.ocrStatus = OcrStatus.DONE;
        var1_1.ocrText = var2_2;
        this.a((Document)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Document document, long ocrStartedMillis) {
        void var2_3;
        if (document.language == null) {
            return;
        }
        long l = SystemClock.elapsedRealtime() - var2_3;
        this.f.d("OCR", "Ocr total: " + (float)l / 1000.0f + " sec");
    }

    private final void a(Document document) {
        if (document.language != null) {
            String string;
            void v0 = string;
            OcrComposer ocrComposer = ocrComposer.f;
            string = "OCR";
            StringBuilder stringBuilder = new StringBuilder().append("Document language assigned: ");
            Object object = v0.language;
            object = object != null ? object.getOcrBlobLanguageTag() : null;
            ocrComposer.d(string, stringBuilder.append((String)object).toString());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void composeDocument(@NotNull Document document, @NotNull PdfRendererInput input, @NotNull ComposerConfig config) throws IOException {
        long l;
        Set set;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"document");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)set, (String)"config");
        if (!this.d.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            l = SystemClock.elapsedRealtime();
            set = this.a.getAllLanguagesWithAvailableOcrBlobs();
        }
        catch (IOException iOException) {
            Composer.DefaultImpls.composeDocument$default((Composer)this.c, (Document)var1_1, (PdfRendererInput)var2_2, null, (int)4, null);
            return;
        }
        {
            if (!set.isEmpty()) {
                this.a((Document)var1_1, this.a((Document)var1_1, (PdfRendererInput)var2_2, set));
                this.a((Document)var1_1, l);
                return;
            }
            this.f.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new OcrBlobException("OCR languages blobs are not available");
        }
    }
}

