/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.exceptions.ocr.LanguageNotFoundException;
import io.scanbot.sdk.ocr.OpticalCharacterRecognizer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.TextRecognition;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.util.FileChooserUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J$\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J,\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J,\u0010 \u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010!\u001a\u00020\"2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J4\u0010#\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/scanbot/sdk/ocr/ScanbotOpticalCharacterRecognizer;", "Lio/scanbot/sdk/ocr/OpticalCharacterRecognizer;", "context", "Landroid/content/Context;", "textRecognition", "Lio/scanbot/sdk/ocr/process/TextRecognition;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Landroid/content/Context;Lio/scanbot/sdk/ocr/process/TextRecognition;Lio/scanbot/sdk/blob/BlobManager;)V", "checkMissingLangs", "", "languages", "", "Lio/scanbot/sdk/entity/Language;", "getInstalledLanguages", "getLanguageDataPath", "Ljava/io/File;", "getPendingDocument", "Lio/scanbot/sdk/entity/Document;", "recognizeTextFromBitmap", "Lio/scanbot/sdk/ocr/process/OcrResult;", "bitmap", "Landroid/graphics/Bitmap;", "recognizeTextFromPages", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "recognizeTextFromUris", "imageFileUris", "Landroid/net/Uri;", "sourceFilesEncrypted", "", "recognizeTextWithPdfFromPages", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "recognizeTextWithPdfFromUris", "sdk-ocr_release"})
public final class ScanbotOpticalCharacterRecognizer
implements OpticalCharacterRecognizer {
    @NotNull
    private final Context a;
    @NotNull
    private final TextRecognition b;
    @NotNull
    private final BlobManager c;

    /*
     * WARNING - void declaration
     */
    public ScanbotOpticalCharacterRecognizer(@NotNull Context context, @NotNull TextRecognition textRecognition, @NotNull BlobManager blobManager) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"textRecognition");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobManager");
        this.a = var1_1;
        this.b = var2_2;
        this.c = var3_3;
    }

    private final Document a() {
        Document document;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = document;
        document = new Document();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        ((Document)scanbotOpticalCharacterRecognizer).id = string;
        document.name = Intrinsics.stringPlus((String)string, (Object)".pdf");
        document.ocrStatus = OcrStatus.PENDING;
        return document;
    }

    private final void a(Set<? extends Language> languages) {
        if (!((this = SetsKt.minus(languages, ((ScanbotOpticalCharacterRecognizer)this).getInstalledLanguages())).isEmpty() ^ true)) {
            return;
        }
        throw new LanguageNotFoundException(this + " Provided set of languages was not presented on device");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromBitmap(@NotNull Bitmap bitmap, @NotNull Set<? extends Language> languages) {
        void var1_1;
        void var2_2;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        void v1 = var2_2;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"languages");
        scanbotOpticalCharacterRecognizer.a((Set<? extends Language>)v1);
        return scanbotOpticalCharacterRecognizer.b.onBitmap((Bitmap)var1_1, (Set<Language>)var2_2).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted, @NotNull Set<? extends Language> languages) {
        void var2_2;
        ArrayList<Uri> arrayList;
        Iterator iterator;
        void var3_3;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        void v1 = var3_3;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"languages");
        scanbotOpticalCharacterRecognizer.a((Set<? extends Language>)v1);
        TextRecognition textRecognition = scanbotOpticalCharacterRecognizer.b;
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)this.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        return textRecognition.withoutPDF(arrayList2, (boolean)var2_2, (Set<Language>)var3_3).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextFromPages(@NotNull List<Page> pages, @NotNull Set<? extends Language> languages) {
        void var1_1;
        void var2_2;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        void v1 = var2_2;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"languages");
        scanbotOpticalCharacterRecognizer.a((Set<? extends Language>)v1);
        return scanbotOpticalCharacterRecognizer.b.withoutPDF((List<Page>)var1_1, (Set<Language>)var2_2).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromUris(@NotNull List<? extends Uri> imageFileUris, boolean sourceFilesEncrypted, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        void var2_2;
        ArrayList<Uri> arrayList;
        TextRecognition textRecognition;
        Iterator iterator;
        void var4_4;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        void v1 = var4_4;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"imageFileUris");
        Intrinsics.checkNotNullParameter((Object)textRecognition, (String)"pageSize");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"languages");
        scanbotOpticalCharacterRecognizer.a((Set<? extends Language>)v1);
        textRecognition = scanbotOpticalCharacterRecognizer.b;
        Document document = scanbotOpticalCharacterRecognizer.a();
        ArrayList<Uri> arrayList2 = arrayList;
        arrayList = new ArrayList<Uri>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        for (Uri uri : imageFileUris) {
            Uri uri2 = Uri.fromFile((File)new File(FileChooserUtils.getPath((Context)this.a, (Uri)uri)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
            arrayList2.add(uri2);
        }
        return textRecognition.withPDF(document, arrayList2, (boolean)var2_2, (Set<Language>)var4_4).recognize();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public OcrResult recognizeTextWithPdfFromPages(@NotNull List<Page> pages, @NotNull PDFPageSize pageSize, @NotNull Set<? extends Language> languages) {
        void var2_2;
        void var1_1;
        void var3_3;
        ScanbotOpticalCharacterRecognizer scanbotOpticalCharacterRecognizer = this;
        void v1 = var3_3;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageSize");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"languages");
        scanbotOpticalCharacterRecognizer.a((Set<? extends Language>)v1);
        return scanbotOpticalCharacterRecognizer.b.withPDF(this.a(), (List<Page>)var1_1, (Set<Language>)var3_3).recognize();
    }

    @Override
    @NotNull
    public File getLanguageDataPath() {
        return this.c.getOcrBlobsDirectory();
    }

    @Override
    @NotNull
    public Set<Language> getInstalledLanguages() {
        return this.c.getAllLanguagesWithAvailableOcrBlobs();
    }
}

