/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class GrayQuant {
    /*
     * WARNING - void declaration
     */
    public static Pix pixThresholdToBinary(Pix pixs, int thresh) {
        if (pixs != null) {
            void var1_2;
            Pix pix;
            int n = pix.getDepth();
            if (n != 4 && n != 8) {
                throw new IllegalArgumentException("Source pix depth must be 4 or 8 bpp");
            }
            if (n == 4 && var1_2 > 16) {
                throw new IllegalArgumentException("4 bpp thresh not in {0-16}");
            }
            if (n == 8 && var1_2 > 256) {
                throw new IllegalArgumentException("8 bpp thresh not in {0-256}");
            }
            long l = GrayQuant.nativePixThresholdToBinary(pix.getNativePix(), (int)var1_2);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new RuntimeException("Failed to perform binarization");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    private static native long nativePixThresholdToBinary(long var0, int var2);
}

