/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.payformscanner;

import io.scanbot.payformscanner.PayFormScanner;
import io.scanbot.payformscanner.model.PayFormRecognitionResult;
import java.io.IOException;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.payformscanner.PayFormScanner;

public class DefaultPayFormScanner
implements PayFormScanner {
    private final io.scanbot.payformscanner.PayFormScanner payFormScanner;

    public DefaultPayFormScanner(BlobManager blobManager) {
        String ocrBlobsPath = null;
        try {
            ocrBlobsPath = blobManager.getOCRBlobsDirectory().getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("OCR blobs directory is not available.");
        }
        String banksDataFilePath = null;
        try {
            banksDataFilePath = blobManager.getBanksDataFile().getPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Banks data file is not available.");
        }
        this.payFormScanner = new io.scanbot.payformscanner.PayFormScanner(ocrBlobsPath, banksDataFilePath);
    }

    @Override
    public PayFormRecognitionResult recognizeForm(byte[] nv21, int width, int height, int orientation) {
        return this.payFormScanner.recognizeForm(nv21, width, height, orientation);
    }

    @Override
    public PayFormRecognitionResult recognizeFormBGR(byte[] bgr, int width, int height, int orientation) {
        return this.payFormScanner.recognizeFormBGR(bgr, width, height, orientation);
    }

    @Override
    public PayFormRecognitionResult recognizeFormJPEG(byte[] jpeg, int width, int height, int orientation) {
        return this.payFormScanner.recognizeFormJPEG(jpeg, width, height, orientation);
    }

    @Override
    public PayFormScanner.DetectionResult preVerifyForm(byte[] nv21, int previewWidth, int previewHeight, int orientation) {
        return this.payFormScanner.preVerifyForm(nv21, previewWidth, previewHeight, orientation);
    }

    @Override
    public PayFormScanner.DetectionResult preVerifyFormBGR(byte[] bgr, int previewWidth, int previewHeight, int orientation) {
        return this.payFormScanner.preVerifyFormBGR(bgr, previewWidth, previewHeight, orientation);
    }
}

