/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00011B'\u0012\u0006\u0010&\u001a\u00020#\u0012\u0006\u0010.\u001a\u00020+\u0012\u0006\u0010*\u001a\u00020'\u0012\u0006\u0010\"\u001a\u00020\u001f\u00a2\u0006\u0004\b/\u00100J\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\t\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0012J\u001d\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001e\u001a\u00020\u001b8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\"\u001a\u00020\u001f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010&\u001a\u00020#8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010*\u001a\u00020'8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010.\u001a\u00020+8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-\u00a8\u00062"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor;", "", "", "srcImage", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "configuration", "Lio/scanbot/sdk/persistence/Page;", "createPage$sdk_persistence_release", "([BLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;)Lio/scanbot/sdk/persistence/Page;", "createPage", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;)Lio/scanbot/sdk/persistence/Page;", "Ljava/io/File;", "file", "bitmap", "", "saveBitmapTo", "(Ljava/io/File;[B)V", "(Ljava/io/File;Landroid/graphics/Bitmap;)V", "previewFile", "image", "createPreviewTo", "(Ljava/io/File;[B)Landroid/graphics/Bitmap;", "(Ljava/io/File;Landroid/graphics/Bitmap;)Landroid/graphics/Bitmap;", "page", "erasePageData", "(Lio/scanbot/sdk/persistence/Page;)V", "Lio/scanbot/sdk/util/log/Logger;", "a", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/process/ImageProcessor;", "e", "Lio/scanbot/sdk/process/ImageProcessor;", "imageProcessor", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "b", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "contourDetector", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "d", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorage;", "c", "Lio/scanbot/sdk/persistence/PageStorage;", "pageStorage", "<init>", "(Lio/scanbot/sdk/core/contourdetector/ContourDetector;Lio/scanbot/sdk/persistence/PageStorage;Lio/scanbot/sdk/persistence/PageStorageSettings;Lio/scanbot/sdk/process/ImageProcessor;)V", "Configuration", "sdk-persistence_release"})
public final class PageStorageProcessor {
    private final Logger a;
    private final ContourDetector b;
    private final PageStorage c;
    private final PageStorageSettings d;
    private final ImageProcessor e;

    public PageStorageProcessor(@NotNull ContourDetector contourDetector, @NotNull PageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull ImageProcessor imageProcessor) {
        PageStorageProcessor pageStorageProcessor = this;
        Intrinsics.checkNotNullParameter((Object)contourDetector, (String)"contourDetector");
        Intrinsics.checkNotNullParameter((Object)pageStorage, (String)"pageStorage");
        Intrinsics.checkNotNullParameter((Object)pageStorageSettings, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)imageProcessor, (String)"imageProcessor");
        this.b = contourDetector;
        this.c = pageStorage;
        this.d = pageStorageSettings;
        pageStorageProcessor.e = imageProcessor;
        pageStorageProcessor.a = LoggerProvider.getLogger();
    }

    @NotNull
    public final Page createPage$sdk_persistence_release(@NotNull byte[] byArray, @NotNull Configuration configuration) {
        BitmapFactory.Options options;
        PageStorageProcessor pageStorageProcessor = pageStorageProcessor2;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"srcImage");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        PageStorageProcessor pageStorageProcessor2 = options;
        options = new BitmapFactory.Options();
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)pageStorageProcessor2);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"originalBitmap");
        return pageStorageProcessor.createPage$sdk_persistence_release(bitmap, configuration);
    }

    @NotNull
    public final Page createPage$sdk_persistence_release(@NotNull Bitmap bitmap, @NotNull Configuration configuration) {
        Page.Size size;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"srcImage");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        FileUtils.forceMkdir((File)((PageStorageProcessor)object).c.getPageDir(string));
        if (configuration.getImageOrientation() > 0 || configuration.getImageScale() != 1.0f) {
            float f;
            Matrix matrix;
            object2 = matrix;
            matrix = new Matrix();
            if (configuration.getImageOrientation() > 0) {
                Bitmap bitmap2 = bitmap;
                f = (float)bitmap2.getWidth() / 2.0f;
                object2.setRotate((float)configuration.getImageOrientation(), f, (float)bitmap2.getHeight() / 2.0f);
            }
            if (configuration.getImageScale() != 1.0f) {
                Configuration configuration2 = configuration;
                f = configuration2.getImageScale();
                object2.postScale(f, configuration2.getImageScale());
            }
            Bitmap bitmap3 = bitmap;
            int n = bitmap3.getWidth();
            int n2 = bitmap3.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n, (int)n2, (Matrix)object2, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(orig\u2026ap.height, matrix, false)");
        }
        PageStorageProcessor pageStorageProcessor = object;
        pageStorageProcessor.saveBitmapTo(pageStorageProcessor.c.getOriginalImage(string), bitmap);
        if (configuration.getCreatePreview()) {
            Bitmap bitmap4 = bitmap;
            double d = (double)((PageStorageProcessor)object).d.d() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
            object2 = Bitmap.createScaledBitmap((Bitmap)bitmap4, (int)((int)((double)bitmap4.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
            File file = ((PageStorageProcessor)object).c.getOriginalImagePreview(string);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"preview");
            ((PageStorageProcessor)object).saveBitmapTo(file, (Bitmap)object2);
        }
        object2 = PolygonHelper.Companion.getFullPolygon();
        DetectionResult detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
        if (configuration.getCreateDocument()) {
            CropOperation cropOperation;
            PageStorageProcessor pageStorageProcessor2 = object;
            pageStorageProcessor2.b.setRequiredAspectRatios(configuration.getRequiredAspectRatios());
            pageStorageProcessor2.b.setRectOfInterest(configuration.getRectOfInterest());
            detectionResult = pageStorageProcessor2.b.detect(bitmap);
            if (detectionResult == null) {
                detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
            }
            if (detectionResult != DetectionResult.ERROR_NOTHING_DETECTED && detectionResult != DetectionResult.ERROR_TOO_DARK && detectionResult != DetectionResult.ERROR_TOO_NOISY && (object2 = ((PageStorageProcessor)object).b.getPolygonF()) == null) {
                object2 = CollectionsKt.emptyList();
            }
            CropOperation cropOperation2 = cropOperation;
            cropOperation = new CropOperation((List)object2);
            if ((bitmap = ImageProcessor.processBitmap$default((ImageProcessor)((PageStorageProcessor)object).e, (Bitmap)bitmap, (List)CollectionsKt.listOf((Object)cropOperation2), (boolean)false, (int)4, null)) != null) {
                if (configuration.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && configuration.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE) {
                    bitmap = BitmapUtils.scaleIfNeeded((Bitmap)bitmap, (int)configuration.getDocumentImageSizeLimit().getWidth(), (int)configuration.getDocumentImageSizeLimit().getHeight());
                }
                Object object3 = object;
                ((PageStorageProcessor)object3).saveBitmapTo(((PageStorageProcessor)object3).c.getDocumentImage(string), bitmap);
                ((PageStorageProcessor)object3).saveBitmapTo(((PageStorageProcessor)object3).c.getUnfilteredDocumentImage(string), bitmap);
                if (configuration.getCreatePreview()) {
                    Object object4 = object;
                    Bitmap bitmap5 = bitmap;
                    double d = (double)((PageStorageProcessor)object).d.d() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
                    bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap5, (int)((int)((double)bitmap5.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
                    object = ((PageStorageProcessor)object).c.getDocumentImagePreview(string);
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"preview");
                    ((PageStorageProcessor)object4).saveBitmapTo((File)object, bitmap);
                    ((PageStorageProcessor)object4).saveBitmapTo(((PageStorageProcessor)object4).c.getUnfilteredDocumentImagePreview(string), bitmap);
                }
            } else {
                return new Page(null, null, null, 7, null);
            }
        }
        object = size;
        size = new Page.Size(configuration.getDocumentImageSizeLimit().getWidth(), configuration.getDocumentImageSizeLimit().getHeight());
        return new Page(string, (List)object2, detectionResult, null, (Page.Size)object, null, 0, 104, null);
    }

    public final void saveBitmapTo(@NotNull File file, @NotNull byte[] byArray) {
        BitmapFactory.Options options;
        PageStorageProcessor pageStorageProcessor = pageStorageProcessor2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"bitmap");
        PageStorageProcessor pageStorageProcessor2 = options;
        options = new BitmapFactory.Options();
        pageStorageProcessor2 = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)pageStorageProcessor2);
        Intrinsics.checkNotNullExpressionValue((Object)pageStorageProcessor2, (String)"originalBitmap");
        pageStorageProcessor.saveBitmapTo(file, (Bitmap)pageStorageProcessor2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveBitmapTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block14: {
            FileOutputStream fileOutputStream2;
            block15: {
                block13: {
                    FileOutputStream fileOutputStream3;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                    Object var3_8 = null;
                    fileOutputStream = fileOutputStream3;
                    fileOutputStream3 = new FileOutputStream(file);
                    try {
                        Bitmap.CompressFormat compressFormat;
                        block12: {
                            int n = this.d.b().ordinal();
                            if (n != 0) {
                                if (n == 1) {
                                    compressFormat = Bitmap.CompressFormat.PNG;
                                    break block12;
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            compressFormat = Bitmap.CompressFormat.JPEG;
                        }
                        Bitmap.CompressFormat compressFormat2 = compressFormat;
                        fileOutputStream2 = fileOutputStream;
                        bitmap.compress(compressFormat2, this.d.c(), (OutputStream)fileOutputStream);
                    }
                    catch (IOException iOException) {
                        break block13;
                    }
                    break block15;
                    catch (Throwable throwable2) {
                        fileOutputStream = var3_8;
                        break block14;
                    }
                    catch (IOException iOException) {
                        fileOutputStream = var3_8;
                    }
                }
                try {
                    void var1_6;
                    fileOutputStream2 = fileOutputStream;
                    this.a.logException((Throwable)var1_6);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream2);
            return;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        throw throwable2;
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File file, @NotNull byte[] object) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"previewFile");
        Intrinsics.checkNotNullParameter((Object)object, (String)"image");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length);
        object = bitmap;
        double d = this.d.d();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bitmap");
        double d2 = d / (double)Math.max(object.getHeight(), object.getWidth());
        Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d2)), (int)((int)((double)object.getHeight() * d2)), (boolean)false);
        object = bitmap2;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"preview");
        this.saveBitmapTo(file, (Bitmap)object);
        return bitmap2;
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullParameter((Object)file, (String)"previewFile");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        double d = (double)this.d.d() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
        Bitmap bitmap3 = bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((double)bitmap2.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"preview");
        this.saveBitmapTo(file, bitmap3);
        return bitmap;
    }

    public final void erasePageData(@NotNull Page serializable) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)serializable, (String)"page");
            serializable = this.c.getPageDir(((Page)serializable).getPageId());
            if (!((File)serializable).exists()) break block5;
            if (!((File)serializable).isDirectory()) break block5;
            try {
                FileUtils.deleteDirectory((File)serializable);
            }
            catch (IOException iOException) {
                this.a.logException((Throwable)iOException);
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0018\b\u0086\b\u0018\u0000 52\u00020\u0001:\u000256BS\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0019\u001a\u00020\t\u0012\b\b\u0002\u0010\u001a\u001a\u00020\f\u0012\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u0013\u00a2\u0006\u0004\b3\u00104J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\\\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0016\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\u001a\u001a\u00020\f2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u0013H\u00c6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010\u000eJ\u001a\u0010$\u001a\u00020\u00022\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b$\u0010%R\u0019\u0010\u0016\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010&\u001a\u0004\b'\u0010\u0004R\u0019\u0010\u0017\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010&\u001a\u0004\b(\u0010\u0004R\u0019\u0010\u001c\u001a\u00020\u00138\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010)\u001a\u0004\b*\u0010\u0015R\u0019\u0010\u0019\u001a\u00020\t8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010+\u001a\u0004\b,\u0010\u000bR\u001f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010-\u001a\u0004\b.\u0010\u0012R\u0019\u0010\u0018\u001a\u00020\u00068\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010/\u001a\u0004\b0\u0010\bR\u0019\u0010\u001a\u001a\u00020\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001a\u00101\u001a\u0004\b2\u0010\u000e\u00a8\u00067"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "", "component1", "()Z", "component2", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "component3", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "", "component4", "()F", "", "component5", "()I", "", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "component6", "()Ljava/util/List;", "Landroid/graphics/RectF;", "component7", "()Landroid/graphics/RectF;", "createPreview", "createDocument", "documentImageSizeLimit", "imageScale", "imageOrientation", "requiredAspectRatios", "rectOfInterest", "copy", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;)Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "toString", "()Ljava/lang/String;", "hashCode", "other", "equals", "(Ljava/lang/Object;)Z", "Z", "getCreatePreview", "getCreateDocument", "Landroid/graphics/RectF;", "getRectOfInterest", "F", "getImageScale", "Ljava/util/List;", "getRequiredAspectRatios", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "getDocumentImageSizeLimit", "I", "getImageOrientation", "<init>", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;)V", "Companion", "Size", "sdk-persistence_release"})
    public static final class Configuration {
        public static final Companion Companion = new Companion(null);
        private final boolean createPreview;
        private final boolean createDocument;
        @NotNull
        private final Size documentImageSizeLimit;
        private final float imageScale;
        private final int imageOrientation;
        @NotNull
        private final List<PageAspectRatio> requiredAspectRatios;
        @NotNull
        private final RectF rectOfInterest;

        public Configuration(boolean bl, boolean bl2, @NotNull Size size, float f, int n, @NotNull List<PageAspectRatio> list, @NotNull RectF rectF) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"documentImageSizeLimit");
            Intrinsics.checkNotNullParameter(list, (String)"requiredAspectRatios");
            Intrinsics.checkNotNullParameter((Object)rectF, (String)"rectOfInterest");
            this.createPreview = bl;
            this.createDocument = bl2;
            this.documentImageSizeLimit = size;
            this.imageScale = f;
            this.imageOrientation = n;
            this.requiredAspectRatios = list;
            this.rectOfInterest = rectF;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            if ((n2 & 4) != 0) {
                Size size2;
                size = size2;
                size2 = new Size(0, 0, 3, null);
            }
            if ((n2 & 8) != 0) {
                f = 1.0f;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                ArrayList arrayList;
                list = arrayList;
                arrayList = new ArrayList();
            }
            if ((n2 & 0x40) != 0) {
                RectF rectF2;
                rectF = rectF2;
                rectF2 = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            }
            this(bl, bl2, size, f, n, list, rectF);
        }

        public Configuration() {
            this(false, false, null, 0.0f, 0, null, null, 127, null);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = configuration.createPreview;
            }
            if ((n2 & 2) != 0) {
                bl2 = configuration.createDocument;
            }
            if ((n2 & 4) != 0) {
                size = configuration.documentImageSizeLimit;
            }
            if ((n2 & 8) != 0) {
                f = configuration.imageScale;
            }
            if ((n2 & 0x10) != 0) {
                n = configuration.imageOrientation;
            }
            if ((n2 & 0x20) != 0) {
                list = configuration.requiredAspectRatios;
            }
            if ((n2 & 0x40) != 0) {
                rectF = configuration.rectOfInterest;
            }
            return configuration.copy(bl, bl2, size, f, n, list, rectF);
        }

        @JvmStatic
        @NotNull
        public static final Configuration DEFAULT() {
            return Companion.DEFAULT();
        }

        public final boolean getCreatePreview() {
            return this.createPreview;
        }

        public final boolean getCreateDocument() {
            return this.createDocument;
        }

        @NotNull
        public final Size getDocumentImageSizeLimit() {
            return this.documentImageSizeLimit;
        }

        public final float getImageScale() {
            return this.imageScale;
        }

        public final int getImageOrientation() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        public final boolean component1() {
            return this.createPreview;
        }

        public final boolean component2() {
            return this.createDocument;
        }

        @NotNull
        public final Size component3() {
            return this.documentImageSizeLimit;
        }

        public final float component4() {
            return this.imageScale;
        }

        public final int component5() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> component6() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF component7() {
            return this.rectOfInterest;
        }

        @NotNull
        public final Configuration copy(boolean bl, boolean bl2, @NotNull Size size, float f, int n, @NotNull List<PageAspectRatio> list, @NotNull RectF rectF) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"documentImageSizeLimit");
            Intrinsics.checkNotNullParameter(list, (String)"requiredAspectRatios");
            Intrinsics.checkNotNullParameter((Object)rectF, (String)"rectOfInterest");
            return new Configuration(bl, bl2, size, f, n, list, rectF);
        }

        @NotNull
        public String toString() {
            return "Configuration(createPreview=" + this.createPreview + ", createDocument=" + this.createDocument + ", documentImageSizeLimit=" + this.documentImageSizeLimit + ", imageScale=" + this.imageScale + ", imageOrientation=" + this.imageOrientation + ", requiredAspectRatios=" + this.requiredAspectRatios + ", rectOfInterest=" + this.rectOfInterest + ")";
        }

        public int hashCode() {
            int n = this.createPreview ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            n *= 31;
            int n2 = this.createDocument ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            n = (n + n2) * 31;
            Size size = this.documentImageSizeLimit;
            int n3 = size != null ? size.hashCode() : 0;
            n = (((n + n3) * 31 + Float.hashCode(this.imageScale)) * 31 + Integer.hashCode(this.imageOrientation)) * 31;
            List<PageAspectRatio> list = this.requiredAspectRatios;
            int n4 = list != null ? ((Object)list).hashCode() : 0;
            int n5 = (n + n4) * 31;
            RectF rectF = this.rectOfInterest;
            int n6 = rectF != null ? rectF.hashCode() : 0;
            return n5 + n6;
        }

        public boolean equals(@Nullable Object object) {
            block2: {
                block3: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    object = (Configuration)object;
                    if (this.createPreview == ((Configuration)object).createPreview && this.createDocument == ((Configuration)object).createDocument && Intrinsics.areEqual((Object)this.documentImageSizeLimit, (Object)((Configuration)object).documentImageSizeLimit) && Float.compare(this.imageScale, ((Configuration)object).imageScale) == 0 && this.imageOrientation == ((Configuration)object).imageOrientation && Intrinsics.areEqual(this.requiredAspectRatios, ((Configuration)object).requiredAspectRatios) && Intrinsics.areEqual((Object)this.rectOfInterest, (Object)((Configuration)object).rectOfInterest)) break block2;
                }
                return false;
            }
            return true;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\r\u0010\u0004J\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0007\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0004R\u0019\u0010\u0006\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0013\u001a\u0004\b\u0015\u0010\u0004\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "Ljava/io/Serializable;", "", "component1", "()I", "component2", "width", "height", "copy", "(II)Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "", "toString", "()Ljava/lang/String;", "hashCode", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "I", "getHeight", "getWidth", "<init>", "(II)V", "sdk-persistence_release"})
        public static final class Size
        implements Serializable {
            private final int width;
            private final int height;

            public Size(int n, int n2) {
                this.width = n;
                this.height = n2;
            }

            public /* synthetic */ Size(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    n = Integer.MAX_VALUE;
                }
                if ((n3 & 2) != 0) {
                    n2 = Integer.MAX_VALUE;
                }
                this(n, n2);
            }

            public Size() {
                this(0, 0, 3, null);
            }

            public static /* synthetic */ Size copy$default(Size size, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = size.width;
                }
                if ((n3 & 2) != 0) {
                    n2 = size.height;
                }
                return size.copy(n, n2);
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            public final int component1() {
                return this.width;
            }

            public final int component2() {
                return this.height;
            }

            @NotNull
            public final Size copy(int n, int n2) {
                return new Size(n, n2);
            }

            @NotNull
            public String toString() {
                return "Size(width=" + this.width + ", height=" + this.height + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.width) * 31 + Integer.hashCode(this.height);
            }

            public boolean equals(@Nullable Object object) {
                block2: {
                    block3: {
                        if (this == object) break block2;
                        if (!(object instanceof Size)) break block3;
                        object = (Size)object;
                        if (this.width == ((Size)object).width && this.height == ((Size)object).height) break block2;
                    }
                    return false;
                }
                return true;
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Companion;", "", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "DEFAULT", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "<init>", "()V", "sdk-persistence_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
                this();
            }

            @JvmStatic
            @NotNull
            public final Configuration DEFAULT() {
                return new Configuration(false, false, null, 0.0f, 0, null, null, 127, null);
            }
        }
    }
}

