/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.util.FileUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class DocumentStoreStrategy {
    private static final String THUMBNAIL_FILE_NAME = "thumbnail";
    private static final String SNAPPING_DOCUMENTS_DIR_NAME = "snapping_documents";
    private static final String IMAGE_FILE_NAME_PATTERN = "%s(%d)%s";
    private static final String DEFAULT_DOC_INDEX_SUFFIX = " (1).";
    private final Context context;
    private final SharedPreferences preferences;
    private final Logger logger = LoggerProvider.getLogger();

    public DocumentStoreStrategy(Context context, SharedPreferences preferences) {
        this.context = context;
        this.preferences = preferences;
    }

    public boolean ensureDocumentDir(File docDir) {
        File[] files;
        return docDir != null && docDir.exists() && (files = docDir.listFiles()) != null && files.length >= 1;
    }

    public File getDocumentsDir() throws IOException {
        String dirPath = this.preferences.getString("CUSTOM_SDK_FILES_PATH", "");
        if (!dirPath.isEmpty()) {
            return FileUtils.getFilesDirOrShowError((String)dirPath, (String)SNAPPING_DOCUMENTS_DIR_NAME);
        }
        return FileUtils.getFilesDirOrShowError((String)FileUtils.getAppFilesDirOrShowError((Context)this.context, (String)"scanbot-sdk").getPath(), (String)SNAPPING_DOCUMENTS_DIR_NAME);
    }

    public File getDocumentDir(String docId) throws IOException {
        File documentsDir = this.getDocumentsDir();
        return FileUtils.getFilesDirOrShowError((String)documentsDir.getPath(), (String)docId);
    }

    public void ensureDocumentDirectory(String docId) throws IOException {
        File documentDir = this.getDocumentDir(docId);
        org.apache.commons.io.FileUtils.forceMkdir((File)documentDir);
    }

    public File getDocumentFile(String docId, String name) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getDocumentDir(docId), (String[])new String[]{name});
    }

    public List<File> getDocumentsFiles() throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File baseDocsDir = this.getDocumentsDir();
        for (File docDir : baseDocsDir.listFiles()) {
            File[] documentFiles = docDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.endsWith(".jpg") || filename.endsWith(".pdf");
                }
            });
            files.addAll(Arrays.asList(documentFiles));
        }
        return files;
    }

    public File getThumbnailFile(String docId) throws IOException {
        File documentsDir = this.getDocumentsDir();
        return org.apache.commons.io.FileUtils.getFile((File)documentsDir, (String[])new String[]{docId, THUMBNAIL_FILE_NAME});
    }

    public void eraseDocument(String docId, String docName) {
        try {
            org.apache.commons.io.FileUtils.deleteQuietly((File)this.getDocumentFile(docId, docName));
            org.apache.commons.io.FileUtils.deleteQuietly((File)this.getDocumentDir(docId));
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
    }

    public void eraseDocumentThumbnail(String docId) {
        try {
            org.apache.commons.io.FileUtils.deleteQuietly((File)this.getThumbnailFile(docId));
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
    }

    public boolean renameDocument(String docId, String oldName, String newName) throws IOException {
        newName = this.getUniqueName(newName);
        File newDocumentFile = this.getDocumentFile(docId, newName);
        return this.getDocumentFile(docId, oldName).renameTo(newDocumentFile);
    }

    public String getUniqueName(String newName) {
        while (true) {
            String baseExtension;
            String extensionSuffix = TextUtils.isEmpty((CharSequence)(baseExtension = FilenameUtils.getExtension((String)newName))) ? "" : "." + baseExtension;
            String baseNameWithIndex = FilenameUtils.getBaseName((String)newName);
            int startIndexPosition = baseNameWithIndex.lastIndexOf("(");
            int endIndexPosition = baseNameWithIndex.lastIndexOf(")");
            Integer currentIndex = 0;
            String baseName = FilenameUtils.getBaseName((String)newName);
            if (startIndexPosition >= 0 && endIndexPosition >= 0 && endIndexPosition > startIndexPosition) {
                try {
                    currentIndex = Integer.valueOf(baseNameWithIndex.substring(startIndexPosition + 1, endIndexPosition));
                    baseName = baseNameWithIndex.substring(0, startIndexPosition - 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                boolean tryAgain = false;
                for (File file : this.getDocumentsFiles()) {
                    if (!FilenameUtils.getBaseName((String)file.getName()).equals(baseNameWithIndex)) continue;
                    newName = baseName + " (" + (currentIndex + 1) + ")" + extensionSuffix;
                    tryAgain = true;
                    break;
                }
                if (!tryAgain) break;
            }
            catch (IOException e) {
                this.logger.logException((Throwable)e);
                break;
            }
        }
        return newName;
    }

    public String getPageImagePath(int pagePosition, Document document) throws IOException {
        return String.format(IMAGE_FILE_NAME_PATTERN, FilenameUtils.removeExtension((String)this.getDocumentFile(document.id, document.name).getPath()), pagePosition, ".jpg");
    }

    public void migrateDocuments(String newPath, List<Document> documents) {
        boolean saveOnSdCard = !TextUtils.isEmpty((CharSequence)newPath);
        for (Document document : documents) {
            try {
                String name = document.name;
                String id = document.id;
                File newDir = saveOnSdCard ? new File(newPath) : this.getDocumentDir(id);
                String newName = name;
                if (org.apache.commons.io.FileUtils.getFile((File)newDir, (String[])new String[]{name}).exists()) {
                    String extension = FilenameUtils.getExtension((String)name);
                    String baseNameWithIndex = FilenameUtils.getBaseName((String)name);
                    newName = baseNameWithIndex + DEFAULT_DOC_INDEX_SUFFIX + extension;
                    this.renameDocument(id, name, newName);
                }
                org.apache.commons.io.FileUtils.moveFileToDirectory((File)this.getDocumentFile(id, newName), (File)newDir, (boolean)true);
            }
            catch (IOException e) {
                this.logger.logException((Throwable)e);
            }
        }
    }
}

