/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.net.Uri;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage$WhenMappings;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001'B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eJ\u001a\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000e2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0014\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\u000e\u0010#\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\bJ\u001e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010&\u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010&\u001a\u00020!2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/scanbot/sdk/persistence/PageFileStorage;", "", "pageStorageProcessor", "Lio/scanbot/sdk/persistence/PageStorageProcessor;", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "(Lio/scanbot/sdk/persistence/PageStorageProcessor;Lio/scanbot/sdk/persistence/PageStorage;)V", "add", "", "image", "Landroid/graphics/Bitmap;", "Lio/scanbot/sdk/persistence/Page;", "configuration", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "generateAndSetFilteredPreviewForId", "filteredImage", "existingPageId", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "getFilteredPreviewImageURI", "Landroid/net/Uri;", "pageId", "getImageURI", "type", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "getPreviewImageURI", "getStoredPages", "", "remove", "", "removeAll", "removeAllExcept", "", "pageIds", "removeFilteredPreviewImages", "setFilteredPreviewForId", "filteredPreview", "setImageForId", "PageFileType", "sdk-persistence_release"})
public final class PageFileStorage {
    private final PageStorageProcessor pageStorageProcessor;
    private final PageStorage pageStorage;

    @NotNull
    public final Uri getImageURI(@NotNull String pageId, @NotNull PageFileType type) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Uri uri2 = Uri.fromFile((File)this.pageStorage.getOriginalImage(pageId));
                uri = uri2;
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"Uri.fromFile(pageStorage.getOriginalImage(pageId))");
                break;
            }
            case 2: {
                Uri uri3 = Uri.fromFile((File)this.pageStorage.getDocumentImage(pageId));
                uri = uri3;
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"Uri.fromFile(pageStorage.getDocumentImage(pageId))");
                break;
            }
            case 3: {
                Uri uri4 = Uri.fromFile((File)this.pageStorage.getUnfilteredDocumentImage(pageId));
                uri = uri4;
                Intrinsics.checkNotNullExpressionValue((Object)uri4, (String)"Uri.fromFile(pageStorage\u2026redDocumentImage(pageId))");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return uri;
    }

    @NotNull
    public final Uri getPreviewImageURI(@NotNull String pageId, @NotNull PageFileType type) {
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                Uri uri2 = Uri.fromFile((File)this.pageStorage.getOriginalImagePreview(pageId));
                uri = uri2;
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"Uri.fromFile(pageStorage\u2026inalImagePreview(pageId))");
                break;
            }
            case 2: {
                Uri uri3 = Uri.fromFile((File)this.pageStorage.getDocumentImagePreview(pageId));
                uri = uri3;
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"Uri.fromFile(pageStorage\u2026mentImagePreview(pageId))");
                break;
            }
            case 3: {
                Uri uri4 = Uri.fromFile((File)this.pageStorage.getUnfilteredDocumentImagePreview(pageId));
                uri = uri4;
                Intrinsics.checkNotNullExpressionValue((Object)uri4, (String)"Uri.fromFile(pageStorage\u2026mentImagePreview(pageId))");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return uri;
    }

    @NotNull
    public final Uri getFilteredPreviewImageURI(@NotNull String pageId, @NotNull ImageFilterType filter) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Uri uri = Uri.fromFile((File)this.pageStorage.getFilteredImagePreview(pageId, filter));
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(pageStorage\u2026ePreview(pageId, filter))");
        return uri;
    }

    public final void removeFilteredPreviewImages(@NotNull String pageId) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        for (ImageFilterType filter : ImageFilterType.values()) {
            File file = this.pageStorage.getFilteredImagePreview(pageId, filter);
            if (!file.exists()) continue;
            file.delete();
        }
    }

    @NotNull
    public final String add(@NotNull byte[] image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.add(image, PageStorageProcessor.Configuration.Companion.DEFAULT()).getPageId();
    }

    @NotNull
    public final String add(@NotNull Bitmap image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.add(image, PageStorageProcessor.Configuration.Companion.DEFAULT()).getPageId();
    }

    private final Page add(byte[] image, PageStorageProcessor.Configuration configuration) {
        return this.pageStorageProcessor.createPage$sdk_persistence_release(image, configuration);
    }

    static /* synthetic */ Page add$default(PageFileStorage pageFileStorage, byte[] byArray, PageStorageProcessor.Configuration configuration, int n, Object object) {
        if ((n & 2) != 0) {
            configuration = PageStorageProcessor.Configuration.Companion.DEFAULT();
        }
        return pageFileStorage.add(byArray, configuration);
    }

    private final Page add(Bitmap image, PageStorageProcessor.Configuration configuration) {
        return this.pageStorageProcessor.createPage$sdk_persistence_release(image, configuration);
    }

    static /* synthetic */ Page add$default(PageFileStorage pageFileStorage, Bitmap bitmap, PageStorageProcessor.Configuration configuration, int n, Object object) {
        if ((n & 2) != 0) {
            configuration = PageStorageProcessor.Configuration.Companion.DEFAULT();
        }
        return pageFileStorage.add(bitmap, configuration);
    }

    public final void setImageForId(@NotNull byte[] image, @NotNull String existingPageId, @NotNull PageFileType type) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$2[type.ordinal()]) {
            case 1: {
                file2 = this.pageStorage.getOriginalImage(existingPageId);
                break;
            }
            case 2: {
                file2 = this.pageStorage.getDocumentImage(existingPageId);
                break;
            }
            case 3: {
                file2 = this.pageStorage.getUnfilteredDocumentImage(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file3 = file2;
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$3[type.ordinal()]) {
            case 1: {
                file = this.pageStorage.getOriginalImagePreview(existingPageId);
                break;
            }
            case 2: {
                file = this.pageStorage.getDocumentImagePreview(existingPageId);
                break;
            }
            case 3: {
                file = this.pageStorage.getUnfilteredDocumentImagePreview(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File previewFile = file;
        this.pageStorageProcessor.saveBitmapTo(file3, image);
        this.pageStorageProcessor.createPreviewTo(previewFile, image);
    }

    public final void setImageForId(@NotNull Bitmap image, @NotNull String existingPageId, @NotNull PageFileType type) {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$4[type.ordinal()]) {
            case 1: {
                file2 = this.pageStorage.getOriginalImage(existingPageId);
                break;
            }
            case 2: {
                file2 = this.pageStorage.getDocumentImage(existingPageId);
                break;
            }
            case 3: {
                file2 = this.pageStorage.getUnfilteredDocumentImage(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file3 = file2;
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$5[type.ordinal()]) {
            case 1: {
                file = this.pageStorage.getOriginalImagePreview(existingPageId);
                break;
            }
            case 2: {
                file = this.pageStorage.getDocumentImagePreview(existingPageId);
                break;
            }
            case 3: {
                file = this.pageStorage.getUnfilteredDocumentImagePreview(existingPageId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File previewFile = file;
        this.pageStorageProcessor.saveBitmapTo(file3, image);
        this.pageStorageProcessor.createPreviewTo(previewFile, image);
    }

    public final void setFilteredPreviewForId(@NotNull byte[] filteredPreview, @NotNull String existingPageId, @NotNull ImageFilterType filter) {
        Intrinsics.checkNotNullParameter((Object)filteredPreview, (String)"filteredPreview");
        Intrinsics.checkNotNullParameter((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        File filteredPreviewFile = this.pageStorage.getFilteredImagePreview(existingPageId, filter);
        this.pageStorageProcessor.saveBitmapTo(filteredPreviewFile, filteredPreview);
    }

    public final void setFilteredPreviewForId(@NotNull Bitmap filteredPreview, @NotNull String existingPageId, @NotNull ImageFilterType filter) {
        Intrinsics.checkNotNullParameter((Object)filteredPreview, (String)"filteredPreview");
        Intrinsics.checkNotNullParameter((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        File filteredPreviewFile = this.pageStorage.getFilteredImagePreview(existingPageId, filter);
        this.pageStorageProcessor.saveBitmapTo(filteredPreviewFile, filteredPreview);
    }

    @NotNull
    public final Bitmap generateAndSetFilteredPreviewForId(@NotNull byte[] filteredImage, @NotNull String existingPageId, @NotNull ImageFilterType filter) {
        Intrinsics.checkNotNullParameter((Object)filteredImage, (String)"filteredImage");
        Intrinsics.checkNotNullParameter((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        File filteredPreviewFile = this.pageStorage.getFilteredImagePreview(existingPageId, filter);
        return this.pageStorageProcessor.createPreviewTo(filteredPreviewFile, filteredImage);
    }

    @NotNull
    public final Bitmap generateAndSetFilteredPreviewForId(@NotNull Bitmap filteredImage, @NotNull String existingPageId, @NotNull ImageFilterType filter) {
        Intrinsics.checkNotNullParameter((Object)filteredImage, (String)"filteredImage");
        Intrinsics.checkNotNullParameter((Object)existingPageId, (String)"existingPageId");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        File filteredPreviewFile = this.pageStorage.getFilteredImagePreview(existingPageId, filter);
        return this.pageStorageProcessor.createPreviewTo(filteredPreviewFile, filteredImage);
    }

    public final boolean remove(@NotNull String pageId) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        return FilesKt.deleteRecursively((File)this.pageStorage.getPageDir(pageId));
    }

    public final boolean removeAll() {
        return FilesKt.deleteRecursively((File)this.pageStorage.getPagesDirectory());
    }

    @NotNull
    public final List<String> getStoredPages() throws IOException {
        return this.pageStorage.getStoredPages();
    }

    public final void removeAllExcept(@NotNull List<String> pageIds) {
        Intrinsics.checkNotNullParameter(pageIds, (String)"pageIds");
        List filesToRemove = new ArrayList();
        File[] fileArray = this.pageStorage.getPagesDirectory().listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File listFile;
            File file = listFile = fileArray[i];
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"listFile");
            if (pageIds.contains(file.getName())) continue;
            filesToRemove.add(listFile);
        }
        for (File file : filesToRemove) {
            file.delete();
        }
    }

    public PageFileStorage(@NotNull PageStorageProcessor pageStorageProcessor, @NotNull PageStorage pageStorage) {
        Intrinsics.checkNotNullParameter((Object)pageStorageProcessor, (String)"pageStorageProcessor");
        Intrinsics.checkNotNullParameter((Object)pageStorage, (String)"pageStorage");
        this.pageStorageProcessor = pageStorageProcessor;
        this.pageStorage = pageStorage;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "", "(Ljava/lang/String;I)V", "ORIGINAL", "DOCUMENT", "UNFILTERED_DOCUMENT", "sdk-persistence_release"})
    public static final class PageFileType
    extends Enum<PageFileType> {
        public static final /* enum */ PageFileType ORIGINAL;
        public static final /* enum */ PageFileType DOCUMENT;
        public static final /* enum */ PageFileType UNFILTERED_DOCUMENT;
        private static final /* synthetic */ PageFileType[] $VALUES;

        static {
            PageFileType[] pageFileTypeArray = new PageFileType[3];
            PageFileType[] pageFileTypeArray2 = pageFileTypeArray;
            pageFileTypeArray[0] = ORIGINAL = new PageFileType();
            pageFileTypeArray[1] = DOCUMENT = new PageFileType();
            pageFileTypeArray[2] = UNFILTERED_DOCUMENT = new PageFileType();
            $VALUES = pageFileTypeArray;
        }

        public static PageFileType[] values() {
            return (PageFileType[])$VALUES.clone();
        }

        public static PageFileType valueOf(String string) {
            return Enum.valueOf(PageFileType.class, string);
        }
    }
}

