/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode.batch;

import io.reactivex.Completable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.BehaviorProcessor;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.FormattedBarcodeDataMapper;
import io.scanbot.sdk.ui.di.BackgroundTaskScheduler;
import io.scanbot.sdk.ui.utils.CrossViewStatePresenter;
import io.scanbot.sdk.ui.utils.StatelessView;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.barcode.LastScannedBarcodeHolder;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeListPresenter;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeListPresenter$sam$io_reactivex_functions_Consumer$0;
import io.scanbot.sdk.ui.view.barcode.batch.IBatchBarcodeListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0002'(B)\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u000e\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J3\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0!\"\u0004\b\u0000\u0010\"*\b\u0012\u0004\u0012\u0002H\"0#2\u0006\u0010$\u001a\u0002H\"2\u0006\u0010%\u001a\u0002H\"H\u0002\u00a2\u0006\u0002\u0010&R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/ui/view/barcode/batch/BatchBarcodeListPresenter;", "Lio/scanbot/sdk/ui/utils/CrossViewStatePresenter;", "Lio/scanbot/sdk/ui/view/barcode/batch/IBatchBarcodeListView$State;", "Lio/scanbot/sdk/ui/view/barcode/batch/IBatchBarcodeListView;", "Lio/scanbot/sdk/ui/view/barcode/batch/IBatchBarcodeListView$Listener;", "navigator", "Lio/scanbot/sdk/ui/utils/navigator/Navigator;", "dataMapper", "Lio/scanbot/sdk/barcode/entity/FormattedBarcodeDataMapper;", "lastScannedBarcodeHolder", "Lio/scanbot/sdk/ui/view/barcode/LastScannedBarcodeHolder;", "backgroundTaskScheduler", "Lio/reactivex/Scheduler;", "(Lio/scanbot/sdk/ui/utils/navigator/Navigator;Lio/scanbot/sdk/barcode/entity/FormattedBarcodeDataMapper;Lio/scanbot/sdk/ui/view/barcode/LastScannedBarcodeHolder;Lio/reactivex/Scheduler;)V", "detailsOpened", "", "subscribtions", "Lio/reactivex/disposables/CompositeDisposable;", "clearClick", "", "deleteScannedBarcode", "barcodeItem", "Lio/scanbot/sdk/barcode/entity/BarcodeItem;", "detailsClosed", "pause", "processBarcodeWithDefaultMapper", "newItem", "processBarcodeWithMapper", "processNewBarcode", "resume", "view", "submitButtonClick", "replace", "", "E", "", "old", "new", "(Ljava/lang/Iterable;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "BarcodesScanFinished", "NewBarcodeProcessed", "rtu-ui-barcode_release"})
public final class BatchBarcodeListPresenter
extends CrossViewStatePresenter<IBatchBarcodeListView.State, IBatchBarcodeListView>
implements IBatchBarcodeListView.Listener {
    private final CompositeDisposable subscribtions;
    private boolean detailsOpened;
    private final Navigator navigator;
    private final FormattedBarcodeDataMapper dataMapper;
    private final LastScannedBarcodeHolder lastScannedBarcodeHolder;
    private final Scheduler backgroundTaskScheduler;

    public void resume(@NotNull IBatchBarcodeListView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.resume((StatelessView)view);
        view.setListener(this);
        if (this.state == null) {
            this.updateState(IBatchBarcodeListView.State.Companion.getDEFAULT());
        }
        Function1 function1 = (Function1)new Function1<BarcodeItem, Unit>(this){

            public final void invoke(@NotNull BarcodeItem p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                BatchBarcodeListPresenter.access$processNewBarcode((BatchBarcodeListPresenter)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(BatchBarcodeListPresenter.class);
            }

            public final String getName() {
                return "processNewBarcode";
            }

            public final String getSignature() {
                return "processNewBarcode(Lio/scanbot/sdk/barcode/entity/BarcodeItem;)V";
            }
        };
        this.subscribtions.add(this.lastScannedBarcodeHolder.observeBarcodeScanningResults().filter((Predicate)resume.1.INSTANCE).map((Function)resume.2.INSTANCE).filter((Predicate)new Predicate<BarcodeItem>(this){
            final /* synthetic */ BatchBarcodeListPresenter this$0;

            public final boolean test(@NotNull BarcodeItem newItem) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)newItem, (String)"newItem");
                    Object object = BatchBarcodeListPresenter.access$getState$p(this.this$0).getBarcodes().getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.state.barcodes.value");
                    Iterable $this$none$iv = (Iterable)object;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            BarcodeItem it = (BarcodeItem)element$iv;
                            boolean bl2 = false;
                            if (!(it.getBarcodeFormat() == newItem.getBarcodeFormat() && Intrinsics.areEqual((Object)it.getText(), (Object)newItem.getText()))) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
            {
                this.this$0 = batchBarcodeListPresenter;
            }
        }).subscribe((Consumer)new BatchBarcodeListPresenter$sam$io_reactivex_functions_Consumer$0(function1)));
    }

    private final void processNewBarcode(BarcodeItem newItem) {
        if (!this.detailsOpened) {
            if (!(this.dataMapper instanceof FormattedBarcodeDataMapper.Companion.DefaultFormattedBarcodeDataMapper)) {
                this.processBarcodeWithMapper(newItem);
            } else {
                this.processBarcodeWithDefaultMapper(newItem);
            }
            this.navigator.navigate((Object)new NewBarcodeProcessed());
        }
    }

    private final void processBarcodeWithMapper(BarcodeItem newItem) {
        BehaviorProcessor<List<BarcodeItem>> behaviorProcessor = ((IBatchBarcodeListView.State)this.state).getBarcodes();
        Object object = ((IBatchBarcodeListView.State)this.state).getBarcodes().getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.state.barcodes.value");
        behaviorProcessor.onNext((Object)CollectionsKt.plus((Collection)((Collection)object), (Object)newItem));
        this.subscribtions.add(Completable.fromAction((Action)new Action(this, newItem){
            final /* synthetic */ BatchBarcodeListPresenter this$0;
            final /* synthetic */ BarcodeItem $newItem;

            public final void run() {
                BarcodeItem formattedItem = new BarcodeItem(this.$newItem, BatchBarcodeListPresenter.access$getDataMapper$p(this.this$0).decodeFormattedData(this.$newItem));
                List currentValue = (List)BatchBarcodeListPresenter.access$getState$p(this.this$0).getBarcodes().getValue();
                if (currentValue.contains(this.$newItem)) {
                    BehaviorProcessor<List<BarcodeItem>> behaviorProcessor = BatchBarcodeListPresenter.access$getState$p(this.this$0).getBarcodes();
                    List list = currentValue;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"currentValue");
                    behaviorProcessor.onNext((Object)BatchBarcodeListPresenter.access$replace(this.this$0, list, this.$newItem, formattedItem));
                }
            }
            {
                this.this$0 = batchBarcodeListPresenter;
                this.$newItem = barcodeItem;
            }
        }).subscribeOn(this.backgroundTaskScheduler).subscribe());
    }

    private final void processBarcodeWithDefaultMapper(BarcodeItem newItem) {
        BarcodeItem formattedItem = new BarcodeItem(newItem, this.dataMapper.decodeFormattedData(newItem));
        BehaviorProcessor<List<BarcodeItem>> behaviorProcessor = ((IBatchBarcodeListView.State)this.state).getBarcodes();
        Object object = ((IBatchBarcodeListView.State)this.state).getBarcodes().getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.state.barcodes.value");
        behaviorProcessor.onNext((Object)CollectionsKt.plus((Collection)((Collection)object), (Object)formattedItem));
    }

    public void pause() {
        super.pause();
        this.subscribtions.clear();
    }

    @Override
    public void submitButtonClick() {
        Object object = ((IBatchBarcodeListView.State)this.state).getBarcodes().getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.state.barcodes.value");
        this.navigator.navigate((Object)new BarcodesScanFinished((List)object));
    }

    @Override
    public void deleteScannedBarcode(@NotNull BarcodeItem barcodeItem) {
        Intrinsics.checkParameterIsNotNull((Object)barcodeItem, (String)"barcodeItem");
        BehaviorProcessor<List<BarcodeItem>> behaviorProcessor = ((IBatchBarcodeListView.State)this.state).getBarcodes();
        Object object = ((IBatchBarcodeListView.State)this.state).getBarcodes().getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.state.barcodes.value");
        behaviorProcessor.onNext((Object)CollectionsKt.minus((Iterable)((Iterable)object), (Object)barcodeItem));
    }

    @Override
    public void clearClick() {
        BehaviorProcessor<List<BarcodeItem>> behaviorProcessor = ((IBatchBarcodeListView.State)this.state).getBarcodes();
        boolean bl = false;
        List list = CollectionsKt.emptyList();
        behaviorProcessor.onNext((Object)list);
    }

    @Override
    public void detailsOpened() {
        this.detailsOpened = true;
    }

    @Override
    public void detailsClosed() {
        this.detailsOpened = false;
    }

    /*
     * WARNING - void declaration
     */
    private final <E> List<E> replace(@NotNull Iterable<? extends E> $this$replace, E old, E e) {
        void $this$mapTo$iv$iv;
        Iterable<? extends E> $this$map$iv = $this$replace;
        boolean $i$f$map = false;
        Iterable<? extends E> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            E e2 = Intrinsics.areEqual((Object)it, old) ? e : it;
            collection.add(e2);
        }
        return (List)destination$iv$iv;
    }

    @Inject
    public BatchBarcodeListPresenter(@NotNull Navigator navigator, @NotNull FormattedBarcodeDataMapper dataMapper, @NotNull LastScannedBarcodeHolder lastScannedBarcodeHolder, @BackgroundTaskScheduler @NotNull Scheduler backgroundTaskScheduler) {
        Intrinsics.checkParameterIsNotNull((Object)navigator, (String)"navigator");
        Intrinsics.checkParameterIsNotNull((Object)dataMapper, (String)"dataMapper");
        Intrinsics.checkParameterIsNotNull((Object)lastScannedBarcodeHolder, (String)"lastScannedBarcodeHolder");
        Intrinsics.checkParameterIsNotNull((Object)backgroundTaskScheduler, (String)"backgroundTaskScheduler");
        this.navigator = navigator;
        this.dataMapper = dataMapper;
        this.lastScannedBarcodeHolder = lastScannedBarcodeHolder;
        this.backgroundTaskScheduler = backgroundTaskScheduler;
        this.subscribtions = new CompositeDisposable();
    }

    public static final /* synthetic */ IBatchBarcodeListView.State access$getState$p(BatchBarcodeListPresenter $this) {
        return (IBatchBarcodeListView.State)$this.state;
    }

    public static final /* synthetic */ void access$setState$p(BatchBarcodeListPresenter $this, IBatchBarcodeListView.State state) {
        $this.state = state;
    }

    public static final /* synthetic */ void access$processNewBarcode(BatchBarcodeListPresenter $this, BarcodeItem newItem) {
        $this.processNewBarcode(newItem);
    }

    public static final /* synthetic */ FormattedBarcodeDataMapper access$getDataMapper$p(BatchBarcodeListPresenter $this) {
        return $this.dataMapper;
    }

    public static final /* synthetic */ List access$replace(BatchBarcodeListPresenter $this, Iterable $this$access_u24replace, Object old, Object object) {
        return $this.replace($this$access_u24replace, old, object);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/ui/view/barcode/batch/BatchBarcodeListPresenter$BarcodesScanFinished;", "", "barcodes", "", "Lio/scanbot/sdk/barcode/entity/BarcodeItem;", "(Ljava/util/List;)V", "getBarcodes", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "rtu-ui-barcode_release"})
    public static final class BarcodesScanFinished {
        @NotNull
        private final List<BarcodeItem> barcodes;

        @NotNull
        public final List<BarcodeItem> getBarcodes() {
            return this.barcodes;
        }

        public BarcodesScanFinished(@NotNull List<BarcodeItem> barcodes) {
            Intrinsics.checkParameterIsNotNull(barcodes, (String)"barcodes");
            this.barcodes = barcodes;
        }

        @NotNull
        public final List<BarcodeItem> component1() {
            return this.barcodes;
        }

        @NotNull
        public final BarcodesScanFinished copy(@NotNull List<BarcodeItem> barcodes) {
            Intrinsics.checkParameterIsNotNull(barcodes, (String)"barcodes");
            return new BarcodesScanFinished(barcodes);
        }

        public static /* synthetic */ BarcodesScanFinished copy$default(BarcodesScanFinished barcodesScanFinished2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = barcodesScanFinished2.barcodes;
            }
            return barcodesScanFinished2.copy(list);
        }

        @NotNull
        public String toString() {
            return "BarcodesScanFinished(barcodes=" + this.barcodes + ")";
        }

        public int hashCode() {
            List<BarcodeItem> list = this.barcodes;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BarcodesScanFinished)) break block3;
                    BarcodesScanFinished barcodesScanFinished2 = (BarcodesScanFinished)object;
                    if (!Intrinsics.areEqual(this.barcodes, barcodesScanFinished2.barcodes)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/scanbot/sdk/ui/view/barcode/batch/BatchBarcodeListPresenter$NewBarcodeProcessed;", "", "()V", "rtu-ui-barcode_release"})
    public static final class NewBarcodeProcessed {
    }
}

