/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import io.scanbot.sdk.barcode.entity.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.EngineMode;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.ZoomRange;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeImageGenerationType;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerAdditionalConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerConfigurationParams;
import io.scanbot.sdk.ui.view.barcode.configuration.IBarcodeFilter;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\n2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\fj\b\u0012\u0004\u0012\u00020\u001a`\u000eJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\n2\b\b\u0001\u0010\"\u001a\u00020\u0014J\u000e\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\n2\b\b\u0001\u0010-\u001a\u00020\u0014J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0005J\u000e\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\n2\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020<J\u0010\u0010=\u001a\u00020\n2\b\b\u0001\u0010>\u001a\u00020\u0014J\u000e\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u0014J\u000e\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\u0005J\u0010\u0010C\u001a\u00020\n2\b\b\u0001\u0010D\u001a\u00020\u0014J\u000e\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020GJ\u000e\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020GJ\u0010\u0010O\u001a\u00020\n2\b\b\u0001\u0010P\u001a\u00020\u0014J\u0010\u0010Q\u001a\u00020\n2\b\b\u0001\u0010R\u001a\u00020\u0014J\u0010\u0010S\u001a\u00020\n2\b\b\u0001\u0010T\u001a\u00020\u0014J\u000e\u0010U\u001a\u00020\n2\u0006\u0010V\u001a\u00020GR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006W"}, d2={"Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "", "()V", "barcodeCameraConfiguration", "", "", "Ljava/io/Serializable;", "getBarcodeCameraConfiguration", "()Ljava/util/Map;", "setAcceptedDocumentFormats", "", "documentFormats", "Ljava/util/ArrayList;", "Lio/scanbot/sdk/barcode/entity/BarcodeDocumentFormat;", "Lkotlin/collections/ArrayList;", "setAdditionalDetectionParameters", "additionalConfiguration", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerAdditionalConfiguration;", "setAutoCancelTimeout", "seconds", "", "setBarcodeFilter", "barcodeFilter", "Lio/scanbot/sdk/ui/view/barcode/configuration/IBarcodeFilter;", "setBarcodeFormatsFilter", "barcodeFormat", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "setBarcodeImageGenerationType", "imageType", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeImageGenerationType;", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOverlayColor", "cameraOverlayColor", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCameraZoomFactor", "zoomFactor", "", "setCameraZoomRange", "zoomRange", "Lio/scanbot/sdk/camera/ZoomRange;", "setCancelButtonIcon", "cancelButtonIcon", "setCancelButtonTitle", "cancelButtonTitle", "setDelayAfterFocusCompleteMs", "delay", "", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setEngineMode", "engineMode", "Lio/scanbot/sdk/barcode/entity/EngineMode;", "setFinderAspectRatio", "finderAspectRatio", "Lio/scanbot/sdk/ui/camera/FinderAspectRatio;", "setFinderLineColor", "finderLineColor", "setFinderLineWidth", "finderLineWidth", "setFinderTextHint", "finderTextHint", "setFinderTextHintColor", "finderTextHintColor", "setFlashEnabled", "flashEnabled", "", "setMinFocusDistanceLock", "lock", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setSuccessBeepEnabled", "successBeepEnabled", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsColor", "topBarButtonsColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "rtu-ui-barcode_release"})
public class BarcodeScannerConfiguration {
    @NotNull
    private final Map<String, Serializable> barcodeCameraConfiguration = new HashMap();

    @NotNull
    public final Map<String, Serializable> getBarcodeCameraConfiguration() {
        return this.barcodeCameraConfiguration;
    }

    public final void setBarcodeFilter(@NotNull IBarcodeFilter barcodeFilter) {
        Intrinsics.checkNotNullParameter((Object)barcodeFilter, (String)"barcodeFilter");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.BARCODE_FILTER.getKey(), barcodeFilter);
    }

    public final void setBarcodeFormatsFilter(@NotNull ArrayList<BarcodeFormat> barcodeFormat) {
        Intrinsics.checkNotNullParameter(barcodeFormat, (String)"barcodeFormat");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.BARCODE_FORMATS_FILTER.getKey(), barcodeFormat);
    }

    public final void setAcceptedDocumentFormats(@NotNull ArrayList<BarcodeDocumentFormat> documentFormats) {
        Intrinsics.checkNotNullParameter(documentFormats, (String)"documentFormats");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.ACCEPTED_DOCUMENT_FORMATS.getKey(), documentFormats);
    }

    public final void setEngineMode(@NotNull EngineMode engineMode) {
        Intrinsics.checkNotNullParameter((Object)engineMode, (String)"engineMode");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.ENGINE_MODE.getKey(), (Serializable)engineMode);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        Long l = delay;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), l);
    }

    public final void setBarcodeImageGenerationType(@NotNull BarcodeImageGenerationType imageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageType), (String)"imageType");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.BARCODE_IMAGE_GENERATION_TYPE.getKey(), (Serializable)((Object)imageType));
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        Boolean bl = flashEnabled;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.FLASH_ENABLED.getKey(), bl);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setSuccessBeepEnabled(boolean successBeepEnabled) {
        Boolean bl = successBeepEnabled;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.SUCCESS_BEEP_ENABLED.getKey(), bl);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.CAMERA_MODULE.getKey(), (Serializable)cameraModule);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setCameraZoomFactor(float zoomFactor) {
        Float f = Float.valueOf(zoomFactor);
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.CAMERA_ZOOM_FACTOR.getKey(), f);
    }

    public final void setCameraZoomRange(@NotNull ZoomRange zoomRange) {
        Intrinsics.checkNotNullParameter((Object)zoomRange, (String)"zoomRange");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.CAMERA_ZOOM_RANGE.getKey(), (Serializable)zoomRange);
    }

    public final void setMinFocusDistanceLock(boolean lock) {
        Boolean bl = lock;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.LOCK_MIN_FOCUS_DISTANCE.getKey(), bl);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        Integer n = topBarBackgroundColor;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsColor(@ColorInt int topBarButtonsColor) {
        Integer n = topBarButtonsColor;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.TOP_BAR_BUTTONS_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        Integer n = topBarButtonsInactiveColor;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), n);
    }

    public final void setCameraOverlayColor(@ColorInt int cameraOverlayColor) {
        Integer n = cameraOverlayColor;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.CAMERA_OVERLAY_COLOR.getKey(), n);
    }

    public final void setFinderLineWidth(int finderLineWidth) {
        Integer n = finderLineWidth;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.FINDER_LINE_WIDTH.getKey(), n);
    }

    public final void setFinderAspectRatio(@NotNull FinderAspectRatio finderAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)finderAspectRatio, (String)"finderAspectRatio");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.FINDER_ASPECT_RATIO.getKey(), (Serializable)finderAspectRatio);
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        Integer n = finderLineColor;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.FINDER_LINE_COLOR.getKey(), n);
    }

    public final void setFinderTextHintColor(@ColorInt int finderTextHintColor) {
        Integer n = finderTextHintColor;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.FINDER_TEXT_HINT_COLOR.getKey(), n);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setCancelButtonIcon(@DrawableRes int cancelButtonIcon) {
        Integer n = cancelButtonIcon;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.CANCEL_BUTTON_ICON.getKey(), n);
    }

    public final void setFinderTextHint(@NotNull String finderTextHint) {
        Intrinsics.checkNotNullParameter((Object)finderTextHint, (String)"finderTextHint");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.FINDER_TEXT_HINT.getKey(), (Serializable)((Object)finderTextHint));
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        Boolean bl = allCaps;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey(), bl);
    }

    public final void setAutoCancelTimeout(int seconds) {
        Integer n = seconds;
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.AUTO_CANCEL_TIMEOUT.getKey(), n);
    }

    public final void setAdditionalDetectionParameters(@NotNull BarcodeScannerAdditionalConfiguration additionalConfiguration) {
        Intrinsics.checkNotNullParameter((Object)additionalConfiguration, (String)"additionalConfiguration");
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.MINIMUM_TEXT_LENGTH.getKey(), Integer.valueOf(additionalConfiguration.getMinimumTextLength()));
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.MAXIMUM_TEXT_LENGTH.getKey(), Integer.valueOf(additionalConfiguration.getMaximumTextLength()));
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.MINIMUM_1D_QUIET_ZONE_SIZE.getKey(), Integer.valueOf(additionalConfiguration.getMinimum1DQuietZoneSize()));
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.GS1_DECODING_ENABLED.getKey(), Boolean.valueOf(additionalConfiguration.getGs1DecodingEnabled()));
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.MSI_PLESSEY_CHECKSUM_ALGORITHMS.getKey(), additionalConfiguration.getMsiPlesseyChecksumAlgorithms());
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.STRIP_CHECK_DIGITS.getKey(), Boolean.valueOf(additionalConfiguration.getStripCheckDigits()));
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.LOW_POWER_MODE.getKey(), Boolean.valueOf(additionalConfiguration.getLowPowerMode()));
        this.barcodeCameraConfiguration.put(BarcodeScannerConfigurationParams.CODE_DENSITY.getKey(), (Serializable)additionalConfiguration.getCodeDensity());
    }
}

