/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import io.scanbot.sdk.ui.utils.TintableImageButton;

public class CheckableImageButton
extends TintableImageButton
implements Checkable {
    private static final int[] STATE_CHECKED = new int[]{0x10100A0};
    private boolean checked = false;

    public CheckableImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        if (this.checked) {
            int[] states = super.onCreateDrawableState(extraSpace + 1);
            CheckableImageButton.mergeDrawableStates((int[])states, (int[])STATE_CHECKED);
            return states;
        }
        return super.onCreateDrawableState(extraSpace);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.destroyDrawingCache();
        this.refreshDrawableState();
        this.invalidate();
    }

    public void toggle() {
        this.setChecked(!this.checked);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState outState = new SavedState(superState);
        outState.checked = this.checked;
        return outState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setChecked(ss.checked);
    }

    static class SavedState
    extends View.BaseSavedState {
        boolean checked;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.checked = in.readByte() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.checked ? 1 : 0));
        }
    }
}

