/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils.navigator;

import android.app.Activity;
import io.scanbot.sdk.ui.utils.navigator.ActivityBindingNavigator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001cB\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u000f\u0010\u000f\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0011\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\nH\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\rH\u0002J\u001e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u001b\u001a\u00020\rH\u0016R2\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/ui/utils/navigator/NodeNavigator;", "A", "Landroid/app/Activity;", "Lio/scanbot/sdk/ui/utils/navigator/ActivityBindingNavigator;", "nodes", "", "Lio/scanbot/sdk/ui/utils/navigator/NodeNavigator$NavigationNode;", "(Ljava/util/List;)V", "history", "Ljava/util/Queue;", "", "kotlin.jvm.PlatformType", "bind", "", "activity", "getActivity", "()Landroid/app/Activity;", "navigate", "event", "navigateBack", "", "navigateFromTopNode", "navigateToNewNode", "newNode", "navigateToNodeInHistory", "navigateToTopNode", "nodeForEvent", "unbind", "NavigationNode", "rtu-ui-base_release"})
public class NodeNavigator<A extends Activity>
extends ActivityBindingNavigator {
    private final Queue<Object> history;
    private final List<NavigationNode<A>> nodes;

    public final boolean navigateBack() {
        if (!this.history.isEmpty()) {
            Object topEvent = this.history.poll();
            NavigationNode<A> topNode = this.nodeForEvent(topEvent);
            if (topNode.interceptBackNavigation(this.getActivity())) {
                this.history.add(topEvent);
                return true;
            }
            topNode.navigateFrom(this.getActivity(), topEvent);
            if (!this.history.isEmpty()) {
                Object nextTopEvent = this.history.peek();
                this.nodeForEvent(nextTopEvent).navigateTo(this.getActivity(), nextTopEvent);
            } else {
                A a = this.getActivity();
                if (a == null) {
                    Intrinsics.throwNpe();
                }
                a.finish();
            }
            return true;
        }
        return false;
    }

    @Override
    public void navigate(@Nullable Activity activity, @NotNull Object event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event, (Object)this.history.peek())) {
            return;
        }
        if (activity == null) {
            this.history.add(event);
            return;
        }
        NavigationNode<A> newNode = this.nodeForEvent(event);
        if (newNode.isActionNode()) {
            newNode.navigateTo(this.getActivity(), event);
        } else if (this.history.contains(event)) {
            this.navigateToNodeInHistory(event);
        } else {
            this.navigateToNewNode(event, newNode);
        }
    }

    private final void navigateToNewNode(Object event, NavigationNode<A> newNode) {
        this.navigateFromTopNode();
        newNode.navigateTo(this.getActivity(), event);
        this.history.add(event);
    }

    private final void navigateToNodeInHistory(Object event) {
        while (Intrinsics.areEqual((Object)event, (Object)this.history.peek()) ^ true) {
            Object topEvent = this.history.poll();
            this.nodeForEvent(topEvent).navigateFrom(this.getActivity(), topEvent);
        }
        this.nodeForEvent(event).navigateTo(this.getActivity(), event);
    }

    @Override
    public void bind(@Nullable Activity activity) {
        super.bind(activity);
        this.navigateToTopNode();
    }

    @Override
    public void unbind() {
        if (this.getActivity() == null) {
            return;
        }
        this.navigateFromTopNode();
        super.unbind();
    }

    @Nullable
    protected A getActivity() {
        Activity activity = super.getActivity();
        if (activity == null) {
            throw new TypeCastException("null cannot be cast to non-null type A");
        }
        return (A)activity;
    }

    private final void navigateToTopNode() {
        if (!this.history.isEmpty()) {
            Object topEvent = this.history.peek();
            this.nodeForEvent(topEvent).navigateTo(this.getActivity(), topEvent);
        }
    }

    private final void navigateFromTopNode() {
        if (!this.history.isEmpty()) {
            Object topEvent = this.history.peek();
            this.nodeForEvent(topEvent).navigateFrom(this.getActivity(), topEvent);
        }
    }

    private final NavigationNode<A> nodeForEvent(Object event) {
        Object v0;
        block3: {
            Iterable iterable = this.nodes;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                NavigationNode node = (NavigationNode)t;
                boolean bl3 = false;
                if (!node.canHandleNavigationEvent(event)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        NavigationNode navigationNode = v0;
        if (navigationNode == null) {
            StringBuilder stringBuilder = new StringBuilder().append("No node for event: ");
            Object object = event;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            throw (Throwable)new RuntimeException(stringBuilder.append(object).toString());
        }
        return navigationNode;
    }

    public NodeNavigator(@NotNull List<? extends NavigationNode<A>> nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        this.nodes = nodes;
        this.history = Collections.asLifoQueue(new LinkedList());
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003J\u0012\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u0003H&J\u0017\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00018\u0001H&\u00a2\u0006\u0002\u0010\u000bJ!\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00018\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H&\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0010\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00018\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H&\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/ui/utils/navigator/NodeNavigator$NavigationNode;", "A", "Landroid/app/Activity;", "", "isActionNode", "", "()Z", "canHandleNavigationEvent", "event", "interceptBackNavigation", "activity", "(Landroid/app/Activity;)Z", "navigateFrom", "", "data", "(Landroid/app/Activity;Ljava/lang/Object;)V", "navigateTo", "rtu-ui-base_release"})
    public static interface NavigationNode<A extends Activity> {
        public boolean isActionNode();

        public void navigateTo(@Nullable A var1, @Nullable Object var2);

        public void navigateFrom(@Nullable A var1, @Nullable Object var2);

        public boolean interceptBackNavigation(@Nullable A var1);

        public boolean canHandleNavigationEvent(@Nullable Object var1);
    }
}

