/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils.navigator;

import android.app.Activity;
import androidx.annotation.Nullable;
import io.scanbot.sdk.ui.utils.navigator.NodeNavigator;
import java.util.List;
import kotlin.jvm.functions.Function1;

public class Nodes {
    public static <A extends Activity> FunctionalNode.FunctionalNodeBuilder<A> node(Function1<Object, Boolean> handleEventWhen) {
        return FunctionalNode.builder().actionNode(false).handleEventWhen(handleEventWhen);
    }

    public static <A extends Activity> NodeNavigator.NavigationNode<A> actionNode(Function1<Object, Boolean> eventMatcher, Action2<A, Object> action) {
        return FunctionalNode.builder().actionNode(true).handleEventWhen(eventMatcher).whenNavigateTo(action).build();
    }

    public static Function1<Object, Boolean> key(final Object value) {
        return new Function1<Object, Boolean>(){

            public Boolean invoke(Object o) {
                return value.equals(o);
            }
        };
    }

    public static Function1<Object, Boolean> key(final Class<?> type) {
        return new Function1<Object, Boolean>(){

            public Boolean invoke(Object o) {
                return type.isInstance(o);
            }
        };
    }

    public static Function1<Object, Boolean> anyOfTypes(final List<Class<?>> types) {
        return new Function1<Object, Boolean>(){

            public Boolean invoke(final Object event) {
                return types.contains(new Function1<Class<?>, Boolean>(){

                    public Boolean invoke(Class<?> type) {
                        return type.isInstance(event);
                    }
                });
            }
        };
    }

    public static Function1<Object, Boolean> anyOf(final List<Object> values) {
        return new Function1<Object, Boolean>(){

            public Boolean invoke(final Object event) {
                return values.contains(new Function1<Object, Boolean>(){

                    public Boolean invoke(Object object) {
                        return object.equals(event);
                    }
                });
            }
        };
    }

    public static class FunctionalNode<A extends Activity>
    implements NodeNavigator.NavigationNode<A> {
        @Nullable
        private final Function1<Object, Boolean> handleEventWhen;
        @Nullable
        private final Action2<A, Object> whenNavigateTo;
        @Nullable
        private final Action2<A, Object> whenNavigateFrom;
        @Nullable
        private final Func1<A, Boolean> interceptNavigateBack;
        private final boolean actionNode;

        FunctionalNode(Function1<Object, Boolean> handleEventWhen, Action2<A, Object> whenNavigateTo, Action2<A, Object> whenNavigateFrom, Func1<A, Boolean> interceptNavigateBack, boolean actionNode) {
            this.handleEventWhen = handleEventWhen;
            this.whenNavigateTo = whenNavigateTo;
            this.whenNavigateFrom = whenNavigateFrom;
            this.interceptNavigateBack = interceptNavigateBack;
            this.actionNode = actionNode;
        }

        public static <A extends Activity> FunctionalNodeBuilder<A> builder() {
            return new FunctionalNodeBuilder();
        }

        @Override
        public void navigateTo(A activity, Object data) {
            if (this.whenNavigateTo != null) {
                this.whenNavigateTo.call(activity, data);
            }
        }

        @Override
        public void navigateFrom(A activity, Object data) {
            if (this.whenNavigateFrom != null) {
                this.whenNavigateFrom.call(activity, data);
            }
        }

        @Override
        public boolean interceptBackNavigation(A activity) {
            return this.interceptNavigateBack != null ? this.interceptNavigateBack.call(activity) : false;
        }

        @Override
        public boolean isActionNode() {
            return this.actionNode;
        }

        @Override
        public boolean canHandleNavigationEvent(Object event) {
            return this.handleEventWhen != null ? (Boolean)this.handleEventWhen.invoke(event) : false;
        }

        public static class FunctionalNodeBuilder<A extends Activity> {
            private Function1<Object, Boolean> handleEventWhen;
            private Action2<A, Object> whenNavigateTo;
            private Action2<A, Object> whenNavigateFrom;
            private Func1<A, Boolean> interceptNavigateBack;
            private boolean actionNode;

            FunctionalNodeBuilder() {
            }

            public FunctionalNodeBuilder<A> handleEventWhen(Function1<Object, Boolean> handleEventWhen) {
                this.handleEventWhen = handleEventWhen;
                return this;
            }

            public FunctionalNodeBuilder<A> whenNavigateTo(Action2<A, Object> whenNavigateTo) {
                this.whenNavigateTo = whenNavigateTo;
                return this;
            }

            public FunctionalNodeBuilder<A> whenNavigateFrom(Action2<A, Object> whenNavigateFrom) {
                this.whenNavigateFrom = whenNavigateFrom;
                return this;
            }

            public FunctionalNodeBuilder<A> interceptNavigateBack(Func1<A, Boolean> interceptNavigateBack) {
                this.interceptNavigateBack = interceptNavigateBack;
                return this;
            }

            public FunctionalNodeBuilder<A> actionNode(boolean actionNode) {
                this.actionNode = actionNode;
                return this;
            }

            public FunctionalNode<A> build() {
                return new FunctionalNode<A>(this.handleEventWhen, this.whenNavigateTo, this.whenNavigateFrom, this.interceptNavigateBack, this.actionNode);
            }

            public String toString() {
                return "Nodes.FunctionalNode.FunctionalNodeBuilder(handleEventWhen=" + this.handleEventWhen + ", whenNavigateTo=" + this.whenNavigateTo + ", whenNavigateFrom=" + this.whenNavigateFrom + ", interceptNavigateBack=" + this.interceptNavigateBack + ", actionNode=" + this.actionNode + ")";
            }
        }
    }

    public static interface Func1<T, R> {
        public R call(T var1);
    }

    public static interface Action2<T1, T2> {
        public void call(T1 var1, T2 var2);
    }
}

