/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageButton;
import io.scanbot.sdk.ui.base.R;

public class TintableImageButton
extends AppCompatImageButton {
    private ColorStateList tint;

    public TintableImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    @TargetApi(value=11)
    public TintableImageButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TintableImageButton, defStyle, 0);
        try {
            this.tint = typedArray.getColorStateList(R.styleable.TintableImageButton_src_tint);
            if (this.tint != null && !this.tint.isStateful()) {
                this.updateTintColor();
            }
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.tint != null && this.tint.isStateful()) {
            this.updateTintColor();
        }
    }

    public void setColorFilter(ColorStateList tint) {
        this.tint = tint;
        this.updateTintColor();
    }

    private void updateTintColor() {
        int color = this.tint.getColorForState(this.getDrawableState(), 0);
        this.setColorFilter(color);
    }
}

