/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils.navigator;

import android.app.Activity;
import io.scanbot.sdk.ui.utils.navigator.ActivityBindingNavigator;
import io.scanbot.sdk.ui.utils.navigator.NavigationException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001aB\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\rH\u0002J\u001e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\rH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0019\u001a\u00020\rH\u0016R2\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/scanbot/sdk/ui/utils/navigator/NodeNavigator;", "A", "Landroid/app/Activity;", "Lio/scanbot/sdk/ui/utils/navigator/ActivityBindingNavigator;", "nodes", "", "Lio/scanbot/sdk/ui/utils/navigator/NodeNavigator$NavigationNode;", "(Ljava/util/List;)V", "history", "Ljava/util/Queue;", "", "kotlin.jvm.PlatformType", "bind", "", "activity", "navigate", "event", "navigateBack", "", "navigateFromTopNode", "navigateToNewNode", "newNode", "navigateToNodeInHistory", "navigateToTopNode", "nodeForEvent", "unbind", "NavigationNode", "rtu-ui-base_release"})
public class NodeNavigator<A extends Activity>
extends ActivityBindingNavigator {
    private final Queue<Object> history;
    private final List<NavigationNode<A>> nodes;

    public final boolean navigateBack() {
        if (!this.history.isEmpty()) {
            Activity activity;
            Object topEvent;
            Object object = topEvent = this.history.poll();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topEvent");
            NavigationNode<Activity> topNode = this.nodeForEvent(object);
            Activity activity2 = this.getActivity();
            if (activity2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type A");
            }
            if (!topNode.interceptBackNavigation(activity2)) {
                activity = this.getActivity();
                if (activity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type A");
                }
            } else {
                this.history.add(topEvent);
                return true;
            }
            topNode.navigateFrom(activity, topEvent);
            if (!this.history.isEmpty()) {
                Object nextTopEvent;
                Object object2 = nextTopEvent = this.history.peek();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"nextTopEvent");
                Activity activity3 = this.getActivity();
                if (activity3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type A");
                }
                this.nodeForEvent(object2).navigateTo(activity3, nextTopEvent);
            } else {
                Activity activity4 = this.getActivity();
                if (activity4 != null) {
                    activity4.finish();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void navigate(@Nullable Activity activity, @NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event, (Object)this.history.peek())) {
            return;
        }
        if (activity == null) {
            this.history.add(event);
            return;
        }
        NavigationNode<Activity> newNode = this.nodeForEvent(event);
        if (newNode.isActionNode()) {
            Activity activity2 = super.getActivity();
            if (activity2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type A");
            }
            newNode.navigateTo(activity2, event);
        } else if (this.history.contains(event)) {
            this.navigateToNodeInHistory(event);
        } else {
            this.navigateToNewNode(event, newNode);
        }
    }

    private final void navigateToNewNode(Object event, NavigationNode<A> newNode) {
        this.navigateFromTopNode();
        Activity activity = this.getActivity();
        if (activity == null) {
            throw new NullPointerException("null cannot be cast to non-null type A");
        }
        newNode.navigateTo(activity, event);
        this.history.add(event);
    }

    private final void navigateToNodeInHistory(Object event) {
        while (Intrinsics.areEqual((Object)event, (Object)this.history.peek()) ^ true) {
            Object topEvent;
            Object object = topEvent = this.history.poll();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topEvent");
            Activity activity = this.getActivity();
            if (activity == null) {
                throw new NullPointerException("null cannot be cast to non-null type A");
            }
            this.nodeForEvent(object).navigateFrom(activity, topEvent);
        }
        Activity activity = this.getActivity();
        if (activity == null) {
            throw new NullPointerException("null cannot be cast to non-null type A");
        }
        this.nodeForEvent(event).navigateTo(activity, event);
    }

    @Override
    public void bind(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        super.bind(activity);
        this.navigateToTopNode();
    }

    @Override
    public void unbind() {
        if (this.getActivity() == null) {
            return;
        }
        this.navigateFromTopNode();
        super.unbind();
    }

    private final void navigateToTopNode() {
        if (!this.history.isEmpty()) {
            Object topEvent;
            Object object = topEvent = this.history.peek();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topEvent");
            Activity activity = this.getActivity();
            if (activity == null) {
                throw new NullPointerException("null cannot be cast to non-null type A");
            }
            this.nodeForEvent(object).navigateTo(activity, topEvent);
        }
    }

    private final void navigateFromTopNode() {
        if (!this.history.isEmpty()) {
            Object topEvent;
            Object object = topEvent = this.history.peek();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topEvent");
            Activity activity = this.getActivity();
            if (activity == null) {
                throw new NullPointerException("null cannot be cast to non-null type A");
            }
            this.nodeForEvent(object).navigateFrom(activity, topEvent);
        }
    }

    private final NavigationNode<A> nodeForEvent(Object event) {
        Object v0;
        block2: {
            Iterable iterable = this.nodes;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                NavigationNode node = (NavigationNode)t;
                boolean bl3 = false;
                if (!node.canHandleNavigationEvent(event)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        NavigationNode navigationNode = v0;
        if (navigationNode == null) {
            throw (Throwable)new NavigationException("No node for event: " + event);
        }
        return navigationNode;
    }

    public NodeNavigator(@NotNull List<? extends NavigationNode<A>> nodes) {
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        this.nodes = nodes;
        this.history = Collections.asLifoQueue(new LinkedList());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003H&J\u0015\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00020\u0003H&\u00a2\u0006\u0002\u0010\u000fR\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/scanbot/sdk/ui/utils/navigator/NodeNavigator$NavigationNode;", "A", "Landroid/app/Activity;", "", "isActionNode", "", "()Z", "canHandleNavigationEvent", "event", "interceptBackNavigation", "activity", "(Landroid/app/Activity;)Z", "navigateFrom", "", "data", "(Landroid/app/Activity;Ljava/lang/Object;)V", "navigateTo", "rtu-ui-base_release"})
    public static interface NavigationNode<A extends Activity> {
        public boolean isActionNode();

        public void navigateTo(@NotNull A var1, @NotNull Object var2);

        public void navigateFrom(@NotNull A var1, @NotNull Object var2);

        public boolean interceptBackNavigation(@NotNull A var1);

        public boolean canHandleNavigationEvent(@NotNull Object var1);
    }
}

