/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.camera.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.camera.configuration.DocumentScannerAccessibilityConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.DocumentScannerConfigurationParams;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b:\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\n2\b\b\u0001\u0010 \u001a\u00020\fJ\u0010\u0010!\u001a\u00020\n2\b\b\u0001\u0010\"\u001a\u00020\fJ\u0010\u0010#\u001a\u00020\n2\b\b\u0001\u0010$\u001a\u00020\fJ\u000e\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'J\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/J\u0016\u00100\u001a\u00020\n2\u0006\u00101\u001a\u00020\f2\u0006\u00102\u001a\u00020\fJ\u000e\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0017J\u000e\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u0005J\u000e\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020\u0005J\u000e\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\u0017J\u000e\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u0005J\u000e\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\u0017J\u000e\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u0017J\u000e\u0010A\u001a\u00020\n2\u0006\u0010B\u001a\u00020\u0017J\u000e\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\u001eJ\u000e\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\fJ\u000e\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\u0017J\u000e\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020\u0005J\u000e\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\u0017J\u000e\u0010P\u001a\u00020\n2\u0006\u0010Q\u001a\u00020RJ\u000e\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020\u0005J\u0010\u0010U\u001a\u00020\n2\b\b\u0001\u0010V\u001a\u00020\fJ\u000e\u0010W\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u0017J\u0010\u0010X\u001a\u00020\n2\b\b\u0001\u0010Y\u001a\u00020\fJ\u0010\u0010Z\u001a\u00020\n2\b\b\u0001\u0010[\u001a\u00020\fJ\u0010\u0010\\\u001a\u00020\n2\b\b\u0001\u0010]\u001a\u00020\fJ\u0010\u0010^\u001a\u00020\n2\b\b\u0001\u0010_\u001a\u00020\fJ\u0010\u0010`\u001a\u00020\n2\b\b\u0001\u0010a\u001a\u00020\fJ\u0010\u0010b\u001a\u00020\n2\b\b\u0001\u0010c\u001a\u00020\fJ\u0010\u0010d\u001a\u00020\n2\b\b\u0001\u0010e\u001a\u00020\fJ\u0010\u0010f\u001a\u00020\n2\b\b\u0001\u0010g\u001a\u00020\fJ\u0010\u0010h\u001a\u00020\n2\b\b\u0001\u0010i\u001a\u00020\fJ\u000e\u0010j\u001a\u00020\n2\u0006\u0010k\u001a\u00020\u0017J\u0010\u0010l\u001a\u00020\n2\b\b\u0001\u0010m\u001a\u00020\fJ\u0010\u0010n\u001a\u00020\n2\b\b\u0001\u0010o\u001a\u00020\fJ\u0010\u0010p\u001a\u00020\n2\u0006\u0010q\u001a\u00020\u0017H\u0007J\u000e\u0010r\u001a\u00020\n2\u0006\u0010s\u001a\u00020\u0005J\u000e\u0010t\u001a\u00020\n2\u0006\u0010u\u001a\u00020\u0005J\u000e\u0010v\u001a\u00020\n2\u0006\u0010w\u001a\u00020\u0005J\u000e\u0010x\u001a\u00020\n2\u0006\u0010y\u001a\u00020\u0005J\u000e\u0010z\u001a\u00020\n2\u0006\u0010{\u001a\u00020\u0005J\u000e\u0010|\u001a\u00020\n2\u0006\u0010}\u001a\u00020\u0005J\u000e\u0010~\u001a\u00020\n2\u0006\u0010\u007f\u001a\u00020\u0005J\u0012\u0010\u0080\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0081\u0001\u001a\u00020\fJ\u0012\u0010\u0082\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0083\u0001\u001a\u00020\fJ\u0012\u0010\u0084\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0085\u0001\u001a\u00020\fJ\u0010\u0010\u0086\u0001\u001a\u00020\n2\u0007\u0010\u0087\u0001\u001a\u00020\u0017J\u0012\u0010\u0088\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0089\u0001\u001a\u00020\fJ\u0012\u0010\u008a\u0001\u001a\u00020\n2\t\b\u0001\u0010\u008b\u0001\u001a\u00020\fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u008c\u0001"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerConfiguration;", "", "()V", "cameraConfiguration", "", "", "Ljava/io/Serializable;", "getCameraConfiguration", "()Ljava/util/Map;", "enableHardwareSnapButton", "", "key", "", "setAcceptedAngleScore", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setAccessibilityConfiguration", "accessibilityConfiguration", "Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerAccessibilityConfiguration;", "setAutoSnappingButtonHidden", "autoSnappingButtonHidden", "", "setAutoSnappingButtonTitle", "autoSnappingButtonTitle", "setAutoSnappingEnabled", "autoSnappingEnabled", "setAutoSnappingSensitivity", "autoSnappingSensitivity", "", "setBottomBarBackgroundColor", "bottomBarBackgroundColor", "setBottomBarButtonsColor", "bottomBarButtonsColor", "setCameraBackgroundColor", "cameraBackgroundColor", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonTitle", "cancelButtonTitle", "setDelayAfterFocusCompleteMs", "delay", "", "setDocumentImageSizeLimit", "documentImageHeightLimit", "documentImageWidthLimit", "setDrawPolygonShadows", "drawPolygonShadows", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFlashButtonHidden", "flashButtonHidden", "setFlashButtonTitle", "flashButtonTitle", "setFlashEnabled", "flashEnabled", "setForceMaxSnappingSize", "enabled", "setIgnoreBadAspectRatio", "ignoreBadAspectRatio", "setImageFilterType", "imageFilterType", "Lio/scanbot/sdk/process/ImageFilterType;", "setImageScale", "imageScale", "setMaxNumberOfPages", "maxNumberOfPages", "setMultiPageButtonHidden", "multiPageButtonHidden", "setMultiPageButtonTitle", "multiPageButtonTitle", "setMultiPageEnabled", "multiPageEnabled", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setPageCounterButtonTitle", "pageCounterButtonTitle", "setPolygonAutoSnapProgressColor", "polygonAutoSnapProgressColor", "setPolygonAutoSnapProgressEnabled", "setPolygonAutoSnapProgressLineWidth", "polygonProgressLineWidth", "setPolygonBackgroundColor", "polygonBackgroundColor", "setPolygonBackgroundColorOK", "polygonBackgroundColorOK", "setPolygonColor", "polygonColor", "setPolygonColorOK", "polygonColorOK", "setPolygonCornerRadius", "polygonCornerRadius", "setPolygonLineWidth", "polygonLineWidth", "setShutterButtonAutoInnerColor", "shutterButtonAutoInnerColor", "setShutterButtonAutoOuterColor", "shutterButtonAutoOuterColor", "setShutterButtonHidden", "shutterButtonHidden", "setShutterButtonManualInnerColor", "shutterButtonManualInnerColor", "setShutterButtonManualOuterColor", "shutterButtonManualOuterColor", "setShutterSoundEnabled", "shutterSoundEnabled", "setTextHintBadAngles", "textBadAngles", "setTextHintBadAspectRatio", "textHintBadAspectRatio", "setTextHintNothingDetected", "textHintNothingDetected", "setTextHintOK", "textHintDontMove", "setTextHintTooDark", "textHintTooDark", "setTextHintTooNoisy", "textHintTooNoisy", "setTextHintTooSmall", "textHintTooSmall", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsActiveColor", "topBarButtonsActiveColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "setUserGuidanceBackgroundColor", "userGuidanceBackgroundColor", "setUserGuidanceTextColor", "userGuidanceTextColor", "rtu-ui-docdetector_release"})
public final class DocumentScannerConfiguration {
    @NotNull
    private final Map<String, Serializable> cameraConfiguration = new HashMap();

    @NotNull
    public final Map<String, Serializable> getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    public final void setImageFilterType(@NotNull ImageFilterType imageFilterType) {
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"imageFilterType");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IMAGE_FILTER_TYPE.getKey(), (Serializable)imageFilterType);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        Long l = delay;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), l);
    }

    public final void setAutoSnappingEnabled(boolean autoSnappingEnabled) {
        Boolean bl = autoSnappingEnabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_ENABLED.getKey(), bl);
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        Boolean bl = flashEnabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_ENABLED.getKey(), bl);
    }

    public final void setMultiPageEnabled(boolean multiPageEnabled) {
        Boolean bl = multiPageEnabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_ENABLED.getKey(), bl);
    }

    public final void setMaxNumberOfPages(int maxNumberOfPages) {
        Integer n = maxNumberOfPages;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MAX_NUMBER_OF_PAGES.getKey(), n);
    }

    public final void setAutoSnappingSensitivity(float autoSnappingSensitivity) {
        Float f = Float.valueOf(autoSnappingSensitivity);
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_SENSITIVITY.getKey(), f);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_MODULE.getKey(), (Serializable)cameraModule);
    }

    public final void enableHardwareSnapButton(int key) {
        Integer n = key;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.HARDWARE_SNAP_BUTTON.getKey(), n);
    }

    public static /* synthetic */ void enableHardwareSnapButton$default(DocumentScannerConfiguration documentScannerConfiguration, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 25;
        }
        documentScannerConfiguration.enableHardwareSnapButton(n);
    }

    public final void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        Boolean bl = ignoreBadAspectRatio;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IGNORE_BAD_ASPECT_RATIO.getKey(), bl);
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        Double d = acceptedAngleScore;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCEPTED_ANGLE_SCORE.getKey(), d);
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        Double d = acceptedSizeScore;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCEPTED_SIZE_SCORE.getKey(), d);
    }

    public final void setImageScale(float imageScale) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IMAGE_SCALE.getKey(), Float.valueOf(Math.min(Math.max(0.0f, imageScale), 1.0f)));
    }

    public final void setDocumentImageSizeLimit(int documentImageHeightLimit, int documentImageWidthLimit) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.DOCUMENT_IMAGE_SIZE_LIMIT.getKey(), (Serializable)new PageStorageProcessor.Configuration.Size(documentImageWidthLimit, documentImageHeightLimit));
    }

    public final void setPolygonColor(@ColorInt int polygonColor) {
        Integer n = polygonColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_COLOR.getKey(), n);
    }

    public final void setPolygonColorOK(@ColorInt int polygonColorOK) {
        Integer n = polygonColorOK;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_COLOR_OK.getKey(), n);
    }

    public final void setPolygonLineWidth(@Px int polygonLineWidth) {
        Integer n = polygonLineWidth;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_LINE_WIDTH.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressColor(@ColorInt int polygonAutoSnapProgressColor) {
        Integer n = polygonAutoSnapProgressColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_COLOR.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressLineWidth(@Px int polygonProgressLineWidth) {
        Integer n = polygonProgressLineWidth;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_LINE_WIDTH.getKey(), n);
    }

    public final void setPolygonAutoSnapProgressEnabled(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_ENABLED.getKey(), bl);
    }

    public final void setPolygonCornerRadius(@Px int polygonCornerRadius) {
        Integer n = polygonCornerRadius;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_CORNER_RADIUS.getKey(), n);
    }

    public final void setPolygonBackgroundColor(@ColorInt int polygonBackgroundColor) {
        Integer n = polygonBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setPolygonBackgroundColorOK(@ColorInt int polygonBackgroundColorOK) {
        Integer n = polygonBackgroundColorOK;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR_OK.getKey(), n);
    }

    public final void setDrawPolygonShadows(boolean drawPolygonShadows) {
        Boolean bl = drawPolygonShadows;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_DRAW_SHADOWS.getKey(), bl);
    }

    public final void setShutterButtonAutoOuterColor(@ColorInt int shutterButtonAutoOuterColor) {
        Integer n = shutterButtonAutoOuterColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_OUTER_COLOR.getKey(), n);
    }

    public final void setShutterButtonAutoInnerColor(@ColorInt int shutterButtonAutoInnerColor) {
        Integer n = shutterButtonAutoInnerColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_INNER_COLOR.getKey(), n);
    }

    public final void setShutterButtonManualOuterColor(@ColorInt int shutterButtonManualOuterColor) {
        Integer n = shutterButtonManualOuterColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_OUTER_COLOR.getKey(), n);
    }

    public final void setShutterButtonManualInnerColor(@ColorInt int shutterButtonManualInnerColor) {
        Integer n = shutterButtonManualInnerColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_INNER_COLOR.getKey(), n);
    }

    @RequiresApi(api=17)
    public final void setShutterSoundEnabled(boolean shutterSoundEnabled) {
        Boolean bl = shutterSoundEnabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_SOUND_ENABLED.getKey(), bl);
    }

    public final void setUserGuidanceBackgroundColor(@ColorInt int userGuidanceBackgroundColor) {
        Integer n = userGuidanceBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USER_GUIDANCE_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setUserGuidanceTextColor(@ColorInt int userGuidanceTextColor) {
        Integer n = userGuidanceTextColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USER_GUIDANCE_TEXT_COLOR.getKey(), n);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        Integer n = topBarBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsActiveColor(@ColorInt int topBarButtonsActiveColor) {
        Integer n = topBarButtonsActiveColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BUTTONS_ACTIVE_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        Integer n = topBarButtonsInactiveColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), n);
    }

    public final void setBottomBarBackgroundColor(@ColorInt int bottomBarBackgroundColor) {
        Integer n = bottomBarBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.BOTTOM_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setBottomBarButtonsColor(@ColorInt int bottomBarButtonsColor) {
        Integer n = bottomBarButtonsColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.BOTTOM_BAR_BUTTONS_COLOR.getKey(), n);
    }

    public final void setCameraBackgroundColor(@ColorInt int cameraBackgroundColor) {
        Integer n = cameraBackgroundColor;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setMultiPageButtonHidden(boolean multiPageButtonHidden) {
        Boolean bl = multiPageButtonHidden;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setFlashButtonHidden(boolean flashButtonHidden) {
        Boolean bl = flashButtonHidden;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setAutoSnappingButtonHidden(boolean autoSnappingButtonHidden) {
        Boolean bl = autoSnappingButtonHidden;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setShutterButtonHidden(boolean shutterButtonHidden) {
        Boolean bl = shutterButtonHidden;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_HIDDEN.getKey(), bl);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setPageCounterButtonTitle(@NotNull String pageCounterButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)pageCounterButtonTitle, (String)"pageCounterButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.PAGE_COUNTER_BUTTON_TITLE.getKey(), (Serializable)((Object)pageCounterButtonTitle));
    }

    public final void setTextHintOK(@NotNull String textHintDontMove) {
        Intrinsics.checkNotNullParameter((Object)textHintDontMove, (String)"textHintDontMove");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_OK.getKey(), (Serializable)((Object)textHintDontMove));
    }

    public final void setTextHintTooSmall(@NotNull String textHintTooSmall) {
        Intrinsics.checkNotNullParameter((Object)textHintTooSmall, (String)"textHintTooSmall");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_SMALL.getKey(), (Serializable)((Object)textHintTooSmall));
    }

    public final void setTextHintBadAngles(@NotNull String textBadAngles) {
        Intrinsics.checkNotNullParameter((Object)textBadAngles, (String)"textBadAngles");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_BAD_ANGLES.getKey(), (Serializable)((Object)textBadAngles));
    }

    public final void setTextHintBadAspectRatio(@NotNull String textHintBadAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)textHintBadAspectRatio, (String)"textHintBadAspectRatio");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_BAD_ASPECT_RATIO.getKey(), (Serializable)((Object)textHintBadAspectRatio));
    }

    public final void setTextHintNothingDetected(@NotNull String textHintNothingDetected) {
        Intrinsics.checkNotNullParameter((Object)textHintNothingDetected, (String)"textHintNothingDetected");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_NOTHING_DETECTED.getKey(), (Serializable)((Object)textHintNothingDetected));
    }

    public final void setTextHintTooNoisy(@NotNull String textHintTooNoisy) {
        Intrinsics.checkNotNullParameter((Object)textHintTooNoisy, (String)"textHintTooNoisy");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_NOISY.getKey(), (Serializable)((Object)textHintTooNoisy));
    }

    public final void setTextHintTooDark(@NotNull String textHintTooDark) {
        Intrinsics.checkNotNullParameter((Object)textHintTooDark, (String)"textHintTooDark");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_DARK.getKey(), (Serializable)((Object)textHintTooDark));
    }

    public final void setMultiPageButtonTitle(@NotNull String multiPageButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)multiPageButtonTitle, (String)"multiPageButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_BUTTON_TITLE.getKey(), (Serializable)((Object)multiPageButtonTitle));
    }

    public final void setFlashButtonTitle(@NotNull String flashButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)flashButtonTitle, (String)"flashButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_BUTTON_TITLE.getKey(), (Serializable)((Object)flashButtonTitle));
    }

    public final void setAutoSnappingButtonTitle(@NotNull String autoSnappingButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)autoSnappingButtonTitle, (String)"autoSnappingButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_BUTTON_TITLE.getKey(), (Serializable)((Object)autoSnappingButtonTitle));
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        Boolean bl = allCaps;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey(), bl);
    }

    public final void setAccessibilityConfiguration(@NotNull DocumentScannerAccessibilityConfiguration accessibilityConfiguration) {
        Intrinsics.checkNotNullParameter((Object)accessibilityConfiguration, (String)"accessibilityConfiguration");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCESSIBILITY_CONFIGURATION.getKey(), accessibilityConfiguration);
    }

    public final void setForceMaxSnappingSize(boolean enabled) {
        Boolean bl = enabled;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FORCE_MAX_SNAPPING_SIZE.getKey(), bl);
    }
}

