/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.generictext;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.CameraOpenCallback;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.camera.ScanbotCameraView;
import io.scanbot.sdk.generictext.GenericTextRecognitionResult;
import io.scanbot.sdk.generictext.GenericTextRecognizer;
import io.scanbot.sdk.generictext.GenericTextRecognizerFrameHandler;
import io.scanbot.sdk.generictext.ui.WordboxPreviewView;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.camera.ZoomFinderOverlayView;
import io.scanbot.sdk.ui.generictext.R;
import io.scanbot.sdk.ui.utils.CheckableFrameLayout;
import io.scanbot.sdk.ui.utils.events.Signal;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.generictext.GenericDataCameraView;
import io.scanbot.sdk.ui.view.generictext.GenericDataCameraView$WhenMappings;
import io.scanbot.sdk.ui.view.generictext.IGenericDataCameraView;
import io.scanbot.sdk.ui.view.generictext.entity.GenericDataScannerStep;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 ,2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001,B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u0016H\u0014J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u000eJ\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010%\u001a\u00020\u0016H\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0018H\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020\u0018H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0012H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/ui/view/generictext/GenericDataCameraView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/generictext/IGenericDataCameraView;", "Lio/scanbot/sdk/generictext/GenericTextRecognizerFrameHandler$ResultHandler;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraOpened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "frameHandler", "Lio/scanbot/sdk/generictext/GenericTextRecognizerFrameHandler;", "genericTextRecognizer", "Lio/scanbot/sdk/generictext/GenericTextRecognizer;", "listener", "Lio/scanbot/sdk/ui/view/generictext/IGenericDataCameraView$Listener;", "state", "Lio/scanbot/sdk/ui/view/generictext/IGenericDataCameraView$State;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "closeCamera", "", "handle", "", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/generictext/GenericTextRecognitionResult;", "Lio/scanbot/sdk/SdkLicenseError;", "initCameraView", "onDetachedFromWindow", "setCameraOrientationMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setGenericTextRecognizer", "recognizer", "setListener", "subscribeViews", "updateCameraPermissionView", "cameraPermissionGranted", "updateFlashState", "flash", "updateState", "newState", "Companion", "rtu-ui-generictext_release"})
public final class GenericDataCameraView
extends FrameLayout
implements IGenericDataCameraView,
GenericTextRecognizerFrameHandler.ResultHandler {
    private IGenericDataCameraView.State state;
    private IGenericDataCameraView.Listener listener;
    private GenericTextRecognizer genericTextRecognizer;
    private GenericTextRecognizerFrameHandler frameHandler;
    private final AtomicBoolean cameraOpened;
    private final CompositeDisposable subscriptions;
    private static final long CAMERA_OPENED_DELAY_MILLIS = 300L;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final void setGenericTextRecognizer(@NotNull GenericTextRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        this.genericTextRecognizer = recognizer;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closeCamera();
    }

    @Override
    public void setListener(@NotNull IGenericDataCameraView.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public void updateState(@NotNull IGenericDataCameraView.State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state = newState;
        this.subscribeViews();
    }

    public boolean handle(@NotNull FrameHandlerResult<GenericTextRecognitionResult, SdkLicenseError> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        this.listener.genericTextScanned(result);
        if (result instanceof FrameHandlerResult.Success) {
            if (((GenericTextRecognitionResult)((FrameHandlerResult.Success)result).getValue()).getValidationSuccessful()) {
                GenericTextRecognizerFrameHandler genericTextRecognizerFrameHandler = this.frameHandler;
                if (genericTextRecognizerFrameHandler == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                }
                genericTextRecognizerFrameHandler.setEnabled(false);
            }
            this.post(new Runnable(this, result){
                final /* synthetic */ GenericDataCameraView this$0;
                final /* synthetic */ FrameHandlerResult $result;

                public final void run() {
                    ((WordboxPreviewView)this.this$0._$_findCachedViewById(R.id.wordbox_preview)).updateCharacters(((GenericTextRecognitionResult)((FrameHandlerResult.Success)this.$result).getValue()).getWordBoxes());
                }
                {
                    this.this$0 = genericDataCameraView;
                    this.$result = frameHandlerResult;
                }
            });
        }
        return false;
    }

    @Override
    public void setCameraOrientationMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        switch (GenericDataCameraView$WhenMappings.$EnumSwitchMapping$0[cameraOrientationMode.ordinal()]) {
            case 1: {
                ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).lockToPortrait(true);
                break;
            }
            case 2: {
                ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).lockToLandscape(true);
                break;
            }
        }
    }

    private final void closeCamera() {
        this.cameraOpened.set(false);
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).onPause();
        this.subscriptions.clear();
    }

    private final void initCameraView() {
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).setPreviewMode(CameraPreviewMode.FILL_IN);
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).setCameraOpenCallback(new CameraOpenCallback(this){
            final /* synthetic */ GenericDataCameraView this$0;

            public void onCameraOpened() {
                GenericDataCameraView.access$getCameraOpened$p(this.this$0).set(true);
                ((ScanbotCameraView)this.this$0._$_findCachedViewById(R.id.scanbotCameraView)).postDelayed(new Runnable(this){
                    final /* synthetic */ initCameraView.1 this$0;

                    public final void run() {
                        GenericTextRecognizer genericTextRecognizer = GenericDataCameraView.access$getGenericTextRecognizer$p(this.this$0.this$0);
                        if (genericTextRecognizer != null) {
                            GenericTextRecognizer genericTextRecognizer2 = genericTextRecognizer;
                            boolean bl = false;
                            boolean bl2 = false;
                            GenericTextRecognizer it = genericTextRecognizer2;
                            boolean bl3 = false;
                            GenericDataCameraView genericDataCameraView = this.this$0.this$0;
                            ScanbotCameraView scanbotCameraView = (ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView);
                            Intrinsics.checkNotNullExpressionValue((Object)scanbotCameraView, (String)"scanbotCameraView");
                            GenericDataCameraView.access$setFrameHandler$p(genericDataCameraView, GenericTextRecognizerFrameHandler.Companion.attach((IScanbotCameraView)scanbotCameraView, it));
                            GenericDataCameraView.access$getFrameHandler$p(this.this$0.this$0).addResultHandler((GenericTextRecognizerFrameHandler.ResultHandler)this.this$0.this$0);
                        }
                        ((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)).setShutterSound(false);
                        ((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)).continuousFocus();
                        ScanbotCameraView scanbotCameraView = (ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView);
                        Object object = GenericDataCameraView.access$getState$p(this.this$0.this$0).getFlash().getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this@GenericDataCameraView.state.flash.value");
                        scanbotCameraView.useFlash(((Boolean)object).booleanValue());
                        GenericDataCameraView.access$getListener$p(this.this$0.this$0).onCameraOpened();
                        GenericDataCameraView.access$getSubscriptions$p(this.this$0.this$0).add(GenericDataCameraView.access$getState$p(this.this$0.this$0).getFlash().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
                            final /* synthetic */ initCameraView.onCameraOpened.1 this$0;

                            public final void accept(Boolean flash) {
                                GenericDataCameraView genericDataCameraView = this.this$0.this$0.this$0;
                                Boolean bl = flash;
                                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"flash");
                                GenericDataCameraView.access$updateFlashState(genericDataCameraView, bl);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                        ((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)).addFrameHandler(new FrameHandler(this){
                            final /* synthetic */ initCameraView.onCameraOpened.1 this$0;

                            public boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
                                Intrinsics.checkNotNullParameter((Object)previewFrame, (String)"previewFrame");
                                ((WordboxPreviewView)this.this$0.this$0.this$0._$_findCachedViewById(R.id.wordbox_preview)).setFrameWidth(previewFrame.getWidth());
                                ((WordboxPreviewView)this.this$0.this$0.this$0._$_findCachedViewById(R.id.wordbox_preview)).setFrameHeight(previewFrame.getHeight());
                                ((WordboxPreviewView)this.this$0.this$0.this$0._$_findCachedViewById(R.id.wordbox_preview)).setFrameOrientation(previewFrame.getFrameOrientation());
                                return false;
                            }
                            {
                                this.this$0 = this$0;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, 300L);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void subscribeViews() {
        IGenericDataCameraView.State state = this.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        this.subscriptions.add(state.getCameraPermissionGranted().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ GenericDataCameraView this$0;

            public final void accept(Boolean granted) {
                Boolean bl = granted;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"granted");
                if (bl.booleanValue()) {
                    ((ScanbotCameraView)this.this$0._$_findCachedViewById(R.id.scanbotCameraView)).onResume();
                }
                GenericDataCameraView.access$updateCameraPermissionView(this.this$0, granted);
            }
            {
                this.this$0 = genericDataCameraView;
            }
        }));
        IGenericDataCameraView.State state2 = this.state;
        if (state2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        this.subscriptions.add(state2.getCameraClosed().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Signal>(this){
            final /* synthetic */ GenericDataCameraView this$0;

            public final void accept(Signal it) {
                GenericDataCameraView.access$closeCamera(this.this$0);
            }
            {
                this.this$0 = genericDataCameraView;
            }
        }));
        IGenericDataCameraView.State state3 = this.state;
        if (state3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        this.subscriptions.add(state3.getCurrentStep().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<GenericDataScannerStep>(this){
            final /* synthetic */ GenericDataCameraView this$0;

            public final void accept(GenericDataScannerStep step) {
                block0: {
                    GenericTextRecognizer genericTextRecognizer = GenericDataCameraView.access$getGenericTextRecognizer$p(this.this$0);
                    if (genericTextRecognizer == null) break block0;
                    GenericTextRecognizer genericTextRecognizer2 = genericTextRecognizer;
                    boolean bl = false;
                    boolean bl2 = false;
                    GenericTextRecognizer it = genericTextRecognizer2;
                    boolean bl3 = false;
                    it.setMatchSubstringForPattern(step.getMatchSubstring());
                    it.setValidator(step.getPattern(), step.getValidationCallback());
                    it.setCleaner(step.getCleanRecognitionResultCallback());
                    TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.finder_description);
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"finder_description");
                    textView.setText((CharSequence)step.getGuidance());
                    ((ZoomFinderOverlayView)this.this$0._$_findCachedViewById(R.id.finder_overlay)).setZoomLevel(step.getZoomLevel());
                    ZoomFinderOverlayView zoomFinderOverlayView = (ZoomFinderOverlayView)this.this$0._$_findCachedViewById(R.id.finder_overlay);
                    float f = step.getUnzoomedFinderHeight();
                    Resources resources = this.this$0.getResources();
                    Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
                    zoomFinderOverlayView.setFixedFinderHeight((int)TypedValue.applyDimension((int)1, (float)f, (DisplayMetrics)resources.getDisplayMetrics()));
                    ((ZoomFinderOverlayView)this.this$0._$_findCachedViewById(R.id.finder_overlay)).setRequiredAspectRatios(CollectionsKt.listOf((Object)step.getAspectRatio()));
                }
            }
            {
                this.this$0 = genericDataCameraView;
            }
        }));
    }

    private final void updateCameraPermissionView(boolean cameraPermissionGranted) {
        if (cameraPermissionGranted) {
            LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.cameraPermissionView);
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"cameraPermissionView");
            linearLayout.setVisibility(8);
        } else {
            LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.cameraPermissionView);
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"cameraPermissionView");
            linearLayout.setVisibility(0);
        }
    }

    private final void updateFlashState(boolean flash) {
        if (this.cameraOpened.get()) {
            CheckableFrameLayout checkableFrameLayout = (CheckableFrameLayout)this._$_findCachedViewById(R.id.flashBtn);
            if (checkableFrameLayout == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.scanbot.sdk.ui.utils.CheckableFrameLayout");
            }
            checkableFrameLayout.setChecked(flash);
            ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).useFlash(flash);
        }
    }

    public GenericDataCameraView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.listener = IGenericDataCameraView.Listener.Companion.getNULL();
        this.cameraOpened = new AtomicBoolean(false);
        this.subscriptions = new CompositeDisposable();
        LayoutInflater.from((Context)context).inflate(R.layout.scanbot_sdk_generic_text_camera_view, (ViewGroup)this, true);
        ((TextView)this._$_findCachedViewById(R.id.cancelBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onCancelClicked();
            }
        });
        ((CheckableFrameLayout)this._$_findCachedViewById(R.id.flashBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onFlashClicked();
            }
        });
        ((Button)this._$_findCachedViewById(R.id.enableCameraBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onActivateCameraPermission();
            }
        });
        ((ZoomFinderOverlayView)this._$_findCachedViewById(R.id.finder_overlay)).setZoomLevel(1.4f);
        ZoomFinderOverlayView zoomFinderOverlayView = (ZoomFinderOverlayView)this._$_findCachedViewById(R.id.finder_overlay);
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        zoomFinderOverlayView.setFixedFinderHeight((int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)resources.getDisplayMetrics()));
        ((ZoomFinderOverlayView)this._$_findCachedViewById(R.id.finder_overlay)).setRequiredAspectRatios(CollectionsKt.listOf((Object)new FinderAspectRatio(4.0, 1.0)));
        this.initCameraView();
    }

    public static final /* synthetic */ AtomicBoolean access$getCameraOpened$p(GenericDataCameraView $this) {
        return $this.cameraOpened;
    }

    public static final /* synthetic */ GenericTextRecognizer access$getGenericTextRecognizer$p(GenericDataCameraView $this) {
        return $this.genericTextRecognizer;
    }

    public static final /* synthetic */ void access$setGenericTextRecognizer$p(GenericDataCameraView $this, GenericTextRecognizer genericTextRecognizer) {
        $this.genericTextRecognizer = genericTextRecognizer;
    }

    public static final /* synthetic */ GenericTextRecognizerFrameHandler access$getFrameHandler$p(GenericDataCameraView $this) {
        GenericTextRecognizerFrameHandler genericTextRecognizerFrameHandler = $this.frameHandler;
        if (genericTextRecognizerFrameHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
        }
        return genericTextRecognizerFrameHandler;
    }

    public static final /* synthetic */ void access$setFrameHandler$p(GenericDataCameraView $this, GenericTextRecognizerFrameHandler genericTextRecognizerFrameHandler) {
        $this.frameHandler = genericTextRecognizerFrameHandler;
    }

    public static final /* synthetic */ IGenericDataCameraView.State access$getState$p(GenericDataCameraView $this) {
        IGenericDataCameraView.State state = $this.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        return state;
    }

    public static final /* synthetic */ void access$setState$p(GenericDataCameraView $this, IGenericDataCameraView.State state) {
        $this.state = state;
    }

    public static final /* synthetic */ void access$setListener$p(GenericDataCameraView $this, IGenericDataCameraView.Listener listener) {
        $this.listener = listener;
    }

    public static final /* synthetic */ CompositeDisposable access$getSubscriptions$p(GenericDataCameraView $this) {
        return $this.subscriptions;
    }

    public static final /* synthetic */ void access$updateFlashState(GenericDataCameraView $this, boolean flash) {
        $this.updateFlashState(flash);
    }

    public static final /* synthetic */ void access$updateCameraPermissionView(GenericDataCameraView $this, boolean cameraPermissionGranted) {
        $this.updateCameraPermissionView(cameraPermissionGranted);
    }

    public static final /* synthetic */ void access$closeCamera(GenericDataCameraView $this) {
        $this.closeCamera();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ui/view/generictext/GenericDataCameraView$Companion;", "", "()V", "CAMERA_OPENED_DELAY_MILLIS", "", "rtu-ui-generictext_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

