/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.generictext;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraOpenCallback;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.camera.ScanbotCameraView;
import io.scanbot.sdk.generictext.GenericTextRecognitionResult;
import io.scanbot.sdk.generictext.GenericTextRecognizer;
import io.scanbot.sdk.generictext.GenericTextRecognizerFrameHandler;
import io.scanbot.sdk.generictext.TextFilterStrategy;
import io.scanbot.sdk.generictext.ui.WordboxPreviewView;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.camera.ZoomFinderOverlayView;
import io.scanbot.sdk.ui.generictext.R;
import io.scanbot.sdk.ui.utils.CheckableFrameLayout;
import io.scanbot.sdk.ui.utils.events.Signal;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.generictext.ITextDataScannerView;
import io.scanbot.sdk.ui.view.generictext.TextDataScannerView;
import io.scanbot.sdk.ui.view.generictext.TextDataScannerView$WhenMappings;
import io.scanbot.sdk.ui.view.generictext.entity.TextDataScannerStep;
import io.scanbot.sdk.ui.view.interactor.ShakePauseController;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u0003:\u00012B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0014J\b\u0010!\u001a\u00020\u0018H\u0014J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u000eJ\u0010\u0010*\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010+\u001a\u00020\u0018H\u0002J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u001aH\u0002J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u001aH\u0002J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0014H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/scanbot/sdk/ui/view/generictext/TextDataScannerView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/generictext/ITextDataScannerView;", "Lio/scanbot/sdk/generictext/GenericTextRecognizerFrameHandler$ResultHandler;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraOpened", "Ljava/util/concurrent/atomic/AtomicBoolean;", "frameHandler", "Lio/scanbot/sdk/generictext/GenericTextRecognizerFrameHandler;", "genericTextRecognizer", "Lio/scanbot/sdk/generictext/GenericTextRecognizer;", "listener", "Lio/scanbot/sdk/ui/view/generictext/ITextDataScannerView$Listener;", "pauseController", "Lio/scanbot/sdk/ui/view/interactor/ShakePauseController;", "state", "Lio/scanbot/sdk/ui/view/generictext/ITextDataScannerView$State;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "closeCamera", "", "handle", "", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/generictext/GenericTextRecognitionResult;", "Lio/scanbot/sdk/SdkLicenseError;", "initCameraView", "onAttachedToWindow", "onDetachedFromWindow", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOrientationMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setGenericTextRecognizer", "recognizer", "setListener", "subscribeViews", "updateCameraPermissionView", "cameraPermissionGranted", "updateFlashState", "flash", "updateState", "newState", "Companion", "rtu-ui-generictext_release"})
public final class TextDataScannerView
extends FrameLayout
implements ITextDataScannerView,
GenericTextRecognizerFrameHandler.ResultHandler {
    private ITextDataScannerView.State state;
    private ITextDataScannerView.Listener listener;
    private GenericTextRecognizer genericTextRecognizer;
    private GenericTextRecognizerFrameHandler frameHandler;
    private final AtomicBoolean cameraOpened;
    private final CompositeDisposable subscriptions;
    private final ShakePauseController pauseController;
    private static final long CAMERA_OPENED_DELAY_MILLIS = 300L;
    private static final float DEFAULT_ZOOM_LEVEL = 1.4f;
    private static final float DEFAULT_FINDER_HEIGHT = 40.0f;
    private static final float DEFAULT_FINDER_LCD_HEIGHT = 70.0f;
    private static final FinderAspectRatio DEFAULT_ASPECT_RATIO;
    private static final long DEFAULT_SHAKE_DELAY_LICENSE_PLATE_LCD = 1000L;
    @NotNull
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final void setGenericTextRecognizer(@NotNull GenericTextRecognizer recognizer) {
        Intrinsics.checkNotNullParameter((Object)recognizer, (String)"recognizer");
        this.genericTextRecognizer = recognizer;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.pauseController.onResume();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closeCamera();
        this.pauseController.onPause();
    }

    @Override
    public void setListener(@NotNull ITextDataScannerView.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public void updateState(@NotNull ITextDataScannerView.State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state = newState;
        this.subscribeViews();
    }

    public boolean handle(@NotNull FrameHandlerResult<GenericTextRecognitionResult, SdkLicenseError> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        if (this.pauseController.check()) {
            this.listener.genericTextScanned(result);
            if (result instanceof FrameHandlerResult.Success) {
                if (((GenericTextRecognitionResult)((FrameHandlerResult.Success)result).getValue()).getValidationSuccessful()) {
                    GenericTextRecognizerFrameHandler genericTextRecognizerFrameHandler = this.frameHandler;
                    if (genericTextRecognizerFrameHandler == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
                    }
                    genericTextRecognizerFrameHandler.setEnabled(false);
                }
                this.post(new Runnable(this, result){
                    final /* synthetic */ TextDataScannerView this$0;
                    final /* synthetic */ FrameHandlerResult $result;

                    public final void run() {
                        ((WordboxPreviewView)this.this$0._$_findCachedViewById(R.id.wordbox_preview)).updateCharacters(((GenericTextRecognitionResult)((FrameHandlerResult.Success)this.$result).getValue()).getWordBoxes());
                    }
                    {
                        this.this$0 = textDataScannerView;
                        this.$result = frameHandlerResult;
                    }
                });
            }
        }
        return false;
    }

    @Override
    public void setCameraOrientationMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        switch (TextDataScannerView$WhenMappings.$EnumSwitchMapping$0[cameraOrientationMode.ordinal()]) {
            case 1: {
                ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).lockToPortrait(true);
                break;
            }
            case 2: {
                ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).lockToLandscape(true);
                break;
            }
        }
    }

    @Override
    public void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).setCameraModule(cameraModule);
    }

    private final void closeCamera() {
        this.cameraOpened.set(false);
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).onPause();
        this.subscriptions.clear();
    }

    private final void initCameraView() {
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).setPreviewMode(CameraPreviewMode.FILL_IN);
        ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).setCameraOpenCallback(new CameraOpenCallback(this){
            final /* synthetic */ TextDataScannerView this$0;

            public void onCameraOpened() {
                TextDataScannerView.access$getCameraOpened$p(this.this$0).set(true);
                ((ScanbotCameraView)this.this$0._$_findCachedViewById(R.id.scanbotCameraView)).postDelayed(new Runnable(this){
                    final /* synthetic */ initCameraView.1 this$0;

                    public final void run() {
                        GenericTextRecognizer genericTextRecognizer = TextDataScannerView.access$getGenericTextRecognizer$p(this.this$0.this$0);
                        if (genericTextRecognizer != null) {
                            GenericTextRecognizer genericTextRecognizer2 = genericTextRecognizer;
                            boolean bl = false;
                            boolean bl2 = false;
                            GenericTextRecognizer it = genericTextRecognizer2;
                            boolean bl3 = false;
                            TextDataScannerView textDataScannerView = this.this$0.this$0;
                            ScanbotCameraView scanbotCameraView = (ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView);
                            Intrinsics.checkNotNullExpressionValue((Object)scanbotCameraView, (String)"scanbotCameraView");
                            TextDataScannerView.access$setFrameHandler$p(textDataScannerView, GenericTextRecognizerFrameHandler.Companion.attach((IScanbotCameraView)scanbotCameraView, it));
                            TextDataScannerView.access$getFrameHandler$p(this.this$0.this$0).addResultHandler((GenericTextRecognizerFrameHandler.ResultHandler)this.this$0.this$0);
                        }
                        ((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)).setShutterSound(false);
                        ((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)).continuousFocus();
                        ScanbotCameraView scanbotCameraView = (ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView);
                        Object object = TextDataScannerView.access$getState$p(this.this$0.this$0).getFlash().getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this@TextDataScannerView.state.flash.value");
                        scanbotCameraView.useFlash(((Boolean)object).booleanValue());
                        TextDataScannerView.access$getSubscriptions$p(this.this$0.this$0).add(TextDataScannerView.access$getState$p(this.this$0.this$0).getFlash().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
                            final /* synthetic */ initCameraView.onCameraOpened.1 this$0;

                            public final void accept(Boolean flash) {
                                TextDataScannerView textDataScannerView = this.this$0.this$0.this$0;
                                Boolean bl = flash;
                                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"flash");
                                TextDataScannerView.access$updateFlashState(textDataScannerView, bl);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }));
                        ((ScanbotCameraView)this.this$0.this$0._$_findCachedViewById(R.id.scanbotCameraView)).addFrameHandler(new FrameHandler(this){
                            final /* synthetic */ initCameraView.onCameraOpened.1 this$0;

                            public boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
                                Intrinsics.checkNotNullParameter((Object)previewFrame, (String)"previewFrame");
                                ((WordboxPreviewView)this.this$0.this$0.this$0._$_findCachedViewById(R.id.wordbox_preview)).setFrameWidth(previewFrame.getWidth());
                                ((WordboxPreviewView)this.this$0.this$0.this$0._$_findCachedViewById(R.id.wordbox_preview)).setFrameHeight(previewFrame.getHeight());
                                ((WordboxPreviewView)this.this$0.this$0.this$0._$_findCachedViewById(R.id.wordbox_preview)).setFrameOrientation(previewFrame.getFrameOrientation());
                                return false;
                            }
                            {
                                this.this$0 = this$0;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, 300L);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void subscribeViews() {
        ITextDataScannerView.State state = this.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        this.subscriptions.add(state.getCameraPermissionGranted().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ TextDataScannerView this$0;

            public final void accept(Boolean granted) {
                Boolean bl = granted;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"granted");
                if (bl.booleanValue()) {
                    ((ScanbotCameraView)this.this$0._$_findCachedViewById(R.id.scanbotCameraView)).onResume();
                }
                TextDataScannerView.access$updateCameraPermissionView(this.this$0, granted);
            }
            {
                this.this$0 = textDataScannerView;
            }
        }));
        ITextDataScannerView.State state2 = this.state;
        if (state2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        this.subscriptions.add(state2.getCameraClosed().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Signal>(this){
            final /* synthetic */ TextDataScannerView this$0;

            public final void accept(Signal it) {
                TextDataScannerView.access$closeCamera(this.this$0);
            }
            {
                this.this$0 = textDataScannerView;
            }
        }));
        ITextDataScannerView.State state3 = this.state;
        if (state3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        this.subscriptions.add(state3.getCurrentStep().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<TextDataScannerStep>(this){
            final /* synthetic */ TextDataScannerView this$0;

            public final void accept(TextDataScannerStep step) {
                block6: {
                    float f;
                    GenericTextRecognizer genericTextRecognizer = TextDataScannerView.access$getGenericTextRecognizer$p(this.this$0);
                    if (genericTextRecognizer == null) break block6;
                    GenericTextRecognizer genericTextRecognizer2 = genericTextRecognizer;
                    boolean bl = false;
                    boolean bl2 = false;
                    GenericTextRecognizer it = genericTextRecognizer2;
                    boolean bl3 = false;
                    it.setMatchSubstringForPattern(step.getShouldMatchSubstring());
                    it.setValidator(step.getPattern(), step.getValidationCallback());
                    it.setCleaner(step.getCleanRecognitionResultCallback());
                    it.setAllowedSymbols(step.getAllowedSymbols());
                    it.setTextFilterStrategy(step.getTextFilterStrategy());
                    TextDataScannerView.access$getPauseController$p(this.this$0).setDelayAfterMove(step.getSignificantShakeDelay() == -1L ? (step.getTextFilterStrategy() != TextFilterStrategy.Document ? 1000L : 0L) : step.getSignificantShakeDelay());
                    TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.finder_description);
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"finder_description");
                    textView.setText((CharSequence)step.getGuidanceText());
                    ((ZoomFinderOverlayView)this.this$0._$_findCachedViewById(R.id.finder_overlay)).setZoomLevel(step.getPreferredZoom());
                    if (step.getUnzoomedFinderHeight() == -1.0f) {
                        switch (TextDataScannerView$WhenMappings.$EnumSwitchMapping$1[step.getTextFilterStrategy().ordinal()]) {
                            case 1: {
                                f = 70.0f;
                                break;
                            }
                            case 2: 
                            case 3: {
                                f = 70.0f;
                                break;
                            }
                            default: {
                                f = 40.0f;
                                break;
                            }
                        }
                    } else {
                        f = step.getUnzoomedFinderHeight();
                    }
                    float unzoomedFinderHeight = f;
                    ZoomFinderOverlayView zoomFinderOverlayView = (ZoomFinderOverlayView)this.this$0._$_findCachedViewById(R.id.finder_overlay);
                    Resources resources = this.this$0.getResources();
                    Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
                    zoomFinderOverlayView.setFixedFinderHeight((int)TypedValue.applyDimension((int)1, (float)unzoomedFinderHeight, (DisplayMetrics)resources.getDisplayMetrics()));
                    ((ZoomFinderOverlayView)this.this$0._$_findCachedViewById(R.id.finder_overlay)).setRequiredAspectRatios(CollectionsKt.listOf((Object)step.getAspectRatio()));
                }
            }
            {
                this.this$0 = textDataScannerView;
            }
        }));
    }

    private final void updateCameraPermissionView(boolean cameraPermissionGranted) {
        if (cameraPermissionGranted) {
            LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.cameraPermissionView);
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"cameraPermissionView");
            linearLayout.setVisibility(8);
        } else {
            LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.cameraPermissionView);
            Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"cameraPermissionView");
            linearLayout.setVisibility(0);
        }
    }

    private final void updateFlashState(boolean flash) {
        if (this.cameraOpened.get()) {
            CheckableFrameLayout checkableFrameLayout = (CheckableFrameLayout)this._$_findCachedViewById(R.id.flashBtn);
            if (checkableFrameLayout == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.scanbot.sdk.ui.utils.CheckableFrameLayout");
            }
            checkableFrameLayout.setChecked(flash);
            ((ScanbotCameraView)this._$_findCachedViewById(R.id.scanbotCameraView)).useFlash(flash);
        }
    }

    public TextDataScannerView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.listener = ITextDataScannerView.Listener.Companion.getNULL();
        this.cameraOpened = new AtomicBoolean(false);
        this.subscriptions = new CompositeDisposable();
        this.pauseController = new ShakePauseController(context);
        LayoutInflater.from((Context)context).inflate(R.layout.scanbot_sdk_generic_text_camera_view, (ViewGroup)this, true);
        ((TextView)this._$_findCachedViewById(R.id.cancelBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onCancelClicked();
            }
        });
        ((CheckableFrameLayout)this._$_findCachedViewById(R.id.flashBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onFlashClicked();
            }
        });
        ((Button)this._$_findCachedViewById(R.id.enableCameraBtn)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.onActivateCameraPermission();
            }
        });
        ((ZoomFinderOverlayView)this._$_findCachedViewById(R.id.finder_overlay)).setZoomLevel(1.4f);
        ZoomFinderOverlayView zoomFinderOverlayView = (ZoomFinderOverlayView)this._$_findCachedViewById(R.id.finder_overlay);
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        zoomFinderOverlayView.setFixedFinderHeight((int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)resources.getDisplayMetrics()));
        ((ZoomFinderOverlayView)this._$_findCachedViewById(R.id.finder_overlay)).setRequiredAspectRatios(CollectionsKt.listOf((Object)DEFAULT_ASPECT_RATIO));
        CheckableFrameLayout checkableFrameLayout = (CheckableFrameLayout)this._$_findCachedViewById(R.id.flashBtn);
        Intrinsics.checkNotNullExpressionValue((Object)checkableFrameLayout, (String)"flashBtn");
        checkableFrameLayout.setVisibility(context.getPackageManager().hasSystemFeature("android.hardware.camera.flash") ? 0 : 4);
        this.initCameraView();
    }

    static {
        Companion = new Companion(null);
        DEFAULT_ASPECT_RATIO = new FinderAspectRatio(4.0, 1.0);
    }

    public static final /* synthetic */ AtomicBoolean access$getCameraOpened$p(TextDataScannerView $this) {
        return $this.cameraOpened;
    }

    public static final /* synthetic */ GenericTextRecognizer access$getGenericTextRecognizer$p(TextDataScannerView $this) {
        return $this.genericTextRecognizer;
    }

    public static final /* synthetic */ void access$setGenericTextRecognizer$p(TextDataScannerView $this, GenericTextRecognizer genericTextRecognizer) {
        $this.genericTextRecognizer = genericTextRecognizer;
    }

    public static final /* synthetic */ GenericTextRecognizerFrameHandler access$getFrameHandler$p(TextDataScannerView $this) {
        GenericTextRecognizerFrameHandler genericTextRecognizerFrameHandler = $this.frameHandler;
        if (genericTextRecognizerFrameHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"frameHandler");
        }
        return genericTextRecognizerFrameHandler;
    }

    public static final /* synthetic */ void access$setFrameHandler$p(TextDataScannerView $this, GenericTextRecognizerFrameHandler genericTextRecognizerFrameHandler) {
        $this.frameHandler = genericTextRecognizerFrameHandler;
    }

    public static final /* synthetic */ ITextDataScannerView.State access$getState$p(TextDataScannerView $this) {
        ITextDataScannerView.State state = $this.state;
        if (state == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"state");
        }
        return state;
    }

    public static final /* synthetic */ void access$setState$p(TextDataScannerView $this, ITextDataScannerView.State state) {
        $this.state = state;
    }

    public static final /* synthetic */ CompositeDisposable access$getSubscriptions$p(TextDataScannerView $this) {
        return $this.subscriptions;
    }

    public static final /* synthetic */ void access$updateFlashState(TextDataScannerView $this, boolean flash) {
        $this.updateFlashState(flash);
    }

    public static final /* synthetic */ void access$updateCameraPermissionView(TextDataScannerView $this, boolean cameraPermissionGranted) {
        $this.updateCameraPermissionView(cameraPermissionGranted);
    }

    public static final /* synthetic */ void access$closeCamera(TextDataScannerView $this) {
        $this.closeCamera();
    }

    public static final /* synthetic */ ShakePauseController access$getPauseController$p(TextDataScannerView $this) {
        return $this.pauseController;
    }

    public static final /* synthetic */ void access$setListener$p(TextDataScannerView $this, ITextDataScannerView.Listener listener) {
        $this.listener = listener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/scanbot/sdk/ui/view/generictext/TextDataScannerView$Companion;", "", "()V", "CAMERA_OPENED_DELAY_MILLIS", "", "DEFAULT_ASPECT_RATIO", "Lio/scanbot/sdk/ui/camera/FinderAspectRatio;", "DEFAULT_FINDER_HEIGHT", "", "DEFAULT_FINDER_LCD_HEIGHT", "DEFAULT_SHAKE_DELAY_LICENSE_PLATE_LCD", "DEFAULT_ZOOM_LEVEL", "rtu-ui-generictext_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

