/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.idcard.list;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import io.scanbot.sdk.idcardscanner.IdScanResult;
import io.scanbot.sdk.ui.idcard.R;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldDiffCallback;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListView;
import io.scanbot.sdk.ui.view.idcard.list.IdCardItemViewHolder;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0013B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldItemAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lio/scanbot/sdk/idcardscanner/IdScanResult$Field;", "Lio/scanbot/sdk/ui/view/idcard/list/IdCardItemViewHolder;", "context", "Landroid/content/Context;", "configProvider", "Ljavax/inject/Provider;", "Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListView$Configuration;", "(Landroid/content/Context;Ljavax/inject/Provider;)V", "onBindViewHolder", "", "holder", "position", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "Companion", "rtu-ui-idcard_release"})
public final class IdCardFieldItemAdapter
extends ListAdapter<IdScanResult.Field, IdCardItemViewHolder> {
    private final Context context;
    private final Provider<IdCardFieldListView.Configuration> configProvider;
    private static final int TYPE_TITLE_FIELD_ALPHA = 180;
    private static final int IMAGE_ID_CARD_FIELD_ALPHA = 100;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public IdCardItemViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View view;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view2 = view = LayoutInflater.from((Context)this.context).inflate(R.layout.scanbot_sdk_id_card_field_item, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"view");
        IdCardItemViewHolder holder = new IdCardItemViewHolder(view2);
        int n = ((IdCardFieldListView.Configuration)this.configProvider.get()).getPrimaryColor();
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        holder.getValue().setTextColor(it);
        holder.getType().setTextColor(Color.argb((int)180, (int)Color.red((int)it), (int)Color.green((int)it), (int)Color.blue((int)it)));
        holder.getImage().setBackgroundTintList(ColorStateList.valueOf((int)Color.argb((int)100, (int)Color.red((int)it), (int)Color.green((int)it), (int)Color.blue((int)it))));
        n = ((IdCardFieldListView.Configuration)this.configProvider.get()).getFieldConfidenceTextColor();
        bl = false;
        bl2 = false;
        it = n;
        boolean bl4 = false;
        holder.getConfidenceImage().setImageTintList(ColorStateList.valueOf((int)it));
        holder.getConfidence().setTextColor(it);
        return holder;
    }

    public void onBindViewHolder(@NotNull IdCardItemViewHolder holder, int position) {
        boolean bl;
        boolean bl2;
        Object object;
        float f;
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        IdScanResult.Field idCardField = (IdScanResult.Field)this.getItem(position);
        holder.getImage().setImageBitmap(idCardField.getVisualSource());
        holder.getValue().setText((CharSequence)idCardField.getText());
        String string2 = ((IdCardFieldListView.Configuration)this.configProvider.get()).getCustomTranslationMap().get(idCardField.getType());
        holder.getType().setText(string2 != null ? (CharSequence)string2 : (CharSequence)idCardField.getType().name());
        boolean isImage = CollectionsKt.listOf((Object[])new IdScanResult.Field.Type[]{IdScanResult.Field.Type.Signature, IdScanResult.Field.Type.Photo}).contains(idCardField.getType());
        if (isImage) {
            f = 1.0f;
        } else if (idCardField.getType() == IdScanResult.Field.Type.Pseudonym) {
            object = idCardField.getText();
            bl2 = false;
            bl = false;
            f = object == null || StringsKt.isBlank((CharSequence)object) ? 0.0f : 1.0f;
        } else {
            f = idCardField.getTextConfidence();
        }
        float conf = f;
        holder.getConfidence().setText((CharSequence)"");
        if (isImage) {
            holder.getValue().setText((CharSequence)((IdCardFieldListView.Configuration)this.configProvider.get()).getImageTitle());
            holder.getConfidenceImage().setVisibility(0);
            holder.getConfidenceImage().setImageResource(R.drawable.id_card_scanner_checked);
        } else if (conf == 0.0f) {
            holder.getConfidenceImage().setVisibility(0);
            holder.getConfidenceImage().setImageResource(R.drawable.id_card_scanner_crossed);
        } else {
            int textConfidence = MathKt.roundToInt((float)(conf * (float)100));
            holder.getConfidence().setText((CharSequence)String.valueOf(textConfidence));
            holder.getConfidenceImage().setVisibility(8);
        }
        object = this.configProvider.get();
        bl2 = false;
        bl = false;
        IdCardFieldListView.Configuration config = (IdCardFieldListView.Configuration)object;
        boolean bl3 = false;
        holder.getConfidenceLayout().setBackgroundTintList((double)conf > 0.9 ? ColorStateList.valueOf((int)config.getFieldConfidenceHighColor()) : ((double)conf > 0.5 ? ColorStateList.valueOf((int)config.getFieldConfidenceModerateColor()) : ColorStateList.valueOf((int)config.getFieldConfidenceLowColor())));
    }

    public IdCardFieldItemAdapter(@NotNull Context context, @NotNull Provider<IdCardFieldListView.Configuration> configProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(configProvider, (String)"configProvider");
        super((DiffUtil.ItemCallback)new IdCardFieldDiffCallback());
        this.context = context;
        this.configProvider = configProvider;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldItemAdapter$Companion;", "", "()V", "IMAGE_ID_CARD_FIELD_ALPHA", "", "TYPE_TITLE_FIELD_ALPHA", "rtu-ui-idcard_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

