/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.idcard.list;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.transition.Fade;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.scanbot.sdk.idcardscanner.IdScanResult;
import io.scanbot.sdk.ui.idcard.R;
import io.scanbot.sdk.ui.view.idcard.list.IIdCardFieldListView;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldItemAdapter;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListView;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListView$WhenMappings;
import io.scanbot.sdk.ui.view.widget.ToastView;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0002)*B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u001dH\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0017H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "bottomSheetBehavior", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "Landroid/view/View;", "configuration", "Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListView$Configuration;", "getConfiguration", "()Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListView$Configuration;", "currentList", "", "Lio/scanbot/sdk/idcardscanner/IdScanResult$Field;", "idCardFieldAdapter", "Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldItemAdapter;", "listener", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView$Listener;", "state", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView$State;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "onBackPressed", "", "onDetachedFromWindow", "", "setBottomSheetBackgroundColor", "color", "", "setBottomSheetPrimaryColor", "setListener", "showToast", "message", "", "toggleDetails", "updateState", "newState", "Companion", "Configuration", "rtu-ui-idcard_release"})
public final class IdCardFieldListView
extends FrameLayout
implements IIdCardFieldListView {
    private IIdCardFieldListView.State state;
    private IIdCardFieldListView.Listener listener;
    private final CompositeDisposable subscriptions;
    private final IdCardFieldItemAdapter idCardFieldAdapter;
    private List<IdScanResult.Field> currentList;
    private BottomSheetBehavior<View> bottomSheetBehavior;
    @NotNull
    private final Configuration configuration;
    private static final int DISABLED_BUTTON_ALPHA = 100;
    private static final long FADE_ANIMATION_DURATION_MS = 100L;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    private final void toggleDetails() {
        this.bottomSheetBehavior.setState(this.bottomSheetBehavior.getState() == 3 ? 4 : 3);
    }

    @Override
    public void setListener(@NotNull IIdCardFieldListView.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public void updateState(@NotNull IIdCardFieldListView.State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state = newState;
        this.subscriptions.add(this.state.getIdCardFields().map((Function)updateState.1.INSTANCE).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).distinctUntilChanged().subscribe((Consumer)new Consumer<List<? extends IdScanResult.Field>>(this){
            final /* synthetic */ IdCardFieldListView this$0;

            public final void accept(List<IdScanResult.Field> list) {
                List<IdScanResult.Field> list2 = list;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"list");
                IdCardFieldListView.access$setCurrentList$p(this.this$0, CollectionsKt.toList((Iterable)CollectionsKt.reversed((Iterable)list2)));
                IdCardFieldListView.access$getIdCardFieldAdapter$p(this.this$0).submitList(IdCardFieldListView.access$getCurrentList$p(this.this$0), new Runnable(this){
                    final /* synthetic */ updateState.2 this$0;

                    public final void run() {
                        ((RecyclerView)this.this$0.this$0._$_findCachedViewById(R.id.id_card_vertical_recycler_view)).scrollToPosition(0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Button button = (Button)this.this$0._$_findCachedViewById(R.id.id_card_clear_button);
                Intrinsics.checkNotNullExpressionValue((Object)button, (String)"id_card_clear_button");
                Collection collection = list;
                boolean bl = false;
                button.setEnabled(!collection.isEmpty());
                ((TextView)this.this$0._$_findCachedViewById(R.id.id_card_fields_count)).setTextColor(this.this$0.getConfiguration().getFieldsCountTextColor());
                TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.id_card_fields_count);
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"id_card_fields_count");
                collection = StringCompanionObject.INSTANCE;
                String string2 = this.this$0.getConfiguration().getFieldsCountText();
                Object[] objectArray = new Object[]{list.size()};
                boolean bl2 = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                textView.setText((CharSequence)string3);
                Button button2 = (Button)this.this$0._$_findCachedViewById(R.id.id_card_submit_button);
                Intrinsics.checkNotNullExpressionValue((Object)button2, (String)"id_card_submit_button");
                collection = list;
                boolean bl3 = false;
                button2.setEnabled(!collection.isEmpty());
            }
            {
                this.this$0 = idCardFieldListView;
            }
        }));
        this.subscriptions.add(this.state.getAverageConfidence().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).distinctUntilChanged().subscribe((Consumer)new Consumer<Double>(this){
            final /* synthetic */ IdCardFieldListView this$0;

            public final void accept(Double confidence) {
                if (confidence > 0.0) {
                    TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.id_card_confidence_view);
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"id_card_confidence_view");
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = this.this$0.getConfiguration().getConfidenceValue();
                    Object[] objectArray = new Object[]{MathKt.roundToInt((double)(confidence * (double)100))};
                    boolean bl = false;
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                    textView.setText((CharSequence)string3);
                    ((TextView)this.this$0._$_findCachedViewById(R.id.id_card_confidence_view)).setBackgroundResource(R.drawable.scanbot_rounded_corners);
                    ((TextView)this.this$0._$_findCachedViewById(R.id.id_card_confidence_view)).setTextColor(this.this$0.getConfiguration().getFieldConfidenceTextColor());
                    TextView textView2 = (TextView)this.this$0._$_findCachedViewById(R.id.id_card_confidence_view);
                    Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"id_card_confidence_view");
                    textView2.setBackgroundTintList(ColorStateList.valueOf((int)(confidence > 0.9 ? this.this$0.getConfiguration().getFieldConfidenceHighColor() : (confidence > 0.5 ? this.this$0.getConfiguration().getFieldConfidenceModerateColor() : this.this$0.getConfiguration().getFieldConfidenceLowColor()))));
                } else {
                    TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.id_card_confidence_view);
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"id_card_confidence_view");
                    textView.setText((CharSequence)this.this$0.getConfiguration().getNoDataTitle());
                    ((TextView)this.this$0._$_findCachedViewById(R.id.id_card_confidence_view)).setTextColor(this.this$0.getConfiguration().getPrimaryColor());
                    TextView textView3 = (TextView)this.this$0._$_findCachedViewById(R.id.id_card_confidence_view);
                    Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"id_card_confidence_view");
                    textView3.setBackground((Drawable)null);
                }
            }
            {
                this.this$0 = idCardFieldListView;
            }
        }));
        this.subscriptions.add(this.state.getScanningStep().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).distinctUntilChanged().subscribe((Consumer)new Consumer<IIdCardFieldListView.ScanningStep>(this){
            final /* synthetic */ IdCardFieldListView this$0;

            public final void accept(IIdCardFieldListView.ScanningStep step) {
                IIdCardFieldListView.ScanningStep scanningStep = step;
                if (scanningStep != null) {
                    switch (IdCardFieldListView$WhenMappings.$EnumSwitchMapping$0[scanningStep.ordinal()]) {
                        case 1: {
                            IdCardFieldListView.access$showToast(this.this$0, this.this$0.getConfiguration().getStartScanningTitle());
                            break;
                        }
                        case 2: {
                            IdCardFieldListView.access$showToast(this.this$0, this.this$0.getConfiguration().getScanBackSideTitle());
                            break;
                        }
                        case 3: {
                            IdCardFieldListView.access$showToast(this.this$0, this.this$0.getConfiguration().getScanFrontSideTitle());
                            break;
                        }
                        case 4: {
                            IdCardFieldListView.access$showToast(this.this$0, this.this$0.getConfiguration().getScannedEverythingTitle());
                            break;
                        }
                    }
                }
            }
            {
                this.this$0 = idCardFieldListView;
            }
        }));
    }

    private final void showToast(String message) {
        ((ToastView)this._$_findCachedViewById(R.id.id_card_toast_view)).setToastBackgroundColor(this.configuration.getTipBackgroundColor());
        ((ToastView)this._$_findCachedViewById(R.id.id_card_toast_view)).setTextColor(this.configuration.getTipTextColor());
        ((ToastView)this._$_findCachedViewById(R.id.id_card_toast_view)).showToast(message, ToastView.Duration.SHORT);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.subscriptions.clear();
    }

    public final void setBottomSheetBackgroundColor(int color) {
        LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.id_card_bottom_sheet);
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"id_card_bottom_sheet");
        linearLayout.setBackgroundTintList(ColorStateList.valueOf((int)color));
    }

    public final void setBottomSheetPrimaryColor(int color) {
        ((Button)this._$_findCachedViewById(R.id.id_card_clear_button)).setTextColor(new ColorStateList((int[][])new int[][]{{-16842910}, new int[0]}, new int[]{Color.argb((int)100, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color)), color}));
        ImageView imageView = (ImageView)this._$_findCachedViewById(R.id.id_card_bottom_sheet_peek_arrow);
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"id_card_bottom_sheet_peek_arrow");
        imageView.setImageTintList(ColorStateList.valueOf((int)color));
        ((TextView)this._$_findCachedViewById(R.id.id_card_confidence_view)).setTextColor(color);
        this.configuration.setPrimaryColor(color);
        this.idCardFieldAdapter.notifyDataSetChanged();
    }

    public final boolean onBackPressed() {
        if (this.bottomSheetBehavior.getState() != 4) {
            this.bottomSheetBehavior.setState(4);
            return true;
        }
        return false;
    }

    public IdCardFieldListView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.state = IIdCardFieldListView.State.Companion.getDEFAULT();
        this.listener = IIdCardFieldListView.Listener.Companion.getNULL();
        this.subscriptions = new CompositeDisposable();
        boolean bl = false;
        this.currentList = CollectionsKt.emptyList();
        LayoutInflater.from((Context)context).inflate(R.layout.scanbot_sdk_idcard_list_view, (ViewGroup)this, true);
        ((Button)this._$_findCachedViewById(R.id.id_card_clear_button)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.clearClick();
            }
        });
        ((Button)this._$_findCachedViewById(R.id.id_card_submit_button)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.submitButtonClick();
            }
        });
        ((TextView)this._$_findCachedViewById(R.id.id_card_confidence_view)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                this.toggleDetails();
            }
        });
        ((ImageView)this._$_findCachedViewById(R.id.id_card_bottom_sheet_peek_arrow)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                this.toggleDetails();
            }
        });
        this.configuration = Configuration.Companion.prepareDefault(context);
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.id_card_vertical_recycler_view);
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"id_card_vertical_recycler_view");
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 1, false));
        this.idCardFieldAdapter = new IdCardFieldItemAdapter(context, (Provider<Configuration>)((Provider)new Provider<Configuration>(){

            public final Configuration get() {
                return this.getConfiguration();
            }
        }));
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.id_card_vertical_recycler_view);
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"id_card_vertical_recycler_view");
        recyclerView2.setAdapter((RecyclerView.Adapter)this.idCardFieldAdapter);
        LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.id_card_bottom_sheet);
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"id_card_bottom_sheet");
        ViewGroup.LayoutParams layoutParams = linearLayout.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.coordinatorlayout.widget.CoordinatorLayout.LayoutParams");
        }
        CoordinatorLayout.LayoutParams layoutParams2 = (CoordinatorLayout.LayoutParams)layoutParams;
        CoordinatorLayout.Behavior behavior = layoutParams2.getBehavior();
        if (behavior == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.android.material.bottomsheet.BottomSheetBehavior<android.view.View>");
        }
        this.bottomSheetBehavior = (BottomSheetBehavior)behavior;
        this.bottomSheetBehavior.addBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(){

            public void onSlide(@NotNull View bottomSheet, float slideOffset) {
                Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
            }

            public void onStateChanged(@NotNull View bottomSheet, int newState) {
                Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
                if (newState == 3) {
                    this.animateFieldsCount();
                    TextView textView = (TextView)this._$_findCachedViewById(R.id.id_card_fields_count);
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"id_card_fields_count");
                    textView.setVisibility(0);
                    listener.detailsOpened();
                } else {
                    this.animateFieldsCount();
                    TextView textView = (TextView)this._$_findCachedViewById(R.id.id_card_fields_count);
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"id_card_fields_count");
                    textView.setVisibility(4);
                    if (newState == 4 || newState == 5) {
                        listener.detailsClosed();
                    }
                }
            }

            private final void animateFieldsCount() {
                Fade fade = new Fade();
                fade.setDuration(100L);
                TextView textView = (TextView)this._$_findCachedViewById(R.id.id_card_fields_count);
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"id_card_fields_count");
                ViewParent viewParent = textView.getParent();
                if (viewParent == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                }
                TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)viewParent), (Transition)((Transition)fade));
            }
        });
    }

    public static final /* synthetic */ List access$getCurrentList$p(IdCardFieldListView $this) {
        return $this.currentList;
    }

    public static final /* synthetic */ void access$setCurrentList$p(IdCardFieldListView $this, List list) {
        $this.currentList = list;
    }

    public static final /* synthetic */ IdCardFieldItemAdapter access$getIdCardFieldAdapter$p(IdCardFieldListView $this) {
        return $this.idCardFieldAdapter;
    }

    public static final /* synthetic */ void access$showToast(IdCardFieldListView $this, String message) {
        $this.showToast(message);
    }

    public static final /* synthetic */ void access$setListener$p(IdCardFieldListView $this, IIdCardFieldListView.Listener listener) {
        $this.listener = listener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b:\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 U2\u00020\u0001:\u0001UB\u00ab\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\f\u0012\b\b\u0001\u0010\u000e\u001a\u00020\f\u0012\b\b\u0001\u0010\u000f\u001a\u00020\f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\f\u0012\b\b\u0001\u0010\u0011\u001a\u00020\f\u0012\b\b\u0001\u0010\u0012\u001a\u00020\f\u0012\b\b\u0001\u0010\u0013\u001a\u00020\f\u0012\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030\u0015\u00a2\u0006\u0002\u0010\u0017J\t\u0010>\u001a\u00020\u0003H\u00c6\u0003J\t\u0010?\u001a\u00020\fH\u00c6\u0003J\t\u0010@\u001a\u00020\fH\u00c6\u0003J\t\u0010A\u001a\u00020\fH\u00c6\u0003J\t\u0010B\u001a\u00020\fH\u00c6\u0003J\t\u0010C\u001a\u00020\fH\u00c6\u0003J\t\u0010D\u001a\u00020\fH\u00c6\u0003J\t\u0010E\u001a\u00020\fH\u00c6\u0003J\u0015\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030\u0015H\u00c6\u0003J\t\u0010G\u001a\u00020\u0003H\u00c6\u0003J\t\u0010H\u001a\u00020\u0003H\u00c6\u0003J\t\u0010I\u001a\u00020\u0003H\u00c6\u0003J\t\u0010J\u001a\u00020\u0003H\u00c6\u0003J\t\u0010K\u001a\u00020\u0003H\u00c6\u0003J\t\u0010L\u001a\u00020\u0003H\u00c6\u0003J\t\u0010M\u001a\u00020\u0003H\u00c6\u0003J\t\u0010N\u001a\u00020\fH\u00c6\u0003J\u00bf\u0001\u0010O\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0003\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\f2\b\b\u0003\u0010\u000e\u001a\u00020\f2\b\b\u0003\u0010\u000f\u001a\u00020\f2\b\b\u0003\u0010\u0010\u001a\u00020\f2\b\b\u0003\u0010\u0011\u001a\u00020\f2\b\b\u0003\u0010\u0012\u001a\u00020\f2\b\b\u0003\u0010\u0013\u001a\u00020\f2\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030\u0015H\u00c6\u0001J\u0013\u0010P\u001a\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010S\u001a\u00020\fH\u00d6\u0001J\t\u0010T\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\u0010\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010\u000f\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001f\"\u0004\b%\u0010!R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0019\"\u0004\b)\u0010\u001bR\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001f\"\u0004\b+\u0010!R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0019\"\u0004\b-\u0010\u001bR\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0019\"\u0004\b/\u0010\u001bR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u001f\"\u0004\b1\u0010!R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0019\"\u0004\b3\u0010\u001bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0019\"\u0004\b5\u0010\u001bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0019\"\u0004\b7\u0010\u001bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0019\"\u0004\b9\u0010\u001bR\u001a\u0010\u0013\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u001f\"\u0004\b;\u0010!R\u001a\u0010\u0012\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u001f\"\u0004\b=\u0010!\u00a8\u0006V"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListView$Configuration;", "", "scanBackSideTitle", "", "scanFrontSideTitle", "startScanningTitle", "scannedEverythingTitle", "confidenceValue", "fieldsCountText", "imageTitle", "noDataTitle", "primaryColor", "", "fieldsCountTextColor", "fieldConfidenceHighColor", "fieldConfidenceModerateColor", "fieldConfidenceLowColor", "fieldConfidenceTextColor", "tipTextColor", "tipBackgroundColor", "customTranslationMap", "", "Lio/scanbot/sdk/idcardscanner/IdScanResult$Field$Type;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IIIIIIIILjava/util/Map;)V", "getConfidenceValue", "()Ljava/lang/String;", "setConfidenceValue", "(Ljava/lang/String;)V", "getCustomTranslationMap", "()Ljava/util/Map;", "getFieldConfidenceHighColor", "()I", "setFieldConfidenceHighColor", "(I)V", "getFieldConfidenceLowColor", "setFieldConfidenceLowColor", "getFieldConfidenceModerateColor", "setFieldConfidenceModerateColor", "getFieldConfidenceTextColor", "setFieldConfidenceTextColor", "getFieldsCountText", "setFieldsCountText", "getFieldsCountTextColor", "setFieldsCountTextColor", "getImageTitle", "setImageTitle", "getNoDataTitle", "setNoDataTitle", "getPrimaryColor", "setPrimaryColor", "getScanBackSideTitle", "setScanBackSideTitle", "getScanFrontSideTitle", "setScanFrontSideTitle", "getScannedEverythingTitle", "setScannedEverythingTitle", "getStartScanningTitle", "setStartScanningTitle", "getTipBackgroundColor", "setTipBackgroundColor", "getTipTextColor", "setTipTextColor", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "rtu-ui-idcard_release"})
    public static final class Configuration {
        @NotNull
        private String scanBackSideTitle;
        @NotNull
        private String scanFrontSideTitle;
        @NotNull
        private String startScanningTitle;
        @NotNull
        private String scannedEverythingTitle;
        @NotNull
        private String confidenceValue;
        @NotNull
        private String fieldsCountText;
        @NotNull
        private String imageTitle;
        @NotNull
        private String noDataTitle;
        private int primaryColor;
        private int fieldsCountTextColor;
        private int fieldConfidenceHighColor;
        private int fieldConfidenceModerateColor;
        private int fieldConfidenceLowColor;
        private int fieldConfidenceTextColor;
        private int tipTextColor;
        private int tipBackgroundColor;
        @NotNull
        private final Map<IdScanResult.Field.Type, String> customTranslationMap;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getScanBackSideTitle() {
            return this.scanBackSideTitle;
        }

        public final void setScanBackSideTitle(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.scanBackSideTitle = string2;
        }

        @NotNull
        public final String getScanFrontSideTitle() {
            return this.scanFrontSideTitle;
        }

        public final void setScanFrontSideTitle(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.scanFrontSideTitle = string2;
        }

        @NotNull
        public final String getStartScanningTitle() {
            return this.startScanningTitle;
        }

        public final void setStartScanningTitle(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.startScanningTitle = string2;
        }

        @NotNull
        public final String getScannedEverythingTitle() {
            return this.scannedEverythingTitle;
        }

        public final void setScannedEverythingTitle(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.scannedEverythingTitle = string2;
        }

        @NotNull
        public final String getConfidenceValue() {
            return this.confidenceValue;
        }

        public final void setConfidenceValue(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.confidenceValue = string2;
        }

        @NotNull
        public final String getFieldsCountText() {
            return this.fieldsCountText;
        }

        public final void setFieldsCountText(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.fieldsCountText = string2;
        }

        @NotNull
        public final String getImageTitle() {
            return this.imageTitle;
        }

        public final void setImageTitle(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.imageTitle = string2;
        }

        @NotNull
        public final String getNoDataTitle() {
            return this.noDataTitle;
        }

        public final void setNoDataTitle(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.noDataTitle = string2;
        }

        public final int getPrimaryColor() {
            return this.primaryColor;
        }

        public final void setPrimaryColor(int n) {
            this.primaryColor = n;
        }

        public final int getFieldsCountTextColor() {
            return this.fieldsCountTextColor;
        }

        public final void setFieldsCountTextColor(int n) {
            this.fieldsCountTextColor = n;
        }

        public final int getFieldConfidenceHighColor() {
            return this.fieldConfidenceHighColor;
        }

        public final void setFieldConfidenceHighColor(int n) {
            this.fieldConfidenceHighColor = n;
        }

        public final int getFieldConfidenceModerateColor() {
            return this.fieldConfidenceModerateColor;
        }

        public final void setFieldConfidenceModerateColor(int n) {
            this.fieldConfidenceModerateColor = n;
        }

        public final int getFieldConfidenceLowColor() {
            return this.fieldConfidenceLowColor;
        }

        public final void setFieldConfidenceLowColor(int n) {
            this.fieldConfidenceLowColor = n;
        }

        public final int getFieldConfidenceTextColor() {
            return this.fieldConfidenceTextColor;
        }

        public final void setFieldConfidenceTextColor(int n) {
            this.fieldConfidenceTextColor = n;
        }

        public final int getTipTextColor() {
            return this.tipTextColor;
        }

        public final void setTipTextColor(int n) {
            this.tipTextColor = n;
        }

        public final int getTipBackgroundColor() {
            return this.tipBackgroundColor;
        }

        public final void setTipBackgroundColor(int n) {
            this.tipBackgroundColor = n;
        }

        @NotNull
        public final Map<IdScanResult.Field.Type, String> getCustomTranslationMap() {
            return this.customTranslationMap;
        }

        public Configuration(@NotNull String scanBackSideTitle, @NotNull String scanFrontSideTitle, @NotNull String startScanningTitle, @NotNull String scannedEverythingTitle, @NotNull String confidenceValue, @NotNull String fieldsCountText, @NotNull String imageTitle, @NotNull String noDataTitle, @ColorInt int primaryColor, @ColorInt int fieldsCountTextColor, @ColorInt int fieldConfidenceHighColor, @ColorInt int fieldConfidenceModerateColor, @ColorInt int fieldConfidenceLowColor, @ColorInt int fieldConfidenceTextColor, @ColorInt int tipTextColor, @ColorInt int tipBackgroundColor, @NotNull Map<IdScanResult.Field.Type, String> customTranslationMap) {
            Intrinsics.checkNotNullParameter((Object)scanBackSideTitle, (String)"scanBackSideTitle");
            Intrinsics.checkNotNullParameter((Object)scanFrontSideTitle, (String)"scanFrontSideTitle");
            Intrinsics.checkNotNullParameter((Object)startScanningTitle, (String)"startScanningTitle");
            Intrinsics.checkNotNullParameter((Object)scannedEverythingTitle, (String)"scannedEverythingTitle");
            Intrinsics.checkNotNullParameter((Object)confidenceValue, (String)"confidenceValue");
            Intrinsics.checkNotNullParameter((Object)fieldsCountText, (String)"fieldsCountText");
            Intrinsics.checkNotNullParameter((Object)imageTitle, (String)"imageTitle");
            Intrinsics.checkNotNullParameter((Object)noDataTitle, (String)"noDataTitle");
            Intrinsics.checkNotNullParameter(customTranslationMap, (String)"customTranslationMap");
            this.scanBackSideTitle = scanBackSideTitle;
            this.scanFrontSideTitle = scanFrontSideTitle;
            this.startScanningTitle = startScanningTitle;
            this.scannedEverythingTitle = scannedEverythingTitle;
            this.confidenceValue = confidenceValue;
            this.fieldsCountText = fieldsCountText;
            this.imageTitle = imageTitle;
            this.noDataTitle = noDataTitle;
            this.primaryColor = primaryColor;
            this.fieldsCountTextColor = fieldsCountTextColor;
            this.fieldConfidenceHighColor = fieldConfidenceHighColor;
            this.fieldConfidenceModerateColor = fieldConfidenceModerateColor;
            this.fieldConfidenceLowColor = fieldConfidenceLowColor;
            this.fieldConfidenceTextColor = fieldConfidenceTextColor;
            this.tipTextColor = tipTextColor;
            this.tipBackgroundColor = tipBackgroundColor;
            this.customTranslationMap = customTranslationMap;
        }

        public /* synthetic */ Configuration(String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Map map, int n9, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n9 & 0x10000) != 0) {
                map = new EnumMap(IdScanResult.Field.Type.class);
            }
            this(string2, string3, string4, string5, string6, string7, string8, string9, n, n2, n3, n4, n5, n6, n7, n8, map);
        }

        @NotNull
        public final String component1() {
            return this.scanBackSideTitle;
        }

        @NotNull
        public final String component2() {
            return this.scanFrontSideTitle;
        }

        @NotNull
        public final String component3() {
            return this.startScanningTitle;
        }

        @NotNull
        public final String component4() {
            return this.scannedEverythingTitle;
        }

        @NotNull
        public final String component5() {
            return this.confidenceValue;
        }

        @NotNull
        public final String component6() {
            return this.fieldsCountText;
        }

        @NotNull
        public final String component7() {
            return this.imageTitle;
        }

        @NotNull
        public final String component8() {
            return this.noDataTitle;
        }

        public final int component9() {
            return this.primaryColor;
        }

        public final int component10() {
            return this.fieldsCountTextColor;
        }

        public final int component11() {
            return this.fieldConfidenceHighColor;
        }

        public final int component12() {
            return this.fieldConfidenceModerateColor;
        }

        public final int component13() {
            return this.fieldConfidenceLowColor;
        }

        public final int component14() {
            return this.fieldConfidenceTextColor;
        }

        public final int component15() {
            return this.tipTextColor;
        }

        public final int component16() {
            return this.tipBackgroundColor;
        }

        @NotNull
        public final Map<IdScanResult.Field.Type, String> component17() {
            return this.customTranslationMap;
        }

        @NotNull
        public final Configuration copy(@NotNull String scanBackSideTitle, @NotNull String scanFrontSideTitle, @NotNull String startScanningTitle, @NotNull String scannedEverythingTitle, @NotNull String confidenceValue, @NotNull String fieldsCountText, @NotNull String imageTitle, @NotNull String noDataTitle, @ColorInt int primaryColor, @ColorInt int fieldsCountTextColor, @ColorInt int fieldConfidenceHighColor, @ColorInt int fieldConfidenceModerateColor, @ColorInt int fieldConfidenceLowColor, @ColorInt int fieldConfidenceTextColor, @ColorInt int tipTextColor, @ColorInt int tipBackgroundColor, @NotNull Map<IdScanResult.Field.Type, String> customTranslationMap) {
            Intrinsics.checkNotNullParameter((Object)scanBackSideTitle, (String)"scanBackSideTitle");
            Intrinsics.checkNotNullParameter((Object)scanFrontSideTitle, (String)"scanFrontSideTitle");
            Intrinsics.checkNotNullParameter((Object)startScanningTitle, (String)"startScanningTitle");
            Intrinsics.checkNotNullParameter((Object)scannedEverythingTitle, (String)"scannedEverythingTitle");
            Intrinsics.checkNotNullParameter((Object)confidenceValue, (String)"confidenceValue");
            Intrinsics.checkNotNullParameter((Object)fieldsCountText, (String)"fieldsCountText");
            Intrinsics.checkNotNullParameter((Object)imageTitle, (String)"imageTitle");
            Intrinsics.checkNotNullParameter((Object)noDataTitle, (String)"noDataTitle");
            Intrinsics.checkNotNullParameter(customTranslationMap, (String)"customTranslationMap");
            return new Configuration(scanBackSideTitle, scanFrontSideTitle, startScanningTitle, scannedEverythingTitle, confidenceValue, fieldsCountText, imageTitle, noDataTitle, primaryColor, fieldsCountTextColor, fieldConfidenceHighColor, fieldConfidenceModerateColor, fieldConfidenceLowColor, fieldConfidenceTextColor, tipTextColor, tipBackgroundColor, customTranslationMap);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Map map, int n9, Object object) {
            if ((n9 & 1) != 0) {
                string2 = configuration.scanBackSideTitle;
            }
            if ((n9 & 2) != 0) {
                string3 = configuration.scanFrontSideTitle;
            }
            if ((n9 & 4) != 0) {
                string4 = configuration.startScanningTitle;
            }
            if ((n9 & 8) != 0) {
                string5 = configuration.scannedEverythingTitle;
            }
            if ((n9 & 0x10) != 0) {
                string6 = configuration.confidenceValue;
            }
            if ((n9 & 0x20) != 0) {
                string7 = configuration.fieldsCountText;
            }
            if ((n9 & 0x40) != 0) {
                string8 = configuration.imageTitle;
            }
            if ((n9 & 0x80) != 0) {
                string9 = configuration.noDataTitle;
            }
            if ((n9 & 0x100) != 0) {
                n = configuration.primaryColor;
            }
            if ((n9 & 0x200) != 0) {
                n2 = configuration.fieldsCountTextColor;
            }
            if ((n9 & 0x400) != 0) {
                n3 = configuration.fieldConfidenceHighColor;
            }
            if ((n9 & 0x800) != 0) {
                n4 = configuration.fieldConfidenceModerateColor;
            }
            if ((n9 & 0x1000) != 0) {
                n5 = configuration.fieldConfidenceLowColor;
            }
            if ((n9 & 0x2000) != 0) {
                n6 = configuration.fieldConfidenceTextColor;
            }
            if ((n9 & 0x4000) != 0) {
                n7 = configuration.tipTextColor;
            }
            if ((n9 & 0x8000) != 0) {
                n8 = configuration.tipBackgroundColor;
            }
            if ((n9 & 0x10000) != 0) {
                map = configuration.customTranslationMap;
            }
            return configuration.copy(string2, string3, string4, string5, string6, string7, string8, string9, n, n2, n3, n4, n5, n6, n7, n8, map);
        }

        @NotNull
        public String toString() {
            return "Configuration(scanBackSideTitle=" + this.scanBackSideTitle + ", scanFrontSideTitle=" + this.scanFrontSideTitle + ", startScanningTitle=" + this.startScanningTitle + ", scannedEverythingTitle=" + this.scannedEverythingTitle + ", confidenceValue=" + this.confidenceValue + ", fieldsCountText=" + this.fieldsCountText + ", imageTitle=" + this.imageTitle + ", noDataTitle=" + this.noDataTitle + ", primaryColor=" + this.primaryColor + ", fieldsCountTextColor=" + this.fieldsCountTextColor + ", fieldConfidenceHighColor=" + this.fieldConfidenceHighColor + ", fieldConfidenceModerateColor=" + this.fieldConfidenceModerateColor + ", fieldConfidenceLowColor=" + this.fieldConfidenceLowColor + ", fieldConfidenceTextColor=" + this.fieldConfidenceTextColor + ", tipTextColor=" + this.tipTextColor + ", tipBackgroundColor=" + this.tipBackgroundColor + ", customTranslationMap=" + this.customTranslationMap + ")";
        }

        public int hashCode() {
            String string2 = this.scanBackSideTitle;
            String string3 = this.scanFrontSideTitle;
            String string4 = this.startScanningTitle;
            String string5 = this.scannedEverythingTitle;
            String string6 = this.confidenceValue;
            String string7 = this.fieldsCountText;
            String string8 = this.imageTitle;
            String string9 = this.noDataTitle;
            Map<IdScanResult.Field.Type, String> map = this.customTranslationMap;
            return ((((((((((((((((string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0)) * 31 + (string8 != null ? string8.hashCode() : 0)) * 31 + (string9 != null ? string9.hashCode() : 0)) * 31 + Integer.hashCode(this.primaryColor)) * 31 + Integer.hashCode(this.fieldsCountTextColor)) * 31 + Integer.hashCode(this.fieldConfidenceHighColor)) * 31 + Integer.hashCode(this.fieldConfidenceModerateColor)) * 31 + Integer.hashCode(this.fieldConfidenceLowColor)) * 31 + Integer.hashCode(this.fieldConfidenceTextColor)) * 31 + Integer.hashCode(this.tipTextColor)) * 31 + Integer.hashCode(this.tipBackgroundColor)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    Configuration configuration = (Configuration)object;
                    if (!Intrinsics.areEqual((Object)this.scanBackSideTitle, (Object)configuration.scanBackSideTitle) || !Intrinsics.areEqual((Object)this.scanFrontSideTitle, (Object)configuration.scanFrontSideTitle) || !Intrinsics.areEqual((Object)this.startScanningTitle, (Object)configuration.startScanningTitle) || !Intrinsics.areEqual((Object)this.scannedEverythingTitle, (Object)configuration.scannedEverythingTitle) || !Intrinsics.areEqual((Object)this.confidenceValue, (Object)configuration.confidenceValue) || !Intrinsics.areEqual((Object)this.fieldsCountText, (Object)configuration.fieldsCountText) || !Intrinsics.areEqual((Object)this.imageTitle, (Object)configuration.imageTitle) || !Intrinsics.areEqual((Object)this.noDataTitle, (Object)configuration.noDataTitle) || this.primaryColor != configuration.primaryColor || this.fieldsCountTextColor != configuration.fieldsCountTextColor || this.fieldConfidenceHighColor != configuration.fieldConfidenceHighColor || this.fieldConfidenceModerateColor != configuration.fieldConfidenceModerateColor || this.fieldConfidenceLowColor != configuration.fieldConfidenceLowColor || this.fieldConfidenceTextColor != configuration.fieldConfidenceTextColor || this.tipTextColor != configuration.tipTextColor || this.tipBackgroundColor != configuration.tipBackgroundColor || !Intrinsics.areEqual(this.customTranslationMap, configuration.customTranslationMap)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListView$Configuration$Companion;", "", "()V", "getColor", "", "context", "Landroid/content/Context;", "colorAttr", "prepareDefault", "Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListView$Configuration;", "rtu-ui-idcard_release"})
        public static final class Companion {
            @NotNull
            public final Configuration prepareDefault(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                String string2 = context.getString(R.string.id_card_scan_back_side_title);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026ard_scan_back_side_title)");
                String string3 = context.getString(R.string.id_card_scan_front_side_title);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026rd_scan_front_side_title)");
                String string4 = context.getString(R.string.id_card_start_scanning_title);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.stri\u2026ard_start_scanning_title)");
                String string5 = context.getString(R.string.id_card_scanned_everything);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.getString(R.stri\u2026_card_scanned_everything)");
                String string6 = context.getString(R.string.id_card_confidence_value);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.getString(R.stri\u2026id_card_confidence_value)");
                String string7 = context.getString(R.string.id_card_fields_count);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"context.getString(R.string.id_card_fields_count)");
                String string8 = context.getString(R.string.id_card_image_title);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"context.getString(R.string.id_card_image_title)");
                String string9 = context.getString(R.string.id_card_no_data_title);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"context.getString(R.string.id_card_no_data_title)");
                return new Configuration(string2, string3, string4, string5, string6, string7, string8, string9, this.getColor(context, R.attr.details_color_primary), this.getColor(context, R.attr.id_card_fields_count_text_color), this.getColor(context, R.attr.id_card_field_confidence_high_color), this.getColor(context, R.attr.id_card_field_confidence_moderate_color), this.getColor(context, R.attr.id_card_field_confidence_low_color), this.getColor(context, R.attr.id_card_field_confidence_text_color), this.getColor(context, R.attr.id_card_field_tip_text_color), this.getColor(context, R.attr.id_card_field_tip_background_color), MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)IdScanResult.Field.Type.Address, (Object)context.getString(R.string.id_card_field_type_address)), TuplesKt.to((Object)IdScanResult.Field.Type.BirthDate, (Object)context.getString(R.string.id_card_field_type_birth_date)), TuplesKt.to((Object)IdScanResult.Field.Type.Birthplace, (Object)context.getString(R.string.id_card_field_type_birthplace)), TuplesKt.to((Object)IdScanResult.Field.Type.EyeColor, (Object)context.getString(R.string.id_card_field_type_eye_color)), TuplesKt.to((Object)IdScanResult.Field.Type.ExpiryDate, (Object)context.getString(R.string.id_card_field_type_expiry_date)), TuplesKt.to((Object)IdScanResult.Field.Type.MaidenName, (Object)context.getString(R.string.id_card_field_type_maiden_name)), TuplesKt.to((Object)IdScanResult.Field.Type.GivenNames, (Object)context.getString(R.string.id_card_field_type_given_names)), TuplesKt.to((Object)IdScanResult.Field.Type.Height, (Object)context.getString(R.string.id_card_field_type_height)), TuplesKt.to((Object)IdScanResult.Field.Type.ID, (Object)context.getString(R.string.id_card_field_type_id)), TuplesKt.to((Object)IdScanResult.Field.Type.IssueDate, (Object)context.getString(R.string.id_card_field_type_issue_date)), TuplesKt.to((Object)IdScanResult.Field.Type.IssuingAuthority, (Object)context.getString(R.string.id_card_field_type_issuing_authority)), TuplesKt.to((Object)IdScanResult.Field.Type.MRZ, (Object)context.getString(R.string.id_card_field_type_mrz)), TuplesKt.to((Object)IdScanResult.Field.Type.Nationality, (Object)context.getString(R.string.id_card_field_type_nationality)), TuplesKt.to((Object)IdScanResult.Field.Type.PIN, (Object)context.getString(R.string.id_card_field_type_pin)), TuplesKt.to((Object)IdScanResult.Field.Type.Photo, (Object)context.getString(R.string.id_card_field_type_photo)), TuplesKt.to((Object)IdScanResult.Field.Type.Pseudonym, (Object)context.getString(R.string.id_card_field_type_pseudonym)), TuplesKt.to((Object)IdScanResult.Field.Type.Signature, (Object)context.getString(R.string.id_card_field_type_signature)), TuplesKt.to((Object)IdScanResult.Field.Type.Surname, (Object)context.getString(R.string.id_card_field_type_surname)), TuplesKt.to((Object)IdScanResult.Field.Type.Gender, (Object)context.getString(R.string.id_card_field_type_gender)), TuplesKt.to((Object)IdScanResult.Field.Type.PassportType, (Object)context.getString(R.string.id_card_field_type_passport_type)), TuplesKt.to((Object)IdScanResult.Field.Type.CountryCode, (Object)context.getString(R.string.id_card_field_type_country_code))}));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final int getColor(Context context, int colorAttr) {
                int n;
                void $this$getResourceId$iv;
                Context context2 = context;
                Context context3 = context;
                boolean $i$f$getResourceId = false;
                TypedArray values$iv = $this$getResourceId$iv.obtainStyledAttributes(new int[]{colorAttr});
                try {
                    n = values$iv.getResourceId(0, 0);
                }
                finally {
                    values$iv.recycle();
                }
                int n2 = n;
                return ContextCompat.getColor((Context)context3, (int)n2);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListView$Companion;", "", "()V", "DISABLED_BUTTON_ALPHA", "", "FADE_ANIMATION_DURATION_MS", "", "rtu-ui-idcard_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

