/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.nfc.interactor;

import android.graphics.Bitmap;
import android.net.Uri;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.scanbot.sdk.persistance.NfcPassportFileStorage;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/view/nfc/interactor/SaveNfcPassportImageUseCase;", "", "nfcPassportFileStorage", "Lio/scanbot/sdk/persistance/NfcPassportFileStorage;", "imageFileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "(Lio/scanbot/sdk/persistance/NfcPassportFileStorage;Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;)V", "compressImage", "Landroid/net/Uri;", "nfcPassportDir", "Ljava/io/File;", "bitmap", "Landroid/graphics/Bitmap;", "saveNfcPassportImage", "Lio/reactivex/Single;", "Companion", "rtu-ui-nfc_release"})
public final class SaveNfcPassportImageUseCase {
    private final NfcPassportFileStorage nfcPassportFileStorage;
    private final ImageFileIOProcessor imageFileIOProcessor;
    @NotNull
    public static final String PHOTO_FILE_NAME = "photo.jpg";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Single<Uri> saveNfcPassportImage(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Single single = Single.create((SingleOnSubscribe)((SingleOnSubscribe)new SingleOnSubscribe<Uri>(this, bitmap){
            final /* synthetic */ SaveNfcPassportImageUseCase this$0;
            final /* synthetic */ Bitmap $bitmap;

            public final void subscribe(@NotNull SingleEmitter<Uri> source) {
                Intrinsics.checkNotNullParameter(source, (String)"source");
                try {
                    File file = new File(SaveNfcPassportImageUseCase.access$getNfcPassportFileStorage$p(this.this$0).getNfcPassportImagesDirectory().getPath());
                    String string = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
                    File nfcPassportDir = FilesKt.resolve((File)file, (String)string);
                    if (nfcPassportDir.exists() || nfcPassportDir.mkdirs()) {
                        Uri photoUri = SaveNfcPassportImageUseCase.access$compressImage(this.this$0, nfcPassportDir, this.$bitmap);
                        source.onSuccess((Object)photoUri);
                    } else {
                        source.onError((Throwable)new IOException("Can't create dir " + nfcPassportDir.getAbsolutePath()));
                    }
                }
                catch (IOException e) {
                    LoggerProvider.getLogger().logException((Throwable)e);
                    source.onError((Throwable)e);
                }
            }
            {
                this.this$0 = saveNfcPassportImageUseCase;
                this.$bitmap = bitmap;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.create { source -\u2026)\n            }\n        }");
        return single;
    }

    private final Uri compressImage(File nfcPassportDir, Bitmap bitmap) {
        File file = FilesKt.resolve((File)nfcPassportDir, (String)PHOTO_FILE_NAME);
        this.imageFileIOProcessor.writeImage(bitmap, Bitmap.CompressFormat.JPEG, 100, file);
        File $this$toUri$iv = file;
        boolean $i$f$toUri = false;
        Uri uri = Uri.fromFile((File)$this$toUri$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
        return uri;
    }

    @Inject
    public SaveNfcPassportImageUseCase(@NotNull NfcPassportFileStorage nfcPassportFileStorage, @NotNull ImageFileIOProcessor imageFileIOProcessor) {
        Intrinsics.checkNotNullParameter((Object)nfcPassportFileStorage, (String)"nfcPassportFileStorage");
        Intrinsics.checkNotNullParameter((Object)imageFileIOProcessor, (String)"imageFileIOProcessor");
        this.nfcPassportFileStorage = nfcPassportFileStorage;
        this.imageFileIOProcessor = imageFileIOProcessor;
    }

    public static final /* synthetic */ NfcPassportFileStorage access$getNfcPassportFileStorage$p(SaveNfcPassportImageUseCase $this) {
        return $this.nfcPassportFileStorage;
    }

    public static final /* synthetic */ Uri access$compressImage(SaveNfcPassportImageUseCase $this, File nfcPassportDir, Bitmap bitmap) {
        return $this.compressImage(nfcPassportDir, bitmap);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ui/view/nfc/interactor/SaveNfcPassportImageUseCase$Companion;", "", "()V", "PHOTO_FILE_NAME", "", "rtu-ui-nfc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

