/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.nfc;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.scanbot.sdk.nfcscanner.passport.PassportNfcKey;
import io.scanbot.sdk.ui.nfc.R;
import io.scanbot.sdk.ui.view.nfc.INfcPassportView;
import io.scanbot.sdk.ui.view.nfc.NfcPassportView;
import io.scanbot.sdk.ui.view.nfc.NfcPassportView$WhenMappings;
import io.scanbot.sdk.ui.view.nfc.interactor.NfcState;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001(B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u0015H\u0003J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0011H\u0016JD\u0010\u001f\u001a\u00020\u00152\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020!2\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020!2\b\b\u0002\u0010&\u001a\u00020!2\b\b\u0003\u0010'\u001a\u00020!H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/scanbot/sdk/ui/view/nfc/NfcPassportView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/nfc/INfcPassportView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "configuration", "Lio/scanbot/sdk/ui/view/nfc/NfcPassportView$Configuration;", "getConfiguration", "()Lio/scanbot/sdk/ui/view/nfc/NfcPassportView$Configuration;", "inputDateFormat", "Ljava/text/SimpleDateFormat;", "listener", "Lio/scanbot/sdk/ui/view/nfc/INfcPassportView$Listener;", "state", "Lio/scanbot/sdk/ui/view/nfc/INfcPassportView$State;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "onDetachedFromWindow", "", "processNfcReadingStatus", "nfcState", "Lio/scanbot/sdk/ui/view/nfc/interactor/NfcState;", "nfcScanStep", "Lio/scanbot/sdk/ui/view/nfc/INfcPassportView$NfcScanStep;", "setListener", "subscribeViews", "updateState", "newState", "updateStepState", "progressVisibility", "", "retryVisibility", "title", "", "scanVisibility", "passportInfoVisibility", "imageResource", "Configuration", "rtu-ui-nfc_release"})
public final class NfcPassportView
extends FrameLayout
implements INfcPassportView {
    private final SimpleDateFormat inputDateFormat;
    private INfcPassportView.State state;
    private INfcPassportView.Listener listener;
    private final CompositeDisposable subscriptions;
    @NotNull
    private final Configuration configuration;
    private HashMap _$_findViewCache;

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setListener(@NotNull INfcPassportView.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listener = listener;
    }

    public void updateState(@NotNull INfcPassportView.State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state = newState;
        this.subscribeViews();
    }

    @SuppressLint(value={"SetTextI18n"})
    private final void subscribeViews() {
        this.subscriptions.add(Observable.combineLatest((ObservableSource)((ObservableSource)this.state.getStep().toObservable()), (ObservableSource)((ObservableSource)this.state.getNfcState().toObservable()), (BiFunction)subscribeViews.1.INSTANCE).subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Pair<? extends INfcPassportView.NfcScanStep, ? extends NfcState>>(this){
            final /* synthetic */ NfcPassportView this$0;

            public final void accept(Pair<? extends INfcPassportView.NfcScanStep, ? extends NfcState> pair) {
                NfcPassportView.access$processNfcReadingStatus(this.this$0, (NfcState)((Object)pair.getSecond()), (INfcPassportView.NfcScanStep)((Object)pair.getFirst()));
            }
            {
                this.this$0 = nfcPassportView;
            }
        }));
        this.subscriptions.add(this.state.getNfcKey().subscribeOn(AndroidSchedulers.mainThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<PassportNfcKey>(this){
            final /* synthetic */ NfcPassportView this$0;

            public final void accept(PassportNfcKey key) {
                ((TextView)this.this$0._$_findCachedViewById(R.id.mrz_nfc_passport_number)).setTextColor(this.this$0.getConfiguration().getToolbarButtonColor());
                ((TextView)this.this$0._$_findCachedViewById(R.id.mrz_nfc_passport_dates)).setTextColor(this.this$0.getConfiguration().getToolbarButtonColor());
                TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.mrz_nfc_passport_number);
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mrz_nfc_passport_number");
                textView.setText((CharSequence)key.getDocumentCode());
                TextView textView2 = (TextView)this.this$0._$_findCachedViewById(R.id.mrz_nfc_passport_dates);
                Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"mrz_nfc_passport_dates");
                textView2.setText((CharSequence)(NfcPassportView.access$getInputDateFormat$p(this.this$0).format(key.getBirthDate()) + "  \u2022  " + NfcPassportView.access$getInputDateFormat$p(this.this$0).format(key.getExpiryDate())));
            }
            {
                this.this$0 = nfcPassportView;
            }
        }));
    }

    private final void processNfcReadingStatus(NfcState nfcState, INfcPassportView.NfcScanStep nfcScanStep) {
        block0 : switch (NfcPassportView$WhenMappings.$EnumSwitchMapping$1[nfcState.ordinal()]) {
            case 1: 
            case 2: {
                switch (NfcPassportView$WhenMappings.$EnumSwitchMapping$0[nfcScanStep.ordinal()]) {
                    case 1: {
                        NfcPassportView.updateStepState$default(this, 0, 0, null, 8, 0, 0, 55, null);
                        break block0;
                    }
                    case 2: {
                        NfcPassportView.updateStepState$default(this, 0, 0, this.configuration.getDownloadDataTitle(), 0, 0, 0, 43, null);
                        break block0;
                    }
                    case 3: {
                        NfcPassportView.updateStepState$default(this, 0, 0, this.configuration.getDownloadingDataTitle(), 0, 0, 0, 42, null);
                        break block0;
                    }
                    case 4: {
                        int n = 0;
                        String string = this.configuration.getDownloadErrorTitle();
                        int n2 = 0;
                        int n3 = R.drawable.nfc_scanning_retry;
                        NfcPassportView.updateStepState$default(this, 0, 0, string, n2, n, n3, 11, null);
                        break block0;
                    }
                    case 5: {
                        int n = 0;
                        String string = this.configuration.getAuthErrorTitle();
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = R.drawable.nfc_scanning_error;
                        NfcPassportView.updateStepState$default(this, 0, n5, string, n4, n, n6, 9, null);
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                String string = this.configuration.getNoChipErrorTitle();
                int n = 0;
                int n7 = 0;
                int n8 = R.drawable.nfc_scanning_no_chip;
                NfcPassportView.updateStepState$default(this, 0, 0, string, n7, n, n8, 27, null);
                break;
            }
            case 4: {
                String string = this.configuration.getChipDisabledErrorTitle();
                int n = 0;
                int n9 = 0;
                int n10 = R.drawable.nfc_scanning_enable;
                NfcPassportView.updateStepState$default(this, 0, 0, string, n9, n, n10, 25, null);
                break;
            }
        }
    }

    private final void updateStepState(int progressVisibility, int retryVisibility, String title, int scanVisibility, int passportInfoVisibility, @DrawableRes int imageResource) {
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.mrz_nfc_progressbar);
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"mrz_nfc_progressbar");
        progressBar.setVisibility(progressVisibility);
        Button button = (Button)this._$_findCachedViewById(R.id.mrz_nfc_retry_button);
        Intrinsics.checkNotNullExpressionValue((Object)button, (String)"mrz_nfc_retry_button");
        button.setVisibility(retryVisibility);
        TextView textView = (TextView)this._$_findCachedViewById(R.id.mrz_nfc_passport_title);
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mrz_nfc_passport_title");
        textView.setText((CharSequence)title);
        LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.mrz_nfc_scan_tag);
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"mrz_nfc_scan_tag");
        linearLayout.setVisibility(scanVisibility);
        ((Button)this._$_findCachedViewById(R.id.mrz_nfc_retry_button)).setTextColor(this.configuration.getToolbarButtonColor());
        Button button2 = (Button)this._$_findCachedViewById(R.id.mrz_nfc_retry_button);
        Intrinsics.checkNotNullExpressionValue((Object)button2, (String)"mrz_nfc_retry_button");
        button2.setText((CharSequence)this.configuration.getRetryButtonTitle());
        Button button3 = (Button)this._$_findCachedViewById(R.id.mrz_nfc_retry_button);
        Intrinsics.checkNotNullExpressionValue((Object)button3, (String)"mrz_nfc_retry_button");
        button3.setAllCaps(this.configuration.isButtonsAllCaps());
        Toolbar toolbar = (Toolbar)this._$_findCachedViewById(R.id.mrz_nfc_toolbar);
        Intrinsics.checkNotNullExpressionValue((Object)toolbar, (String)"mrz_nfc_toolbar");
        toolbar.setBackgroundTintList(ColorStateList.valueOf((int)this.configuration.getToolbarColor()));
        ((Toolbar)this._$_findCachedViewById(R.id.mrz_nfc_toolbar)).setTitleTextColor(this.configuration.getToolbarButtonColor());
        ProgressBar progressBar2 = (ProgressBar)this._$_findCachedViewById(R.id.mrz_nfc_progressbar);
        Intrinsics.checkNotNullExpressionValue((Object)progressBar2, (String)"mrz_nfc_progressbar");
        progressBar2.setIndeterminateTintList(ColorStateList.valueOf((int)this.configuration.getProgressBarColor()));
        Toolbar toolbar2 = (Toolbar)this._$_findCachedViewById(R.id.mrz_nfc_toolbar);
        Intrinsics.checkNotNullExpressionValue((Object)toolbar2, (String)"mrz_nfc_toolbar");
        toolbar2.setTitle((CharSequence)this.configuration.getScanPassportTitle());
        ((TextView)this._$_findCachedViewById(R.id.mrz_nfc_passport_title)).setTextColor(this.configuration.getToolbarButtonColor());
        TextView textView2 = (TextView)this._$_findCachedViewById(R.id.mrz_nfc_passport_number);
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"mrz_nfc_passport_number");
        textView2.setVisibility(passportInfoVisibility);
        TextView textView3 = (TextView)this._$_findCachedViewById(R.id.mrz_nfc_passport_dates);
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"mrz_nfc_passport_dates");
        textView3.setVisibility(passportInfoVisibility);
        ((ImageView)this._$_findCachedViewById(R.id.mrz_nfc_image)).setImageResource(imageResource);
        ((LinearLayout)this._$_findCachedViewById(R.id.mrz_nfc_scan_tag)).setBackgroundColor(this.configuration.getToolbarColor());
    }

    static /* synthetic */ void updateStepState$default(NfcPassportView nfcPassportView, int n, int n2, String string, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = 4;
        }
        if ((n6 & 2) != 0) {
            n2 = 8;
        }
        if ((n6 & 4) != 0) {
            string = "";
        }
        if ((n6 & 8) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n4 = 4;
        }
        if ((n6 & 0x20) != 0) {
            n5 = R.drawable.nfc_scanning_general;
        }
        nfcPassportView.updateStepState(n, n2, string, n3, n4, n5);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.subscriptions.clear();
    }

    public NfcPassportView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.inputDateFormat = new SimpleDateFormat("dd.MM.yy", Locale.GERMAN);
        this.state = INfcPassportView.State.Companion.getDEFAULT();
        this.listener = INfcPassportView.Listener.Companion.getNULL();
        this.subscriptions = new CompositeDisposable();
        this.configuration = Configuration.Companion.prepareDefault(context);
        LayoutInflater.from((Context)context).inflate(R.layout.scanbot_sdk_nfc_camera_view, (ViewGroup)this, true);
        Toolbar toolbar = (Toolbar)this._$_findCachedViewById(R.id.mrz_nfc_toolbar);
        Intrinsics.checkNotNullExpressionValue((Object)toolbar, (String)"mrz_nfc_toolbar");
        toolbar.setNavigationIcon(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.ic_baseline_arrow_back_24, null));
        ((Toolbar)this._$_findCachedViewById(R.id.mrz_nfc_toolbar)).setNavigationOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.backPressed();
            }
        });
        ((Button)this._$_findCachedViewById(R.id.mrz_nfc_retry_button)).setOnClickListener(new View.OnClickListener(){

            public final void onClick(View it) {
                listener.retryClicked();
            }
        });
    }

    public static final /* synthetic */ void access$processNfcReadingStatus(NfcPassportView $this, NfcState nfcState, INfcPassportView.NfcScanStep nfcScanStep) {
        $this.processNfcReadingStatus(nfcState, nfcScanStep);
    }

    public static final /* synthetic */ SimpleDateFormat access$getInputDateFormat$p(NfcPassportView $this) {
        return $this.inputDateFormat;
    }

    public static final /* synthetic */ void access$setListener$p(NfcPassportView $this, INfcPassportView.Listener listener) {
        $this.listener = listener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b1\b\u0086\b\u0018\u0000 @2\u00020\u0001:\u0001@Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\f\u0012\b\b\u0001\u0010\r\u001a\u00020\f\u0012\b\b\u0001\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\fH\u00c6\u0003J\t\u00101\u001a\u00020\fH\u00c6\u0003J\t\u00102\u001a\u00020\u0010H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0003H\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\t\u00109\u001a\u00020\u0003H\u00c6\u0003J\t\u0010:\u001a\u00020\fH\u00c6\u0003J\u0081\u0001\u0010;\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0003\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\f2\b\b\u0003\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001J\u0013\u0010<\u001a\u00020\u00102\b\u0010=\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010>\u001a\u00020\fH\u00d6\u0001J\t\u0010?\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010\u0015R\u001a\u0010\u000e\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0013\"\u0004\b(\u0010\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0013\"\u0004\b*\u0010\u0015R\u001a\u0010\r\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010$\"\u0004\b,\u0010&R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010$\"\u0004\b.\u0010&\u00a8\u0006A"}, d2={"Lio/scanbot/sdk/ui/view/nfc/NfcPassportView$Configuration;", "", "scanPassportTitle", "", "downloadDataTitle", "downloadingDataTitle", "downloadErrorTitle", "authErrorTitle", "noChipErrorTitle", "chipDisabledErrorTitle", "retryButtonTitle", "toolbarColor", "", "toolbarButtonColor", "progressBarColor", "isButtonsAllCaps", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;IIIZ)V", "getAuthErrorTitle", "()Ljava/lang/String;", "setAuthErrorTitle", "(Ljava/lang/String;)V", "getChipDisabledErrorTitle", "setChipDisabledErrorTitle", "getDownloadDataTitle", "setDownloadDataTitle", "getDownloadErrorTitle", "setDownloadErrorTitle", "getDownloadingDataTitle", "setDownloadingDataTitle", "()Z", "setButtonsAllCaps", "(Z)V", "getNoChipErrorTitle", "setNoChipErrorTitle", "getProgressBarColor", "()I", "setProgressBarColor", "(I)V", "getRetryButtonTitle", "setRetryButtonTitle", "getScanPassportTitle", "setScanPassportTitle", "getToolbarButtonColor", "setToolbarButtonColor", "getToolbarColor", "setToolbarColor", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "Companion", "rtu-ui-nfc_release"})
    public static final class Configuration {
        @NotNull
        private String scanPassportTitle;
        @NotNull
        private String downloadDataTitle;
        @NotNull
        private String downloadingDataTitle;
        @NotNull
        private String downloadErrorTitle;
        @NotNull
        private String authErrorTitle;
        @NotNull
        private String noChipErrorTitle;
        @NotNull
        private String chipDisabledErrorTitle;
        @NotNull
        private String retryButtonTitle;
        private int toolbarColor;
        private int toolbarButtonColor;
        private int progressBarColor;
        private boolean isButtonsAllCaps;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getScanPassportTitle() {
            return this.scanPassportTitle;
        }

        public final void setScanPassportTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.scanPassportTitle = string;
        }

        @NotNull
        public final String getDownloadDataTitle() {
            return this.downloadDataTitle;
        }

        public final void setDownloadDataTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.downloadDataTitle = string;
        }

        @NotNull
        public final String getDownloadingDataTitle() {
            return this.downloadingDataTitle;
        }

        public final void setDownloadingDataTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.downloadingDataTitle = string;
        }

        @NotNull
        public final String getDownloadErrorTitle() {
            return this.downloadErrorTitle;
        }

        public final void setDownloadErrorTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.downloadErrorTitle = string;
        }

        @NotNull
        public final String getAuthErrorTitle() {
            return this.authErrorTitle;
        }

        public final void setAuthErrorTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.authErrorTitle = string;
        }

        @NotNull
        public final String getNoChipErrorTitle() {
            return this.noChipErrorTitle;
        }

        public final void setNoChipErrorTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.noChipErrorTitle = string;
        }

        @NotNull
        public final String getChipDisabledErrorTitle() {
            return this.chipDisabledErrorTitle;
        }

        public final void setChipDisabledErrorTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.chipDisabledErrorTitle = string;
        }

        @NotNull
        public final String getRetryButtonTitle() {
            return this.retryButtonTitle;
        }

        public final void setRetryButtonTitle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.retryButtonTitle = string;
        }

        public final int getToolbarColor() {
            return this.toolbarColor;
        }

        public final void setToolbarColor(int n) {
            this.toolbarColor = n;
        }

        public final int getToolbarButtonColor() {
            return this.toolbarButtonColor;
        }

        public final void setToolbarButtonColor(int n) {
            this.toolbarButtonColor = n;
        }

        public final int getProgressBarColor() {
            return this.progressBarColor;
        }

        public final void setProgressBarColor(int n) {
            this.progressBarColor = n;
        }

        public final boolean isButtonsAllCaps() {
            return this.isButtonsAllCaps;
        }

        public final void setButtonsAllCaps(boolean bl) {
            this.isButtonsAllCaps = bl;
        }

        public Configuration(@NotNull String scanPassportTitle, @NotNull String downloadDataTitle, @NotNull String downloadingDataTitle, @NotNull String downloadErrorTitle, @NotNull String authErrorTitle, @NotNull String noChipErrorTitle, @NotNull String chipDisabledErrorTitle, @NotNull String retryButtonTitle, @ColorInt int toolbarColor, @ColorInt int toolbarButtonColor, @ColorInt int progressBarColor, boolean isButtonsAllCaps) {
            Intrinsics.checkNotNullParameter((Object)scanPassportTitle, (String)"scanPassportTitle");
            Intrinsics.checkNotNullParameter((Object)downloadDataTitle, (String)"downloadDataTitle");
            Intrinsics.checkNotNullParameter((Object)downloadingDataTitle, (String)"downloadingDataTitle");
            Intrinsics.checkNotNullParameter((Object)downloadErrorTitle, (String)"downloadErrorTitle");
            Intrinsics.checkNotNullParameter((Object)authErrorTitle, (String)"authErrorTitle");
            Intrinsics.checkNotNullParameter((Object)noChipErrorTitle, (String)"noChipErrorTitle");
            Intrinsics.checkNotNullParameter((Object)chipDisabledErrorTitle, (String)"chipDisabledErrorTitle");
            Intrinsics.checkNotNullParameter((Object)retryButtonTitle, (String)"retryButtonTitle");
            this.scanPassportTitle = scanPassportTitle;
            this.downloadDataTitle = downloadDataTitle;
            this.downloadingDataTitle = downloadingDataTitle;
            this.downloadErrorTitle = downloadErrorTitle;
            this.authErrorTitle = authErrorTitle;
            this.noChipErrorTitle = noChipErrorTitle;
            this.chipDisabledErrorTitle = chipDisabledErrorTitle;
            this.retryButtonTitle = retryButtonTitle;
            this.toolbarColor = toolbarColor;
            this.toolbarButtonColor = toolbarButtonColor;
            this.progressBarColor = progressBarColor;
            this.isButtonsAllCaps = isButtonsAllCaps;
        }

        @NotNull
        public final String component1() {
            return this.scanPassportTitle;
        }

        @NotNull
        public final String component2() {
            return this.downloadDataTitle;
        }

        @NotNull
        public final String component3() {
            return this.downloadingDataTitle;
        }

        @NotNull
        public final String component4() {
            return this.downloadErrorTitle;
        }

        @NotNull
        public final String component5() {
            return this.authErrorTitle;
        }

        @NotNull
        public final String component6() {
            return this.noChipErrorTitle;
        }

        @NotNull
        public final String component7() {
            return this.chipDisabledErrorTitle;
        }

        @NotNull
        public final String component8() {
            return this.retryButtonTitle;
        }

        public final int component9() {
            return this.toolbarColor;
        }

        public final int component10() {
            return this.toolbarButtonColor;
        }

        public final int component11() {
            return this.progressBarColor;
        }

        public final boolean component12() {
            return this.isButtonsAllCaps;
        }

        @NotNull
        public final Configuration copy(@NotNull String scanPassportTitle, @NotNull String downloadDataTitle, @NotNull String downloadingDataTitle, @NotNull String downloadErrorTitle, @NotNull String authErrorTitle, @NotNull String noChipErrorTitle, @NotNull String chipDisabledErrorTitle, @NotNull String retryButtonTitle, @ColorInt int toolbarColor, @ColorInt int toolbarButtonColor, @ColorInt int progressBarColor, boolean isButtonsAllCaps) {
            Intrinsics.checkNotNullParameter((Object)scanPassportTitle, (String)"scanPassportTitle");
            Intrinsics.checkNotNullParameter((Object)downloadDataTitle, (String)"downloadDataTitle");
            Intrinsics.checkNotNullParameter((Object)downloadingDataTitle, (String)"downloadingDataTitle");
            Intrinsics.checkNotNullParameter((Object)downloadErrorTitle, (String)"downloadErrorTitle");
            Intrinsics.checkNotNullParameter((Object)authErrorTitle, (String)"authErrorTitle");
            Intrinsics.checkNotNullParameter((Object)noChipErrorTitle, (String)"noChipErrorTitle");
            Intrinsics.checkNotNullParameter((Object)chipDisabledErrorTitle, (String)"chipDisabledErrorTitle");
            Intrinsics.checkNotNullParameter((Object)retryButtonTitle, (String)"retryButtonTitle");
            return new Configuration(scanPassportTitle, downloadDataTitle, downloadingDataTitle, downloadErrorTitle, authErrorTitle, noChipErrorTitle, chipDisabledErrorTitle, retryButtonTitle, toolbarColor, toolbarButtonColor, progressBarColor, isButtonsAllCaps);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, int n2, int n3, boolean bl, int n4, Object object) {
            if ((n4 & 1) != 0) {
                string = configuration.scanPassportTitle;
            }
            if ((n4 & 2) != 0) {
                string2 = configuration.downloadDataTitle;
            }
            if ((n4 & 4) != 0) {
                string3 = configuration.downloadingDataTitle;
            }
            if ((n4 & 8) != 0) {
                string4 = configuration.downloadErrorTitle;
            }
            if ((n4 & 0x10) != 0) {
                string5 = configuration.authErrorTitle;
            }
            if ((n4 & 0x20) != 0) {
                string6 = configuration.noChipErrorTitle;
            }
            if ((n4 & 0x40) != 0) {
                string7 = configuration.chipDisabledErrorTitle;
            }
            if ((n4 & 0x80) != 0) {
                string8 = configuration.retryButtonTitle;
            }
            if ((n4 & 0x100) != 0) {
                n = configuration.toolbarColor;
            }
            if ((n4 & 0x200) != 0) {
                n2 = configuration.toolbarButtonColor;
            }
            if ((n4 & 0x400) != 0) {
                n3 = configuration.progressBarColor;
            }
            if ((n4 & 0x800) != 0) {
                bl = configuration.isButtonsAllCaps;
            }
            return configuration.copy(string, string2, string3, string4, string5, string6, string7, string8, n, n2, n3, bl);
        }

        @NotNull
        public String toString() {
            return "Configuration(scanPassportTitle=" + this.scanPassportTitle + ", downloadDataTitle=" + this.downloadDataTitle + ", downloadingDataTitle=" + this.downloadingDataTitle + ", downloadErrorTitle=" + this.downloadErrorTitle + ", authErrorTitle=" + this.authErrorTitle + ", noChipErrorTitle=" + this.noChipErrorTitle + ", chipDisabledErrorTitle=" + this.chipDisabledErrorTitle + ", retryButtonTitle=" + this.retryButtonTitle + ", toolbarColor=" + this.toolbarColor + ", toolbarButtonColor=" + this.toolbarButtonColor + ", progressBarColor=" + this.progressBarColor + ", isButtonsAllCaps=" + this.isButtonsAllCaps + ")";
        }

        public int hashCode() {
            String string = this.scanPassportTitle;
            String string2 = this.downloadDataTitle;
            String string3 = this.downloadingDataTitle;
            String string4 = this.downloadErrorTitle;
            String string5 = this.authErrorTitle;
            String string6 = this.noChipErrorTitle;
            String string7 = this.chipDisabledErrorTitle;
            String string8 = this.retryButtonTitle;
            int n = (((((((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0)) * 31 + (string7 != null ? string7.hashCode() : 0)) * 31 + (string8 != null ? string8.hashCode() : 0)) * 31 + Integer.hashCode(this.toolbarColor)) * 31 + Integer.hashCode(this.toolbarButtonColor)) * 31 + Integer.hashCode(this.progressBarColor)) * 31;
            int n2 = this.isButtonsAllCaps ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    Configuration configuration = (Configuration)object;
                    if (!Intrinsics.areEqual((Object)this.scanPassportTitle, (Object)configuration.scanPassportTitle) || !Intrinsics.areEqual((Object)this.downloadDataTitle, (Object)configuration.downloadDataTitle) || !Intrinsics.areEqual((Object)this.downloadingDataTitle, (Object)configuration.downloadingDataTitle) || !Intrinsics.areEqual((Object)this.downloadErrorTitle, (Object)configuration.downloadErrorTitle) || !Intrinsics.areEqual((Object)this.authErrorTitle, (Object)configuration.authErrorTitle) || !Intrinsics.areEqual((Object)this.noChipErrorTitle, (Object)configuration.noChipErrorTitle) || !Intrinsics.areEqual((Object)this.chipDisabledErrorTitle, (Object)configuration.chipDisabledErrorTitle) || !Intrinsics.areEqual((Object)this.retryButtonTitle, (Object)configuration.retryButtonTitle) || this.toolbarColor != configuration.toolbarColor || this.toolbarButtonColor != configuration.toolbarButtonColor || this.progressBarColor != configuration.progressBarColor || this.isButtonsAllCaps != configuration.isButtonsAllCaps) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/view/nfc/NfcPassportView$Configuration$Companion;", "", "()V", "getBoolean", "", "context", "Landroid/content/Context;", "booleanAttr", "", "getColor", "colorAttr", "getString", "", "strAttr", "prepareDefault", "Lio/scanbot/sdk/ui/view/nfc/NfcPassportView$Configuration;", "rtu-ui-nfc_release"})
        public static final class Companion {
            @NotNull
            public final Configuration prepareDefault(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                return new Configuration(this.getString(context, R.attr.scanPassportTitle), this.getString(context, R.attr.downloadDataTitle), this.getString(context, R.attr.downloadingDataTitle), this.getString(context, R.attr.downloadErrorTitle), this.getString(context, R.attr.authErrorTitle), this.getString(context, R.attr.noChipErrorTitle), this.getString(context, R.attr.chipDisabledErrorTitle), this.getString(context, R.attr.retryButtonTitle), this.getColor(context, R.attr.colorPrimary), this.getColor(context, R.attr.colorAccent), this.getColor(context, R.attr.progressBarColor), this.getBoolean(context, R.attr.nfc_passport_is_buttons_all_caps));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final int getColor(Context context, int colorAttr) {
                int n;
                void $this$getResourceId$iv;
                Context context2 = context;
                Context context3 = context;
                boolean $i$f$getResourceId = false;
                TypedArray values$iv = $this$getResourceId$iv.obtainStyledAttributes(new int[]{colorAttr});
                try {
                    n = values$iv.getResourceId(0, 0);
                }
                finally {
                    values$iv.recycle();
                }
                int n2 = n;
                return ContextCompat.getColor((Context)context3, (int)n2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final String getString(Context context, int strAttr) {
                int n;
                void $this$getResourceId$iv;
                Context context2 = context;
                Context context3 = context;
                boolean $i$f$getResourceId = false;
                TypedArray values$iv = $this$getResourceId$iv.obtainStyledAttributes(new int[]{strAttr});
                try {
                    n = values$iv.getResourceId(0, 0);
                }
                finally {
                    values$iv.recycle();
                }
                int n2 = n;
                String string = context3.getString(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(context.getResourceId(strAttr))");
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final boolean getBoolean(Context context, int booleanAttr) {
                int n;
                void $this$getResourceId$iv;
                Context context2 = context;
                Resources resources = context.getResources();
                boolean $i$f$getResourceId = false;
                TypedArray values$iv = $this$getResourceId$iv.obtainStyledAttributes(new int[]{booleanAttr});
                try {
                    n = values$iv.getResourceId(0, 0);
                }
                finally {
                    values$iv.recycle();
                }
                int n2 = n;
                return resources.getBoolean(n2);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

