
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import com.google.inject.AnnotationDatabase;
import roboguice.fragment.FragmentUtil;

public class AnnotationDatabaseImpl extends AnnotationDatabase {

    public void fillAnnotationClassesAndFieldsNames(HashMap<String, Map<String, Set<String>>> mapAnnotationToMapClassWithInjectionNameToFieldSet) {
    
        String annotationClassName = null;
        Map<String, Set<String>> mapClassWithInjectionNameToFieldSet = null;
        Set<String> fieldNameSet = null;


        annotationClassName = "com.google.inject.Inject";
        mapClassWithInjectionNameToFieldSet = mapAnnotationToMapClassWithInjectionNameToFieldSet.get(annotationClassName);
        if( mapClassWithInjectionNameToFieldSet == null ) {
            mapClassWithInjectionNameToFieldSet = new HashMap<String, Set<String>>();
            mapAnnotationToMapClassWithInjectionNameToFieldSet.put(annotationClassName, mapClassWithInjectionNameToFieldSet);
        }

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("documentStoreStrategy");
        fieldNameSet.add("pdfProcessor");
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.process.compose.SimpleComposer", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("resources");
        fieldNameSet.add("contourDetector");
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.process.compose.PageComposerFactoryImpl", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("documentStoreStrategy");
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.process.compose.JpegComposer", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("preferences");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.persistence.DocumentStoreStrategy", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.persistence.cleanup.BaseUnreferencedSourcesProvider", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("application");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.util.DownloadManagerProvider", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("documentStoreStrategy");
        fieldNameSet.add("unreferencedSourcesProvider");
        fieldNameSet.add("processingInfoProvider");
        fieldNameSet.add("pageStoreStrategy");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.persistence.cleanup.Cleaner", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("preferences");
        fieldNameSet.add("bitmapLruCache");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.persistence.PageFactory", fieldNameSet);

        fieldNameSet = new HashSet<String>();
        fieldNameSet.add("bitmapLruCache");
        mapClassWithInjectionNameToFieldSet.put("net.doo.snap.persistence.PictureProcessor", fieldNameSet);

    }
    
    public void fillAnnotationClassesAndMethods(HashMap<String, Map<String, Set<String>>> mapAnnotationToMapClassWithInjectionNameToMethodsSet) {
    }
    
    public void fillAnnotationClassesAndConstructors(HashMap<String, Map<String, Set<String>>> mapAnnotationToMapClassWithInjectionNameToConstructorsSet) {

        String annotationClassName = null;
        Map<String, Set<String>> mapClassWithInjectionNameToConstructorSet = null;
        Set<String> constructorSet = null;


        annotationClassName = "com.google.inject.Inject";
        mapClassWithInjectionNameToConstructorSet = mapAnnotationToMapClassWithInjectionNameToConstructorsSet.get(annotationClassName);
        if( mapClassWithInjectionNameToConstructorSet == null ) {
            mapClassWithInjectionNameToConstructorSet = new HashMap<String, Set<String>>();
            mapAnnotationToMapClassWithInjectionNameToConstructorsSet.put(annotationClassName, mapClassWithInjectionNameToConstructorSet);
        }

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.connectivity.RemoteStorage", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.DocumentLockProvider", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.compose.SimpleComposer", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context:android.content.SharedPreferences:net.doo.snap.util.device.DeviceUtils");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.compose.BaseComposerFactory", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context:net.doo.snap.persistence.PageStoreStrategy");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.persistence.DocumentStoreStrategy", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.Application");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.persistence.PageStoreStrategy", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.persistence.DocumentStoreStrategy:android.content.SharedPreferences");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.draft.CombinedDocumentDraftExtractor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.Application");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.persistence.BlobStoreStrategy", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider:net.doo.snap.persistence.PageStoreStrategy:net.doo.snap.persistence.DocumentStoreStrategy:net.doo.snap.process.ProcessingInfoProvider");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.persistence.cleanup.Cleaner", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.persistence.DocumentStoreStrategy:android.content.res.Resources:net.doo.snap.util.bitmap.BitmapLruCache:net.doo.snap.process.PageProcessor:net.doo.snap.process.compose.ComposerFactory:net.doo.snap.process.ProcessorMonitor:net.doo.snap.persistence.cleanup.Cleaner");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.DocumentProcessor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.process.draft.CombinedDocumentDraftExtractor:net.doo.snap.process.draft.MultipleDocumentsDraftExtractor");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.draft.CompositeDraftExtractor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:io.scanbot.sap.SapManager:net.doo.snap.persistence.DocumentStoreStrategy:android.content.res.Resources:net.doo.snap.util.bitmap.BitmapLruCache:net.doo.snap.process.PageProcessor:net.doo.snap.process.compose.ComposerFactory:net.doo.snap.process.ProcessorMonitor:net.doo.snap.persistence.cleanup.Cleaner");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.DocumentProcessorProvider", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.util.CameraConfiguration", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.SharedPreferences");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.draft.MultipleDocumentsDraftExtractor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.content.Context");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.util.device.DeviceUtils", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.Application");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.security.SapProvider", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.persistence.PageStoreStrategy:net.doo.snap.process.compose.PageComposerFactory:net.doo.snap.process.ProcessorMonitor");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.PageProcessor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.process.compose.JpegComposer", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.persistence.PageStoreStrategy");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.persistence.PageFactory", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.persistence.BlobStoreStrategy:net.doo.snap.connectivity.RemoteStorage:net.doo.snap.intelligence.DocumentClassifier");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.blob.BlobFactory", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.persistence.BlobStoreStrategy:android.app.DownloadManager:android.content.SharedPreferences:android.content.res.AssetManager:net.doo.snap.blob.BlobFactory");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.blob.BlobManager", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:net.doo.snap.persistence.PageFactory:net.doo.snap.persistence.PageStoreStrategy:android.content.res.Resources:android.content.SharedPreferences");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.persistence.PictureProcessor", constructorSet);

        constructorSet = new HashSet<String>();
        constructorSet.add("<init>:android.app.ActivityManager");
        mapClassWithInjectionNameToConstructorSet.put("net.doo.snap.util.bitmap.BitmapLruCache", constructorSet);

    }
    
    public void fillClassesContainingInjectionPointSet(HashSet<String> classesContainingInjectionPointsSet) {
        classesContainingInjectionPointsSet.add("net.doo.snap.process.DocumentLockProvider");
        classesContainingInjectionPointsSet.add("net.doo.snap.connectivity.RemoteStorage");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.compose.BaseComposerFactory");
        classesContainingInjectionPointsSet.add("net.doo.snap.persistence.DocumentStoreStrategy");
        classesContainingInjectionPointsSet.add("net.doo.snap.persistence.PageStoreStrategy");
        classesContainingInjectionPointsSet.add("net.doo.snap.persistence.cleanup.Cleaner");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.draft.CombinedDocumentDraftExtractor");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.DocumentProcessor");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.draft.MultipleDocumentsDraftExtractor");
        classesContainingInjectionPointsSet.add("net.doo.snap.util.device.DeviceUtils");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.PageProcessor");
        classesContainingInjectionPointsSet.add("net.doo.snap.persistence.PageFactory");
        classesContainingInjectionPointsSet.add("net.doo.snap.blob.BlobManager");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.compose.SimpleComposer");
        classesContainingInjectionPointsSet.add("net.doo.snap.persistence.BlobStoreStrategy");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.draft.CompositeDraftExtractor");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.DocumentProcessorProvider");
        classesContainingInjectionPointsSet.add("net.doo.snap.util.CameraConfiguration");
        classesContainingInjectionPointsSet.add("net.doo.snap.security.SapProvider");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.compose.PageComposerFactoryImpl");
        classesContainingInjectionPointsSet.add("net.doo.snap.process.compose.JpegComposer");
        classesContainingInjectionPointsSet.add("net.doo.snap.persistence.cleanup.BaseUnreferencedSourcesProvider");
        classesContainingInjectionPointsSet.add("net.doo.snap.util.DownloadManagerProvider");
        classesContainingInjectionPointsSet.add("net.doo.snap.persistence.PictureProcessor");
        classesContainingInjectionPointsSet.add("net.doo.snap.blob.BlobFactory");
        classesContainingInjectionPointsSet.add("net.doo.snap.util.bitmap.BitmapLruCache");
    }
    

    public void fillBindableClasses(HashSet<String> injectedClasses) {
        injectedClasses.add("net.doo.snap.connectivity.RemoteStorage");
        injectedClasses.add("net.doo.snap.persistence.PageStoreStrategy");
        injectedClasses.add("net.doo.snap.persistence.DocumentStoreStrategy");
        injectedClasses.add("android.app.ActivityManager");
        injectedClasses.add("net.doo.snap.intelligence.DocumentClassifier");
        injectedClasses.add("net.doo.snap.process.compose.ComposerFactory");
        injectedClasses.add("net.doo.snap.process.draft.CombinedDocumentDraftExtractor");
        injectedClasses.add("net.doo.snap.persistence.cleanup.Cleaner");
        injectedClasses.add("net.doo.snap.process.draft.MultipleDocumentsDraftExtractor");
        injectedClasses.add("net.doo.snap.lib.detector.ContourDetector");
        injectedClasses.add("net.doo.snap.util.device.DeviceUtils");
        injectedClasses.add("net.doo.snap.process.PageProcessor");
        injectedClasses.add("net.doo.snap.process.PDFProcessor");
        injectedClasses.add("net.doo.snap.persistence.PageFactory");
        injectedClasses.add("android.content.res.Resources");
        injectedClasses.add("net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider");
        injectedClasses.add("android.content.res.AssetManager");
        injectedClasses.add("net.doo.snap.persistence.BlobStoreStrategy");
        injectedClasses.add("android.app.Application");
        injectedClasses.add("android.app.DownloadManager");
        injectedClasses.add("net.doo.snap.process.ProcessingInfoProvider");
        injectedClasses.add("net.doo.snap.process.compose.PageComposerFactory");
        injectedClasses.add("android.content.Context");
        injectedClasses.add("android.content.SharedPreferences");
        injectedClasses.add("io.scanbot.sap.SapManager");
        injectedClasses.add("net.doo.snap.blob.BlobFactory");
        injectedClasses.add("net.doo.snap.process.ProcessorMonitor");
        injectedClasses.add("net.doo.snap.util.bitmap.BitmapLruCache");

        if(FragmentUtil.hasNative) {
            injectedClasses.add("android.app.FragmentManager");
        }

        if(FragmentUtil.hasSupport) {
            injectedClasses.add("android.support.v4.app.FragmentManager");
        }
    }

}
