/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.graphics.Rect;
import android.graphics.RectF;
import com.google.inject.Inject;
import crl.android.pdfwriter.PDFWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.PDFProcessor;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.pdf.PdfUtils;
import org.apache.commons.io.IOUtils;

public class SimpleComposer
implements Composer {
    @Inject
    private DocumentStoreStrategy documentStoreStrategy;
    @Inject
    private PageStoreStrategy pageStoreStrategy;
    @Inject
    private PDFProcessor pdfProcessor;

    @Inject
    public SimpleComposer() {
    }

    public SimpleComposer(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, PDFProcessor pDFProcessor) {
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.pdfProcessor = pDFProcessor;
    }

    @Override
    public void composeDocument(Document document, Page ... pageArray) throws IOException {
        if (document.getSize() > 0L) {
            throw new IOException("Document already exists");
        }
        PDFWriter pDFWriter = new PDFWriter();
        this.a(pDFWriter, pageArray);
        PDFWriter pDFWriter2 = pDFWriter;
        Document document2 = document;
        File file = this.documentStoreStrategy.getDocumentFile(document2.getId(), document2.getName());
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            pDFWriter2.write((OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
        this.pdfProcessor.processPDF(document, pageArray);
    }

    private void a(PDFWriter pDFWriter, Page[] pageArray) throws IOException {
        Page[] pageArray2 = pageArray;
        int n2 = pageArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4;
            Page page = pageArray2[i2];
            String string = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.COMBINED).getPath();
            Rect rect = BitmapUtils.getBitmapBounds(string);
            int n5 = page.getRotationType().getDegrees();
            if (n5 == 90 || n5 == 270) {
                n4 = rect.height();
                n3 = rect.width();
            } else {
                n4 = rect.width();
                n3 = rect.height();
            }
            RectF rectF = PdfUtils.fitToPhysicalBounds(new RectF(0.0f, 0.0f, (float)n4, (float)n3), PdfUtils.defaultPhysicalBounds());
            int n6 = (int)rectF.width();
            int n7 = (int)rectF.height();
            pDFWriter.newPage(n6, n7);
            pDFWriter.addJPGImageKeepRatio(n6, n7, -n5, string);
        }
        pDFWriter.setDocumentInfo("/Creator (Scanbot for Android)");
    }

    private void a(Document document, PDFWriter pDFWriter) throws IOException {
        File file = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            pDFWriter.write((OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
    }
}

