/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;

public class JpegComposer
implements Composer {
    @Inject
    private DocumentStoreStrategy documentStoreStrategy;
    @Inject
    private PageStoreStrategy pageStoreStrategy;
    private final Logger a = LoggerProvider.getLogger();

    @Inject
    public JpegComposer() {
    }

    @Override
    public void composeDocument(Document document, Page ... pageArray) throws IOException {
        if (pageArray.length != 1) {
            throw new IllegalArgumentException("Composer can only take 1 page");
        }
        Page page = pageArray[0];
        Document document2 = document;
        JpegComposer jpegComposer = this;
        File file = jpegComposer.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.COMBINED);
        File file2 = jpegComposer.documentStoreStrategy.getDocumentFile(document2.getId(), document2.getName());
        FileUtils.copyFile((File)file, (File)file2);
        int n2 = page.getRotationType().getDegrees();
        if (n2 != 0 && n2 != 360) {
            try {
                Bitmap bitmap = BitmapFactory.decodeFile((String)file2.getPath());
                int n3 = bitmap.getWidth();
                int n4 = bitmap.getHeight();
                Matrix matrix = new Matrix();
                matrix.setRotate((float)n2, (float)(n3 / 2), (float)(n4 / 2));
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n3, (int)n4, (Matrix)matrix, (boolean)true);
                bitmap.recycle();
                BitmapUtils.compress(bitmap2, Bitmap.CompressFormat.JPEG, 90, file2);
                bitmap2.recycle();
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                jpegComposer.a.logException(outOfMemoryError);
            }
        }
    }

    private void a(Document document, Page page) throws IOException {
        File file = this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.COMBINED);
        File file2 = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
        FileUtils.copyFile((File)file, (File)file2);
        int n2 = page.getRotationType().getDegrees();
        if (n2 != 0 && n2 != 360) {
            try {
                Bitmap bitmap = BitmapFactory.decodeFile((String)file2.getPath());
                int n3 = bitmap.getWidth();
                int n4 = bitmap.getHeight();
                Matrix matrix = new Matrix();
                matrix.setRotate((float)n2, (float)(n3 / 2), (float)(n4 / 2));
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n3, (int)n4, (Matrix)matrix, (boolean)true);
                bitmap.recycle();
                BitmapUtils.compress(bitmap2, Bitmap.CompressFormat.JPEG, 90, file2);
                bitmap2.recycle();
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.a.logException(outOfMemoryError);
            }
        }
    }
}

