/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.graphics.Bitmap;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.b;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;

public class PageFactory {
    private static final ExecutorService a = Executors.newSingleThreadExecutor();
    private final BitmapLruCache b;
    private final PageStoreStrategy c;
    private final Logger d = LoggerProvider.getLogger();

    @Inject
    public PageFactory(BitmapLruCache bitmapLruCache, PageStoreStrategy pageStoreStrategy) {
        this.b = bitmapLruCache;
        this.c = pageStoreStrategy;
    }

    public final Result buildPage(Bitmap bitmap, int n2, int n3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        try {
            Result result = this.buildPage(byteArrayOutputStream.toByteArray(), n2, n3);
            return result;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    public Result buildPage(byte[] byArray, int n2, int n3) throws IOException {
        Page page = new Page();
        File file = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file);
        FileUtils.forceMkdir((File)FileUtils.getFile((File)file, (String[])new String[]{"filtered"}));
        FileUtils.writeByteArrayToFile((File)new File(file, Page.ImageType.ORGINAL.getFileName()), (byte[])byArray);
        Bitmap bitmap = BitmapUtils.createPreview(byArray, n2, n3);
        page.setImageSize(Page.ImageType.OPTIMIZED_PREVIEW, bitmap.getWidth(), bitmap.getHeight());
        String string = this.c.getImageFile(page.getId(), Page.ImageType.PREVIEW).getPath();
        this.b.put(string, bitmap);
        a.execute(new b(this, string, bitmap));
        return new Result(page, bitmap);
    }

    public final Page buildPage(File file) throws IOException {
        Page page = new Page();
        File file2 = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file2);
        FileUtils.writeByteArrayToFile((File)new File(file2, Page.ImageType.OPTIMIZED.getFileName()), (byte[])FileUtils.readFileToByteArray((File)file));
        return page;
    }

    static /* synthetic */ Logger a(PageFactory pageFactory) {
        return pageFactory.d;
    }

    public static class Result {
        public final Page page;
        public final Bitmap preview;

        public Result(Page page, Bitmap bitmap) {
            this.page = page;
            this.preview = bitmap;
        }
    }
}

