/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import net.doo.snap.R;
import net.doo.snap.lib.detector.Line2D;
import net.doo.snap.ui.MagnifierView;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.PolygonHelper;
import org.jetbrains.annotations.Nullable;

public class EditPolygonImageView
extends ImageView {
    private static final int CORNERS_COUNT = 4;
    public static final List<PointF> DEFAULT_POLYGON = new net.doo.snap.ui.a();
    private final float magneticLineTreshold;
    private final int edgeColor;
    private final Drawable cornerDrawable;
    private final Drawable edgeDrawable;
    private final Logger logger = LoggerProvider.getLogger();
    private Paint paint;
    private Paint handlePaint;
    private PolygonHelper polygonHelper;
    private float rotationScale = 1.0f;
    private final List<Line2D> horizontalLines2D = new ArrayList<Line2D>();
    private final List<Line2D> verticalLines2D = new ArrayList<Line2D>();
    private final List<b> horizontalLines = new ArrayList<b>();
    private final List<b> verticalLines = new ArrayList<b>();
    private PointF finger = new PointF();
    private List<PointF> polygon;
    private List<PointF> corners;
    private List<a> edges;
    private float offsetX;
    private float offsetY;
    private Bitmap cornerBitmap;
    private Bitmap edgeBitmap;
    private int handleSize;
    private PointF selectedCorner;
    private a selectedEdge;
    private PointF tmpPointA = new PointF();
    private PointF tmpPointB = new PointF();
    private float medianX;
    private float medianY;
    private PriorityQueue<PointF> pointsQueue = new PriorityQueue<PointF>(4, new net.doo.snap.ui.b(this));
    @Nullable
    private MagnifierView magnifierView;
    private float[] imageMatrix = new float[9];
    private RectF touchRect = new RectF();
    private float polygonStrokeWidth;
    private int lastKnownImageWidth = -1;
    private int lastKnownImageHeight = -1;

    public EditPolygonImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n2;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.EditPolygonImageView, 0, 0);
        try {
            this.edgeColor = typedArray.getColor(R.styleable.EditPolygonImageView_edgeColor, 0);
            this.cornerDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_cornerImageSrc);
            this.edgeDrawable = typedArray.getDrawable(R.styleable.EditPolygonImageView_edgeImageSrc);
            this.magneticLineTreshold = typedArray.getDimension(R.styleable.EditPolygonImageView_magneticLineTreshold, this.getResources().getDimension(R.dimen.magnetic_line_treshold));
            this.polygonStrokeWidth = typedArray.getDimension(R.styleable.EditPolygonImageView_editPolygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            this.handleSize = typedArray.getDimensionPixelSize(R.styleable.EditPolygonImageView_editPolygonHandleSize, this.getResources().getDimensionPixelSize(R.dimen.edit_polygon_handle_size));
        }
        finally {
            typedArray.recycle();
        }
        this.polygon = Collections.emptyList();
        this.paint = new Paint();
        this.paint.setColor(this.edgeColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.polygonStrokeWidth);
        this.paint.setAntiAlias(true);
        this.handlePaint = new Paint();
        this.handlePaint.setAntiAlias(true);
        this.handlePaint.setFilterBitmap(true);
        this.polygonHelper = new PolygonHelper();
        this.corners = new ArrayList<PointF>();
        for (n2 = 0; n2 < 4; ++n2) {
            this.corners.add(new PointF());
        }
        this.edges = new ArrayList<a>();
        for (n2 = 0; n2 < this.corners.size(); ++n2) {
            a a2 = new a(0);
            a2.b = this.corners.get(n2);
            a2.c = this.corners.get((n2 + 1) % 4);
            a2.d = this.corners.get((n2 + 3) % 4);
            a2.e = this.corners.get((n2 + 2) % 4);
            this.edges.add(a2);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.cornerBitmap = BitmapUtils.drawableToBitmap(this.cornerDrawable);
        this.edgeBitmap = BitmapUtils.drawableToBitmap(this.edgeDrawable);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cornerBitmap.recycle();
        this.edgeBitmap.recycle();
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n2, n3);
        this.onImageSizeUpdated();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        if (this.getDrawable() != null) {
            this.rotateAndScale();
        }
    }

    public void setPolygon(List<PointF> list) {
        if (!list.isEmpty()) {
            this.polygon = list;
            this.polygonHelper.getDrawingPolygon(list, this.corners);
            this.invalidate();
        }
    }

    public List<PointF> getPolygon() {
        this.polygonHelper.getPolygonFromDrawingPolygon(this.corners, this.polygon);
        return this.polygon;
    }

    public void setLines(List<Line2D> list, List<Line2D> list2) {
        b b2;
        this.horizontalLines2D.clear();
        this.horizontalLines2D.addAll(this.polygonHelper.scaleLines(list));
        this.verticalLines2D.clear();
        this.verticalLines2D.addAll(this.polygonHelper.scaleLines(list2));
        this.horizontalLines.clear();
        this.verticalLines.clear();
        for (Line2D line2D : list) {
            b2 = new b(0);
            b2.a(line2D.getStart(), line2D.getEnd());
            this.horizontalLines.add(b2);
        }
        for (Line2D line2D : list2) {
            b2 = new b(0);
            b2.a(line2D.getStart(), line2D.getEnd());
            this.verticalLines.add(b2);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.checkWhetherImageSizeUpdated();
        if (!this.polygon.isEmpty()) {
            canvas.save();
            canvas.translate(this.offsetX, this.offsetY);
            for (int i2 = 0; i2 < this.corners.size(); ++i2) {
                PointF object = this.corners.get(i2);
                PointF pointF = this.corners.get((i2 + 1) % 4);
                canvas.drawLine(object.x, object.y, pointF.x, pointF.y, this.paint);
            }
            if (this.selectedCorner != null) {
                this.drawHandle(canvas, this.selectedCorner, this.cornerBitmap, 0.0f);
                canvas.save();
                canvas.translate(-this.offsetX, -this.offsetY);
                if (this.magnifierView != null) {
                    this.magnifierView.drawMagnifier(this.selectedCorner);
                }
                canvas.restore();
            } else if (this.selectedEdge != null) {
                this.drawHandle(canvas, this.selectedEdge.b(), this.edgeBitmap, this.selectedEdge.a());
            } else {
                for (a a2 : this.edges) {
                    this.drawHandle(canvas, a2.b(), this.edgeBitmap, a2.a());
                }
                for (PointF pointF : this.corners) {
                    this.drawHandle(canvas, pointF, this.cornerBitmap, 0.0f);
                }
            }
            canvas.restore();
        }
    }

    private void checkWhetherImageSizeUpdated() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return;
        }
        if (drawable.getIntrinsicWidth() != this.lastKnownImageWidth || drawable.getIntrinsicHeight() != this.lastKnownImageHeight) {
            this.lastKnownImageWidth = drawable.getIntrinsicWidth();
            this.lastKnownImageHeight = drawable.getIntrinsicHeight();
            this.onImageSizeUpdated();
        }
    }

    private void drawHandle(Canvas canvas, PointF pointF, Bitmap bitmap, float f2) {
        canvas.save();
        if (f2 != 0.0f) {
            canvas.rotate(f2, pointF.x, pointF.y);
        }
        float f3 = 1.0f / this.rotationScale;
        canvas.scale(f3, f3, pointF.x, pointF.y);
        canvas.drawBitmap(bitmap, pointF.x - (float)(bitmap.getWidth() >> 1), pointF.y - (float)(bitmap.getHeight() >> 1), this.handlePaint);
        canvas.restore();
    }

    private void keepInsideView(PointF pointF) {
        float f2 = Math.max(0.0f, Math.min(pointF.x, (float)this.getWidth() - 2.0f * this.offsetX));
        float f3 = Math.max(0.0f, Math.min(pointF.y, (float)this.getHeight() - 2.0f * this.offsetY));
        pointF.set(f2, f3);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                int n2 = this.handleSize >> 1;
                this.touchRect.set(motionEvent.getX() - this.offsetX - (float)n2, motionEvent.getY() - this.offsetY - (float)n2, motionEvent.getX() - this.offsetX + (float)n2, motionEvent.getY() - this.offsetY + (float)n2);
                for (PointF object : this.corners) {
                    if (!this.touchRect.contains(object.x, object.y)) continue;
                    this.selectedCorner = object;
                    this.invalidate();
                    return true;
                }
                for (a a2 : this.edges) {
                    PointF pointF = a2.b();
                    if (!this.touchRect.contains(pointF.x, pointF.y)) continue;
                    this.selectedEdge = a2;
                    a2.j = motionEvent.getX();
                    a2.k = motionEvent.getY();
                    a2.g.a(a2.b, a2.d);
                    a2.h.a(a2.c, a2.e);
                    this.finger.set(pointF);
                    this.invalidate();
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.selectedCorner != null) {
                    this.selectedCorner.set(motionEvent.getX() - this.offsetX, motionEvent.getY() - this.offsetY);
                    this.keepInsideView(this.selectedCorner);
                    this.ensureNoPolygonIntersection();
                    this.invalidate();
                } else if (this.selectedEdge != null) {
                    double d2;
                    int pointF;
                    float f2 = motionEvent.getX() - this.selectedEdge.j;
                    float f3 = motionEvent.getY() - this.selectedEdge.k;
                    this.finger.offset(f2, f3);
                    this.tmpPointA.set(this.selectedEdge.b);
                    this.tmpPointB.set(this.selectedEdge.c);
                    double d3 = Double.MAX_VALUE;
                    Line2D line2D = null;
                    if (this.selectedEdge.c()) {
                        for (pointF = 0; pointF < this.horizontalLines.size(); ++pointF) {
                            double d4;
                            d2 = this.horizontalLines.get(pointF).a(this.finger);
                            if (!(d4 < d3)) continue;
                            d3 = d2;
                            line2D = this.horizontalLines2D.get(pointF);
                        }
                    } else {
                        for (pointF = 0; pointF < this.verticalLines.size(); ++pointF) {
                            double d5;
                            d2 = this.verticalLines.get(pointF).a(this.finger);
                            if (!(d5 < d3)) continue;
                            d3 = d2;
                            line2D = this.verticalLines2D.get(pointF);
                        }
                    }
                    if (line2D != null && d3 < (double)this.magneticLineTreshold) {
                        this.selectedEdge.b.set(line2D.getStart());
                        this.selectedEdge.c.set(line2D.getEnd());
                    } else {
                        PointF pointF2 = this.selectedEdge.b();
                        float f4 = this.finger.x - pointF2.x;
                        float f5 = this.finger.y - pointF2.y;
                        this.selectedEdge.b.offset(f4, f5);
                        this.selectedEdge.c.offset(f4, f5);
                    }
                    this.selectedEdge.f.a(this.selectedEdge.b, this.selectedEdge.c);
                    PointF pointF3 = this.selectedEdge.f.a(this.selectedEdge.g);
                    if (Float.isNaN(pointF3.x) || Float.isNaN(pointF3.y)) {
                        this.restoreSelectedEdge();
                        return false;
                    }
                    this.selectedEdge.b.set(pointF3);
                    PointF pointF4 = this.selectedEdge.f.a(this.selectedEdge.h);
                    if (Float.isNaN(pointF4.x) || Float.isNaN(pointF4.y)) {
                        this.restoreSelectedEdge();
                        return false;
                    }
                    this.selectedEdge.c.set(pointF4);
                    this.keepInsideView(this.selectedEdge.b);
                    this.keepInsideView(this.selectedEdge.c);
                    this.selectedEdge.j = motionEvent.getX();
                    this.selectedEdge.k = motionEvent.getY();
                    this.invalidate();
                }
                return true;
            }
            case 1: 
            case 3: {
                this.selectedCorner = null;
                this.selectedEdge = null;
                if (this.magnifierView != null) {
                    this.magnifierView.eraseMagnifier();
                }
                this.invalidate();
                return true;
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    private void restoreSelectedEdge() {
        this.selectedEdge.b.set(this.tmpPointA);
        this.selectedEdge.c.set(this.tmpPointB);
        this.selectedEdge.f.a(this.selectedEdge.b, this.selectedEdge.c);
    }

    private void ensureNoPolygonIntersection() {
        this.calculateMedian();
        if (this.ensureCornersOrder()) {
            this.ensureEdgesOrder();
        }
    }

    private boolean ensureCornersOrder() {
        boolean bl = false;
        this.pointsQueue.addAll(this.corners);
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = (PointF)this.pointsQueue.remove();
            if (!pointF.equals((Object)this.corners.get(i2))) {
                bl = true;
            }
            this.corners.set(i2, pointF);
        }
        return bl;
    }

    private void calculateMedian() {
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            PointF pointF = this.corners.get(i2);
            f2 += pointF.x;
            f3 += pointF.y;
        }
        this.medianX = f2 / 4.0f;
        this.medianY = f3 / 4.0f;
    }

    private void ensureEdgesOrder() {
        for (int i2 = 0; i2 < 4; ++i2) {
            a a2 = this.edges.get(i2);
            a2.b = this.corners.get(i2);
            a2.c = this.corners.get((i2 + 1) % 4);
            a2.d = this.corners.get((i2 + 3) % 4);
            a2.e = this.corners.get((i2 + 2) % 4);
        }
    }

    private void rotateAndScale() {
        this.rotationScale = this.calculateRotationScale();
        this.setScaleX(this.rotationScale);
        this.setScaleY(this.rotationScale);
        float f2 = 1.0f / this.rotationScale;
        this.paint.setStrokeWidth(f2 * this.polygonStrokeWidth);
    }

    private float calculateRotationScale() {
        if (this.getRotation() != 90.0f && this.getRotation() != 270.0f) {
            return 1.0f;
        }
        float f2 = this.getWidth();
        float f3 = this.getHeight();
        return Math.min(f2 / (f3 - this.offsetY * 2.0f), f3 / (f2 - this.offsetX * 2.0f));
    }

    private void onImageSizeUpdated() {
        if (this.getDrawable() != null) {
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.getImageMatrix().getValues(this.imageMatrix);
            float f2 = this.imageMatrix[0];
            float f3 = this.imageMatrix[4];
            Drawable drawable = this.getDrawable();
            int n2 = drawable.getIntrinsicWidth();
            int n3 = drawable.getIntrinsicHeight();
            int n4 = Math.round((float)n2 * f2);
            int n5 = Math.round((float)n3 * f3);
            if (n4 < this.getMeasuredWidth()) {
                this.offsetX = this.getMeasuredWidth() - n4 >> 1;
            }
            if (n5 < this.getMeasuredHeight()) {
                this.offsetY = this.getMeasuredHeight() - n5 >> 1;
            }
            this.polygonHelper.setImageSize(n4, n5);
            if (!this.polygon.isEmpty()) {
                this.polygonHelper.getDrawingPolygon(this.polygon, this.corners);
            }
        }
    }

    void setMagnifier(MagnifierView magnifierView) {
        this.magnifierView = magnifierView;
        this.invalidate();
    }

    static /* synthetic */ float access$000(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.medianY;
    }

    static /* synthetic */ float access$100(EditPolygonImageView editPolygonImageView) {
        return editPolygonImageView.medianX;
    }

    private final class b {
        private double b;
        private double c;
        private double d;
        private PointF e = new PointF();

        private b() {
        }

        final PointF a(b b2) {
            this.e.x = (float)((this.d * b2.c - this.c * b2.d) / (this.c * b2.b - this.b * b2.c));
            this.e.y = (float)((this.b * b2.d - this.d * b2.b) / (this.c * b2.b - this.b * b2.c));
            return this.e;
        }

        final void a(PointF pointF, PointF pointF2) {
            this.b = pointF.y - pointF2.y;
            this.c = pointF2.x - pointF.x;
            this.d = (pointF.x - pointF2.x) * pointF.y + (pointF2.y - pointF.y) * pointF.x;
        }

        final double a(PointF pointF) {
            if (this.b != 0.0 || this.c != 0.0) {
                return Math.abs(this.b * (double)pointF.x + this.c * (double)pointF.y + this.d) / Math.sqrt(this.b * this.b + this.c * this.c);
            }
            return 0.0;
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    private final class a {
        private PointF b;
        private PointF c;
        private PointF d;
        private PointF e;
        private b f;
        private b g;
        private b h;
        private PointF i;
        private float j;
        private float k;

        private a() {
            this.f = new b(0);
            this.g = new b(0);
            this.h = new b(0);
            this.i = new PointF();
        }

        final float a() {
            float f2 = this.c.y - this.b.y;
            float f3 = this.c.x - this.b.x;
            return (float)(Math.toDegrees(Math.atan2(f2, f3)) + 90.0);
        }

        final PointF b() {
            this.i.x = (this.b.x + this.c.x) / 2.0f;
            this.i.y = (this.b.y + this.c.y) / 2.0f;
            return this.i;
        }

        final boolean c() {
            float f2 = this.c.y - this.b.y;
            return Math.abs(this.c.x - this.b.x) > Math.abs(f2);
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

