/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public enum Language {
    AFR("afr"),
    ARA("ara"),
    AZE("aze"),
    BEL("bel"),
    BEN("ben"),
    BUL("bul"),
    CAT("cat"),
    CES("ces"),
    CHR("chr"),
    CHS("chs"),
    CHT("cht"),
    DAF("daf"),
    DAN("dan"),
    DEF("def"),
    DEU("deu"),
    ELL("ell"),
    ENG("eng"),
    ENM("enm"),
    EPO("epo"),
    EQU("equ"),
    EST("est"),
    EUS("eus"),
    FIN("fin"),
    FRA("fra"),
    FRK("frk"),
    FRM("frm"),
    GLG("glg"),
    GRC("grc"),
    HEB("heb"),
    HIN("hin"),
    HRV("hrv"),
    HUN("hun"),
    IND("ind"),
    ISL("isl"),
    ITA("ita"),
    JPN("jpn"),
    KAN("kan"),
    KOR("kor"),
    LAV("lav"),
    LIT("lit"),
    MAL("mal"),
    MKD("mkd"),
    MLT("mlt"),
    MSA("msa"),
    NDL("nld"),
    NOR("nor"),
    POL("pol"),
    POR("por"),
    RON("ron"),
    RUS("rus"),
    SLF("slf"),
    SLK("slk"),
    SLV("slv"),
    SPA("spa"),
    SQI("sqi"),
    SRP("srp"),
    SWA("swa"),
    SWE("swe"),
    TAM("tam"),
    TEL("tel"),
    TGL("tgl"),
    THA("tha"),
    TUR("tur"),
    UKR("ukr"),
    VIE("vie");

    private static final HashMap<String, Language> isoToLanguage;
    private final String isoCode;

    public static Language languageByIso(String string) {
        return isoToLanguage.get(string);
    }

    public static String[] languageCodes(Collection<Language> collection) {
        String[] stringArray = new String[collection.size()];
        int n2 = 0;
        for (Language language : collection) {
            stringArray[n2] = language.getIsoCode();
            ++n2;
        }
        return stringArray;
    }

    private Language(@NotNull String string2) {
        this.isoCode = string2;
    }

    public final String getIsoCode() {
        return this.isoCode;
    }

    static {
        isoToLanguage = new HashMap();
        for (Language language : Language.values()) {
            isoToLanguage.put(language.getIsoCode(), language);
        }
        isoToLanguage.put("nob", NOR);
        isoToLanguage.put("zho", CHS);
    }
}

