/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence.cleanup;

import android.util.Pair;
import com.google.inject.Inject;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.persistence.cleanup.UnreferencedSourcesProvider;
import net.doo.snap.process.f;
import net.doo.snap.process.util.DocumentDraft;

public class Cleaner {
    @Inject
    private UnreferencedSourcesProvider unreferencedSourcesProvider;
    @Inject
    private PageStoreStrategy pageStoreStrategy;
    @Inject
    private DocumentStoreStrategy documentStoreStrategy;
    @Inject
    private f processingInfoProvider;

    public Cleaner() {
    }

    @Inject
    public Cleaner(UnreferencedSourcesProvider unreferencedSourcesProvider, PageStoreStrategy pageStoreStrategy, DocumentStoreStrategy documentStoreStrategy, f f2) {
        this();
        this.unreferencedSourcesProvider = unreferencedSourcesProvider;
        this.pageStoreStrategy = pageStoreStrategy;
        this.documentStoreStrategy = documentStoreStrategy;
        this.processingInfoProvider = f2;
    }

    public void cleanUp() {
        for (Pair<String, String> object : this.unreferencedSourcesProvider.getUnreferencedDocuments()) {
            this.documentStoreStrategy.eraseDocument((String)object.first, (String)object.second);
        }
        for (String string : this.unreferencedSourcesProvider.getUnreferencedPages()) {
            this.pageStoreStrategy.erasePage(string);
        }
        for (DocumentDraft documentDraft : this.processingInfoProvider.b()) {
            this.cleanUpPagesData(documentDraft.getPages());
        }
    }

    public void cleanUpPagesData(Page[] pageArray) {
        Page[] pageArray2 = pageArray;
        int n2 = pageArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Page page = pageArray2[i2];
            this.pageStoreStrategy.eraseTempPageData(page.getId());
        }
    }
}

