/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.draft;

import android.content.SharedPreferences;
import com.google.inject.Inject;
import java.util.UUID;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.SnappingDraft;
import net.doo.snap.process.draft.DocumentDraftExtractor;
import net.doo.snap.process.util.DocumentDraft;

public class MultipleDocumentsDraftExtractor
implements DocumentDraftExtractor {
    private final String a;

    public static MultipleDocumentsDraftExtractor forPdf() {
        return new MultipleDocumentsDraftExtractor(".pdf");
    }

    public static MultipleDocumentsDraftExtractor forJpeg() {
        return new MultipleDocumentsDraftExtractor(".jpg");
    }

    @Inject
    public MultipleDocumentsDraftExtractor(SharedPreferences sharedPreferences) {
        this(sharedPreferences.getBoolean("SAVE_SINGLE_AS_JPEG", false) ? ".jpg" : ".pdf");
    }

    private MultipleDocumentsDraftExtractor(String string) {
        this.a = string;
    }

    @Override
    public DocumentDraft[] extract(SnappingDraft snappingDraft) {
        DocumentDraft[] documentDraftArray = new DocumentDraft[snappingDraft.size()];
        for (int i2 = 0; i2 < documentDraftArray.length; ++i2) {
            String string = snappingDraft.getDocumentName() + this.a;
            Document document = new Document();
            document.setId(UUID.randomUUID().toString());
            document.setName(string);
            document.setPagesCount(1);
            document.setOcrStatus(OcrStatus.NOT_SCHEDULED);
            Document document2 = document;
            documentDraftArray[i2] = new DocumentDraft(document2, snappingDraft.getPage(i2));
        }
        return documentDraftArray;
    }

    private static Document a(String string) {
        Document document = new Document();
        document.setId(UUID.randomUUID().toString());
        document.setName(string);
        document.setPagesCount(1);
        document.setOcrStatus(OcrStatus.NOT_SCHEDULED);
        return document;
    }
}

