/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.device;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.google.inject.Inject;

public class DeviceUtils {
    private final Context context;

    @Inject
    public DeviceUtils(Context context) {
        this.context = context;
    }

    public float getBatteryLevel() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.context.registerReceiver(null, intentFilter);
        float f2 = -1.0f;
        if (intent != null) {
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            f2 = (float)n2 / (float)n3;
        }
        return f2;
    }

    public boolean isDeviceOnCharger() {
        Intent intent = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        int n2 = intent.getIntExtra("status", -1);
        if (n2 == 2 || n2 == 5) {
            return true;
        }
        int n3 = intent.getIntExtra("plugged", -1);
        return n3 == 2 || n3 == 1;
    }
}

