/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.graphics.Point;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.doo.snap.entity.RotationType;
import net.doo.snap.entity.b;
import net.doo.snap.entity.c;
import net.doo.snap.entity.d;

public class Page
implements Parcelable {
    public static final String FILTERED_FOLDER = "filtered";
    private final String id;
    private final Bundle parameters;
    private b optimizationType = b.a;
    private RotationType rotationType = RotationType.ROTATION_0;
    private List<PointF> polygon = new c(this);
    private SparseArray<Point> imageSizes = new SparseArray();
    private boolean processed = false;
    public static Parcelable.Creator<Page> CREATOR = new d();

    public Page() {
        this.id = UUID.randomUUID().toString();
        this.parameters = new Bundle();
    }

    public Page(String string) {
        this.id = string;
        this.parameters = new Bundle();
    }

    public String getId() {
        return this.id;
    }

    public b getOptimizationType() {
        return this.optimizationType;
    }

    public void setOptimizationType(b b2) {
        this.optimizationType = b2;
    }

    public RotationType getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
    }

    public List<PointF> getPolygon() {
        if (this.polygon == null) {
            return Collections.emptyList();
        }
        return this.polygon;
    }

    public void setPolygon(List<PointF> list) {
        if (list == null || list.size() != 4) {
            return;
        }
        this.polygon = list;
    }

    public void setImageSize(ImageType imageType, int n2, int n3) {
        this.imageSizes.put(imageType.ordinal(), (Object)new Point(n2, n3));
    }

    public Point getImageSize(ImageType imageType) {
        return (Point)this.imageSizes.get(imageType.ordinal());
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean bl) {
        this.processed = bl;
    }

    public Bundle getParameters() {
        return this.parameters;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Page)) {
            return false;
        }
        Page page = (Page)object;
        return this.id.equals(page.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.id);
        parcel.writeBundle(this.parameters);
        parcel.writeInt(this.optimizationType == null ? -1 : this.optimizationType.ordinal());
        parcel.writeInt(this.rotationType == null ? -1 : this.rotationType.ordinal());
        parcel.writeTypedList(this.polygon);
        parcel.writeSparseArray(this.imageSizes);
    }

    private Page(Parcel parcel) {
        this.id = parcel.readString();
        this.parameters = parcel.readBundle();
        int n2 = parcel.readInt();
        this.optimizationType = n2 == -1 ? null : b.values()[n2];
        int n3 = parcel.readInt();
        this.rotationType = n3 == -1 ? null : RotationType.values()[n3];
        parcel.readTypedList(this.polygon, PointF.CREATOR);
        this.imageSizes = parcel.readSparseArray(SparseArray.class.getClassLoader());
    }

    /* synthetic */ Page(Parcel parcel, c c2) {
        this(parcel);
    }

    public static enum ImageType {
        ORGINAL("original"),
        PREVIEW("preview"),
        OPTIMIZED_PREVIEW("optimized_preview"),
        OPTIMIZED("optimized"),
        OVERLAY("overlay"),
        OVERLAY_TMP("overlay_tmp"),
        COMBINED("combined");

        private String fileName;

        private ImageType(String string2) {
            this.fileName = string2;
        }

        public final String getFileName() {
            return this.fileName;
        }
    }
}

