/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.ComposerFactory;
import net.doo.snap.process.compose.JpegComposer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.device.DeviceUtils;
import org.jetbrains.annotations.NotNull;
import roboguice.RoboGuice;

public class BaseComposerFactory
implements ComposerFactory {
    private final Context a;
    private final SharedPreferences b;
    private final DeviceUtils c;

    @Inject
    public BaseComposerFactory(Context context, SharedPreferences sharedPreferences, DeviceUtils deviceUtils) {
        this.a = context;
        this.b = sharedPreferences;
        this.c = deviceUtils;
    }

    @Override
    @NotNull
    public Composer composerForDocument(Document document) {
        if (document.getName().endsWith(".jpg")) {
            Document document2 = document;
            BaseComposerFactory baseComposerFactory = this;
            if (document2.getSize() > 0L) {
                return new ComposerFactory.DummyComposer();
            }
            JpegComposer jpegComposer = new JpegComposer();
            RoboGuice.getInjector((Context)baseComposerFactory.a).injectMembersWithoutViews((Object)jpegComposer);
            return jpegComposer;
        }
        Document document3 = document;
        BaseComposerFactory baseComposerFactory = this;
        if (document3.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        SimpleComposer simpleComposer = new SimpleComposer();
        RoboGuice.getInjector((Context)baseComposerFactory.a).injectMembersWithoutViews((Object)simpleComposer);
        return simpleComposer;
    }

    private Composer a(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        SimpleComposer simpleComposer = new SimpleComposer();
        RoboGuice.getInjector((Context)this.a).injectMembersWithoutViews((Object)simpleComposer);
        return simpleComposer;
    }

    private Composer b(Document document) {
        if (document.getSize() > 0L) {
            return new ComposerFactory.DummyComposer();
        }
        JpegComposer jpegComposer = new JpegComposer();
        RoboGuice.getInjector((Context)this.a).injectMembersWithoutViews((Object)jpegComposer);
        return jpegComposer;
    }
}

