/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraView;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.Utils;
import net.doo.snap.util.thread.ExecutionUtils;

public class ScanbotCameraView
extends FrameLayout {
    private CameraView cameraView;
    private net.doo.snap.camera.a cameraHost;
    private boolean resumed = false;
    private int state$21b6dd48 = b.a;
    private int lastMeasuredWidth;
    private int lastMeasuredHeight;
    private final Set<net.doo.snap.camera.b> stateCallbacks = new LinkedHashSet<net.doo.snap.camera.b>();
    private final Logger logger = LoggerProvider.getLogger();

    public ScanbotCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public ScanbotCameraView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context);
    }

    private void initView(Context context) {
        this.cameraView = new CameraView(context);
        this.cameraHost = new net.doo.snap.camera.a(context);
        this.cameraView.setCameraHost((CameraHost)this.cameraHost);
        this.cameraView.a(new a(0));
        this.addView((View)this.cameraView, 0);
    }

    protected void onMeasure(int n2, int n3) {
        this.logger.logMethod();
        int n4 = ScanbotCameraView.resolveSize((int)this.lastMeasuredWidth, (int)n2);
        int n5 = ScanbotCameraView.resolveSize((int)this.lastMeasuredHeight, (int)n3);
        if (this.lastMeasuredWidth < n4 || this.lastMeasuredHeight < n5) {
            this.lastMeasuredWidth = n4;
            this.lastMeasuredHeight = n5;
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)this.lastMeasuredWidth, (int)View.MeasureSpec.getMode((int)n2)), View.MeasureSpec.makeMeasureSpec((int)this.lastMeasuredHeight, (int)View.MeasureSpec.getMode((int)n3)));
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        this.logger.logMethod();
        super.onLayout(bl, n2, n3, n4, n5);
        View view = this.cameraView.getChildAt(0);
        if (view == null) {
            return;
        }
        int n6 = this.getChildCount();
        int n7 = View.MeasureSpec.makeMeasureSpec((int)view.getWidth(), (int)Integer.MIN_VALUE);
        int n8 = View.MeasureSpec.makeMeasureSpec((int)view.getHeight(), (int)Integer.MIN_VALUE);
        for (int i2 = 1; i2 < n6; ++i2) {
            View view2 = this.getChildAt(i2);
            view2.measure(n7, n8);
            view2.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.cameraView.b();
    }

    public void onResume() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (this.resumed) {
            return;
        }
        this.resumed = c.a(this.getContext()).isLicenseActive();
        this.state$21b6dd48 = b.a;
        this.cameraView.onResume();
        this.notifyResumedState();
    }

    public void onPause() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.resumed = false;
        this.state$21b6dd48 = b.a;
        this.cameraView.onPause();
        this.notifyPausedState();
    }

    private void notifyResumedState() {
        Iterator<net.doo.snap.camera.b> iterator = this.stateCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().a();
        }
    }

    private void notifyPausedState() {
        Iterator<net.doo.snap.camera.b> iterator = this.stateCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().b();
        }
    }

    public void startPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state$21b6dd48 = b.a;
        this.cameraView.startPreview();
    }

    public void stopPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state$21b6dd48 = b.a;
        this.cameraView.stopPreview();
    }

    public void takePicture(boolean bl) {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        if (this.state$21b6dd48 != b.a) {
            return;
        }
        if (bl) {
            this.state$21b6dd48 = b.b;
            this.autoFocus();
            return;
        }
        this.performSnapping();
    }

    private void performSnapping() {
        this.state$21b6dd48 = b.c;
        try {
            this.cameraView.takePicture(new PictureTransaction((CameraHost)this.cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true));
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.state$21b6dd48 = b.a;
            return;
        }
    }

    public void useFlash(boolean bl) {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (Utils.isFlashSupported(parameters)) {
            parameters.setFlashMode(bl ? "torch" : "off");
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void autoFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.autoFocus();
    }

    public void continuousFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.a();
    }

    public void addPictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.a(pictureCallback);
    }

    public void removePictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.b(pictureCallback);
    }

    void addCameraStateCallback(net.doo.snap.camera.b b2) {
        this.logger.logMethod();
        this.stateCallbacks.add(b2);
    }

    void removeCameraStateCallback(net.doo.snap.camera.b b2) {
        this.logger.logMethod();
        this.stateCallbacks.remove(b2);
    }

    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        this.logger.logMethod();
        this.cameraView.a(cameraOpenCallback);
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        this.logger.logMethod();
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            return parameters.getSupportedPictureSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        this.logger.logMethod();
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            return parameters.getSupportedPreviewSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public void setPictureSize(Camera.Size size) {
        this.logger.logMethod();
        this.cameraHost.a(size);
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPictureSize(size.width, size.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setPreviewSize(Camera.Size size) {
        this.logger.logMethod();
        this.cameraHost.b(size);
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPreviewSize(size.width, size.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void lockToPortrait() {
        this.logger.logMethod();
        this.cameraView.lockToPortrait();
    }

    public void lockToLandscape() {
        this.logger.logMethod();
        this.cameraView.lockToLandscape();
    }

    public void unlockOrientation() {
        this.logger.logMethod();
        this.cameraView.unlockOrientation();
    }

    private static final class b
    extends Enum<b> {
        public static final /* enum */ int a = 1;
        public static final /* enum */ int b = 2;
        public static final /* enum */ int c = 3;
        private static final /* synthetic */ int[] d;

        private static int[] a() {
            return (int[])d.clone();
        }

        private b() {
        }

        static {
            d = new int[]{a, b, c};
        }
    }

    private final class a
    implements CameraView.AutofocusCallback {
        private a() {
        }

        @Override
        public final void onAutoFocusCompleted() {
            ScanbotCameraView.this.logger.logMethod();
            if (ScanbotCameraView.this.state$21b6dd48 == b.b) {
                ScanbotCameraView.this.performSnapping();
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

