/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class AutoSnappingController {
    private static final int DELAY_AUTO_SNAPPING_SHOOT_MS = 1500;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private final ScanbotCameraView cameraView;
    private final AtomicLong captureInterval = new AtomicLong(0L);
    private final Logger logger = LoggerProvider.getLogger();
    private long lastCapture = 0L;
    private boolean capturing = false;
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private boolean isAutoSnapEnabled = true;
    private AtomicBoolean isAutosnappingShooting = new AtomicBoolean(false);
    private AutoSnappingCallback autoSnappingCallback = AutoSnappingCallback.NULL;
    private final Runnable autosnappingShoot = new Runnable(){

        @Override
        public final void run() {
            if (AutoSnappingController.this.isAutoSnapEnabled) {
                if (!AutoSnappingController.this.autoSnappingCallback.onAutoSnapping()) {
                    AutoSnappingController.this.cameraView.takePicture(true);
                    return;
                }
            } else {
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    };

    public static AutoSnappingController attach(ScanbotCameraView scanbotCameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler(scanbotCameraView.getContext());
        return AutoSnappingController.attach(scanbotCameraView, contourDetectorFrameHandler);
    }

    public static AutoSnappingController attach(ScanbotCameraView scanbotCameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        return new AutoSnappingController(scanbotCameraView, contourDetectorFrameHandler);
    }

    public AutoSnappingController(ScanbotCameraView scanbotCameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        this.cameraView = scanbotCameraView;
        scanbotCameraView.getPreviewBuffer().addFrameHandler(contourDetectorFrameHandler);
        scanbotCameraView.addPictureCallback(new c(0));
        scanbotCameraView.addCameraStateCallback(new a(0));
        contourDetectorFrameHandler.addResultHandler(new b(0));
    }

    private void onDetectionOK() {
        if (!this.isAutosnappingShooting.get()) {
            this.isAutosnappingShooting.set(true);
            this.mainThreadHandler.postDelayed(this.autosnappingShoot, 1500L);
        }
    }

    public void setEnabled(boolean bl) {
        this.isAutoSnapEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    public void setSensitivity(float f2) {
        this.logger.logMethod();
        float f3 = 1.0f - this.clamp(f2);
        this.captureInterval.set((long)(f3 * 3000.0f));
    }

    private float clamp(float f2) {
        if (f2 < 0.0f) {
            return 0.0f;
        }
        if (f2 > 1.0f) {
            return 1.0f;
        }
        return f2;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback autoSnappingCallback) {
        this.logger.logMethod();
        this.autoSnappingCallback = autoSnappingCallback != null ? autoSnappingCallback : AutoSnappingCallback.NULL;
    }

    private final class a
    implements net.doo.snap.camera.b {
        private a() {
        }

        @Override
        public final void a() {
        }

        @Override
        public final void b() {
            AutoSnappingController.this.isAutosnappingShooting.set(false);
            AutoSnappingController.this.capturing = false;
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    private final class c
    implements PictureCallback {
        private c() {
        }

        @Override
        public final void onPictureTaken(byte[] byArray, int n2) {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }

        /* synthetic */ c(byte by) {
            this();
        }
    }

    private final class b
    implements ContourDetectorFrameHandler.ResultHandler {
        private b() {
        }

        @Override
        public final boolean handleResult(ContourDetectorFrameHandler.DetectedFrame detectedFrame) {
            AutoSnappingController.this.logger.logMethod();
            if (detectedFrame.detectionResult == DetectionResult.OK) {
                if (!AutoSnappingController.this.capturing) {
                    AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
                    AutoSnappingController.this.capturing = true;
                } else if (SystemClock.elapsedRealtime() - AutoSnappingController.this.lastCapture > AutoSnappingController.this.captureInterval.get()) {
                    b b2 = this;
                    b2.AutoSnappingController.this.mainThreadHandler.post(new Runnable(){

                        @Override
                        public final void run() {
                            AutoSnappingController.this.onDetectionOK();
                        }
                    });
                    AutoSnappingController.this.capturing = false;
                }
            } else {
                AutoSnappingController.this.capturing = false;
            }
            return false;
        }

        private void a() {
            AutoSnappingController.this.mainThreadHandler.post(new /* invalid duplicate definition of identical inner class */);
        }

        /* synthetic */ b(byte by) {
            this();
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public final boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

