/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.graphics.Bitmap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.util.bitmap.BitmapLruCache;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PageFactory {
    private static final ExecutorService a = Executors.newSingleThreadExecutor();
    private final BitmapLruCache b;
    private final PageStoreStrategy c;
    private final Logger d = LoggerProvider.getLogger();

    @Inject
    public PageFactory(BitmapLruCache bitmapLruCache, PageStoreStrategy pageStoreStrategy) {
        this.b = bitmapLruCache;
        this.c = pageStoreStrategy;
    }

    public final Result buildPage(Bitmap bitmap, int n2, int n3) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
        try {
            Result result = this.buildPage(byteArrayOutputStream.toByteArray(), n2, n3);
            return result;
        }
        finally {
            byteArrayOutputStream.close();
        }
    }

    public Result buildPage(byte[] byArray, int n2, int n3) throws IOException {
        Page page = new Page();
        File file = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file);
        FileUtils.forceMkdir((File)FileUtils.getFile((File)file, (String[])new String[]{"filtered"}));
        FileUtils.writeByteArrayToFile((File)new File(file, Page.ImageType.ORGINAL.getFileName()), (byte[])byArray);
        final Bitmap bitmap = BitmapUtils.createPreview(byArray, n2, n3);
        page.setImageSize(Page.ImageType.OPTIMIZED_PREVIEW, bitmap.getWidth(), bitmap.getHeight());
        final String string = this.c.getImageFile(page.getId(), Page.ImageType.PREVIEW).getPath();
        this.b.put(string, bitmap);
        a.execute(new Runnable(){

            @Override
            public final void run() {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fileOutputStream);
                }
                catch (IOException iOException) {
                    try {
                        PageFactory.this.d.logException(iOException);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fileOutputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                    return;
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
                return;
            }
        });
        return new Result(page, bitmap);
    }

    public final Page buildPage(File file) throws IOException {
        Page page = new Page();
        File file2 = this.c.getPageDir(page.getId());
        FileUtils.forceMkdir((File)file2);
        FileUtils.writeByteArrayToFile((File)new File(file2, Page.ImageType.OPTIMIZED.getFileName()), (byte[])FileUtils.readFileToByteArray((File)file));
        return page;
    }

    public static class Result {
        public final Page page;
        public final Bitmap preview;

        public Result(Page page, Bitmap bitmap) {
            this.page = page;
            this.preview = bitmap;
        }
    }
}

