/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import net.doo.snap.R;
import net.doo.snap.ui.EditPolygonImageView;
import net.doo.snap.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final Drawable magnifierDrawable;
    private final int editPolygonMagnifierColor;
    private final float magnifierStrokeWidth;
    private final float magnifierCrossStrokeWidth;
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private a magnifier = new a();
    private PointF zoomPoint;
    private Bitmap magnifierBitmap;

    public MagnifierView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.MagnifierView, 0, 0);
        try {
            this.magnifierDrawable = typedArray.getDrawable(R.styleable.MagnifierView_magnifierImageSrc);
            this.editPolygonMagnifierColor = typedArray.getColor(R.styleable.MagnifierView_editPolygonMagnifier, 0);
            this.magnifierStrokeWidth = typedArray.getDimension(R.styleable.MagnifierView_magnifierStrokeWidth, this.getResources().getDimension(R.dimen.magnifier_stroke_width));
            this.magnifierCrossStrokeWidth = typedArray.getDimension(R.styleable.MagnifierView_magnifierCrossStrokeWidth, this.getResources().getDimension(R.dimen.magnifier_cross_stroke_width));
            this.magnifierRaduis = typedArray.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
            this.magnifierMargin = typedArray.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    void drawMagnifier(PointF pointF) {
        this.zoomPoint = pointF;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView editPolygonImageView) {
        this.magnifier.a(editPolygonImageView);
        editPolygonImageView.setMagnifier(this);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.zoomPoint != null) {
            this.magnifier.a(canvas, this.zoomPoint);
            return;
        }
        canvas.drawColor(0);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierBitmap = BitmapUtils.drawableToBitmap(this.magnifierDrawable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.magnifierBitmap.recycle();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        this.magnifier.a(this.getWidth(), this.getHeight());
    }

    private final class a {
        private final float b = 2.0f;
        private float c;
        private int d;
        private int e;
        private BitmapShader f;
        private Paint g;
        private Matrix h;
        private Paint i = new Paint();
        private Paint j;
        private float k;
        private float l;
        private float m;
        private BitmapDrawable n;

        a() {
            this.i.setColor(MagnifierView.this.editPolygonMagnifierColor);
            this.i.setStyle(Paint.Style.STROKE);
            this.i.setStrokeWidth(MagnifierView.this.magnifierStrokeWidth);
            this.i.setAntiAlias(true);
            this.j = new Paint();
            this.j.setColor(MagnifierView.this.editPolygonMagnifierColor);
            this.j.setStyle(Paint.Style.STROKE);
            this.j.setStrokeWidth(MagnifierView.this.magnifierCrossStrokeWidth);
            this.j.setAntiAlias(true);
            this.g = new Paint();
            this.h = new Matrix();
        }

        final void a(int n2, int n3) {
            this.d = n2;
            this.e = n3;
            if (this.n != null && n2 != 0 && n3 != 0) {
                this.c = Math.max((float)this.n.getIntrinsicWidth() / (float)this.d, (float)this.n.getIntrinsicHeight() / (float)this.e);
                this.k = ((float)this.d - (float)this.n.getIntrinsicWidth() / this.c) / 2.0f;
                this.l = ((float)this.e - (float)this.n.getIntrinsicHeight() / this.c) / 2.0f;
            }
        }

        final void a(ImageView imageView) {
            if (this.f == null && imageView.getDrawable() != null) {
                this.n = (BitmapDrawable)imageView.getDrawable();
                this.f = new BitmapShader(this.n.getBitmap(), Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                this.g.setShader((Shader)this.f);
                this.m = imageView.getRotation();
                this.a(MagnifierView.this.getWidth(), MagnifierView.this.getHeight());
            }
        }

        final void a(Canvas canvas, PointF pointF) {
            float f2 = MagnifierView.this.magnifierMargin;
            float f3 = MagnifierView.this.magnifierMargin;
            PointF pointF2 = pointF;
            a a2 = this;
            int n2 = pointF2.x + a2.k < (float)(a2.d >> 1) ? (pointF2.y + a2.l < (float)(a2.e >> 1) ? 1 : 4) : (pointF2.y + a2.l < (float)(a2.e >> 1) ? 2 : 3);
            if ((int)((float)n2 - (360.0f - a2.m) % 360.0f / 90.0f) == 1) {
                f2 = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            this.h.setScale(2.0f, 2.0f);
            this.h.postTranslate(-pointF.x * this.c * 2.0f + MagnifierView.this.magnifierRaduis + f2, -pointF.y * this.c * 2.0f + MagnifierView.this.magnifierRaduis + f3);
            this.f.setLocalMatrix(this.h);
            canvas.save();
            canvas.rotate(this.m, f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis);
            canvas.drawCircle(f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis, MagnifierView.this.magnifierRaduis, this.g);
            canvas.restore();
            canvas.drawBitmap(MagnifierView.this.magnifierBitmap, f2, f3, null);
        }

        private boolean a(PointF pointF) {
            int n2 = pointF.x + this.k < (float)(this.d >> 1) ? (pointF.y + this.l < (float)(this.e >> 1) ? 1 : 4) : (pointF.y + this.l < (float)(this.e >> 1) ? 2 : 3);
            return (int)((float)n2 - (360.0f - this.m) % 360.0f / 90.0f) == 1;
        }
    }
}

