/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.payformscanner;

import android.content.Context;
import io.scanbot.sap.SapManager;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.payformscanner.PayFormScanner;
import net.doo.snap.payformscanner.entity.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class PayFormScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private PayFormScanner payFormScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static PayFormScannerFrameHandler attach(ScanbotCameraView scanbotCameraView, PayFormScanner payFormScanner) {
        PayFormScannerFrameHandler payFormScannerFrameHandler = new PayFormScannerFrameHandler(scanbotCameraView.getContext(), payFormScanner);
        scanbotCameraView.getPreviewBuffer().addFrameHandler(payFormScannerFrameHandler);
        return payFormScannerFrameHandler;
    }

    public PayFormScannerFrameHandler(Context context, PayFormScanner payFormScanner) {
        this.payFormScanner = payFormScanner;
        this.sapManager = c.a(context);
    }

    @Override
    public synchronized boolean handleFrame(byte[] byArray, int n2, int n3, int n4) {
        this.logger.logMethod();
        if (!this.enabled || !this.sapManager.isLicenseActive()) {
            return false;
        }
        DetectionResult detectionResult = this.payFormScanner.preVerifyForm(byArray, n2, n3);
        return this.notifyHandlers(detectionResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(DetectionResult detectionResult) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(detectionResult);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(DetectionResult var1);
    }
}

