/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.graphics.PointF;
import io.scanbot.sap.SapManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class ContourDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private final ContourDetector contourDetector;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static ContourDetectorFrameHandler attach(ScanbotCameraView scanbotCameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler(scanbotCameraView.getContext());
        scanbotCameraView.getPreviewBuffer().addFrameHandler(contourDetectorFrameHandler);
        return contourDetectorFrameHandler;
    }

    public ContourDetectorFrameHandler(Context context) {
        this.contourDetector = new ContourDetector();
        this.sapManager = c.a(context);
    }

    @Override
    public synchronized boolean handleFrame(byte[] byArray, int n2, int n3, int n4) {
        this.logger.logMethod();
        if (!this.enabled || !this.sapManager.isLicenseActive()) {
            return false;
        }
        DetectionResult detectionResult = this.contourDetector.detect(byArray, n2, n3);
        DetectedFrame detectedFrame = new DetectedFrame(detectionResult, this.contourDetector.getPolygonF(), n4, n2, n3, this.contourDetector.getDetectionScore());
        return this.notifyHandlers(detectedFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public final void setAcceptedAngleScore(double d2) {
        if (d2 < 0.0 || d2 > 100.0) {
            throw new IllegalArgumentException("Invalid acceptedAngleScore value.");
        }
        this.contourDetector.setAcceptedAngleScore(d2);
    }

    public final void setAcceptedSizeScore(double d2) {
        if (d2 < 0.0 || d2 > 100.0) {
            throw new IllegalArgumentException("Invalid acceptedSizeScore value.");
        }
        this.contourDetector.setAcceptedSizeScore(d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(DetectedFrame detectedFrame) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(detectedFrame);
            }
        }
        return bl;
    }

    public static class DetectedFrame {
        public final DetectionResult detectionResult;
        public final List<PointF> polygon;
        public final int frameOrientation;
        public final int frameWidth;
        public final int frameHeight;
        public final double detectionScore;

        @Deprecated
        public DetectedFrame(DetectionResult detectionResult, List<PointF> list, int n2, int n3, int n4) {
            this.detectionResult = detectionResult;
            this.frameOrientation = n2;
            this.frameWidth = n3;
            this.frameHeight = n4;
            this.polygon = Collections.unmodifiableList(list);
            this.detectionScore = 0.0;
        }

        public DetectedFrame(DetectionResult detectionResult, List<PointF> list, int n2, int n3, int n4, double d2) {
            this.detectionResult = detectionResult;
            this.frameOrientation = n2;
            this.frameWidth = n3;
            this.frameHeight = n4;
            this.polygon = Collections.unmodifiableList(list);
            this.detectionScore = d2;
        }
    }

    public static interface ResultHandler {
        public boolean handleResult(DetectedFrame var1);
    }
}

