/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import io.scanbot.sap.SapManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.c;
import net.doo.snap.intelligence.l;
import net.doo.snap.intelligence.q;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.OcrPerformer;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.OcrResultBlock;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public final class g
implements OcrPerformer {
    private final Logger a = LoggerProvider.getLogger();
    private final Page[] b;
    private final SapManager c;
    private final BlobManager d;
    private final c e;
    private final l f;
    private final BlobStoreStrategy g;
    private final PageStoreStrategy h;
    private List<Language> i;

    public g(SapManager sapManager, BlobManager blobManager, c c2, l l2, BlobStoreStrategy blobStoreStrategy, PageStoreStrategy pageStoreStrategy, List<Language> list, List<Page> list2) {
        this.i = list;
        this.b = list2.toArray(new Page[list2.size()]);
        this.c = sapManager;
        this.d = blobManager;
        this.e = c2;
        this.f = l2;
        this.g = blobStoreStrategy;
        this.h = pageStoreStrategy;
    }

    @Override
    public final OcrResult recognize() {
        OcrResult ocrResult = new OcrResult("", null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        g g2 = this;
        if (!Boolean.valueOf(g2.c.isLicenseActive() && g2.c.isFeatureEnabled(16)).booleanValue()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        long l2 = SystemClock.elapsedRealtime();
        try {
            if (this.d.hasActiveDownloads()) {
                throw new IOException("Downloading in progress");
            }
            Set<Language> set = this.d.getAllLanguagesWithAvailableOcrBlobs();
            if (this.i == null || this.i.isEmpty()) {
                this.i = Collections.singletonList(this.e.a());
            }
            for (Language language : this.i) {
                if (set.contains((Object)language)) continue;
                this.a.d("OCR", "Default language is not available - abort OCR: " + this.i);
                throw new IOException("Blob for default language " + (Object)((Object)language) + " is not available");
            }
            ocrResult = this.a(this.b, set, this.i);
        }
        catch (IOException iOException) {
            this.a.logException(iOException);
        }
        g2 = this;
        long l3 = SystemClock.elapsedRealtime() - l2;
        g2.a.d("OCR", "Ocr total: " + (float)l3 / 1000.0f + " sec");
        return ocrResult;
    }

    private Boolean a() {
        return this.c.isLicenseActive() && this.c.isFeatureEnabled(16);
    }

    private void a(long l2) {
        long l3 = SystemClock.elapsedRealtime() - l2;
        this.a.d("OCR", "Ocr total: " + (float)l3 / 1000.0f + " sec");
    }

    private OcrResult a(Page[] pageArray, Set<Language> set, List<Language> list) throws IOException {
        OcrResult ocrResult;
        this.a.d("OCR", "Starting OCR with languages: " + list.toString());
        try {
            ocrResult = this.b(pageArray, set, list);
        }
        catch (q q2) {
            ocrResult = this.a(pageArray, q2.a());
        }
        return ocrResult;
    }

    private OcrResult b(Page[] pageArray, Set<Language> set, List<Language> list) throws IOException, q {
        ArrayList<OcrResultBlock> arrayList = new ArrayList<OcrResultBlock>();
        ArrayList<OcrResultBlock> arrayList2 = new ArrayList<OcrResultBlock>();
        ArrayList<OcrResultBlock> arrayList3 = new ArrayList<OcrResultBlock>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        TessBaseAPI tessBaseAPI = this.a(Language.languageCodes(list));
        try {
            Page[] pageArray2 = pageArray;
            int n2 = pageArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Page page = pageArray2[i2];
                Page page2 = page;
                File file = this.h.getImageFile(page2.getId(), Page.ImageType.OPTIMIZED);
                if (!file.exists()) continue;
                tessBaseAPI.setImage(file);
                stringBuilder.append(tessBaseAPI.getUTF8Text());
                arrayList.addAll(net.doo.snap.intelligence.g.a(tessBaseAPI, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH));
                arrayList2.addAll(net.doo.snap.intelligence.g.a(tessBaseAPI, 2, OcrResultBlock.OcrResultBlockType.LINE));
                arrayList3.addAll(net.doo.snap.intelligence.g.a(tessBaseAPI, 3, OcrResultBlock.OcrResultBlockType.WORD));
                if (bl) continue;
                bl = this.a(set, list, stringBuilder.toString());
            }
        }
        finally {
            tessBaseAPI.end();
        }
        return new OcrResult(stringBuilder.toString(), null, null, arrayList, arrayList2, arrayList3);
    }

    private static List<OcrResultBlock> a(TessBaseAPI tessBaseAPI, int n2, OcrResultBlock.OcrResultBlockType ocrResultBlockType) {
        ArrayList<OcrResultBlock> arrayList = new ArrayList<OcrResultBlock>();
        Pix pix = tessBaseAPI.getThresholdedImage();
        ResultIterator resultIterator = tessBaseAPI.getResultIterator();
        resultIterator.begin();
        arrayList.add(net.doo.snap.intelligence.g.a(resultIterator, n2, pix, ocrResultBlockType));
        while (resultIterator.next(n2)) {
            arrayList.add(net.doo.snap.intelligence.g.a(resultIterator, n2, pix, ocrResultBlockType));
        }
        return arrayList;
    }

    private static OcrResultBlock a(ResultIterator resultIterator, int n2, Pix pix, OcrResultBlock.OcrResultBlockType ocrResultBlockType) {
        String string = resultIterator.getUTF8Text(n2);
        int[] nArray = resultIterator.getBoundingBox(n2);
        Rect rect = new Rect();
        RectF rectF = new RectF();
        if (nArray.length == 4) {
            rect = new Rect(nArray[0], nArray[1], nArray[2], nArray[3]);
            if (pix != null) {
                rectF = new RectF((float)nArray[0] / (float)pix.getWidth(), (float)nArray[1] / (float)pix.getHeight(), (float)nArray[2] / (float)pix.getWidth(), (float)nArray[3] / (float)pix.getHeight());
            }
        }
        return new OcrResultBlock(string, rectF, rect, Float.valueOf(resultIterator.confidence(n2)), ocrResultBlockType);
    }

    private File a(Page page) throws IOException {
        return this.h.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
    }

    private OcrResult a(Page[] pageArray, Collection<Language> collection) throws IOException {
        List<OcrResultBlock> list = new ArrayList<OcrResultBlock>();
        List<OcrResultBlock> list2 = new ArrayList<OcrResultBlock>();
        List<OcrResultBlock> list3 = new ArrayList<OcrResultBlock>();
        StringBuilder stringBuilder = new StringBuilder();
        TessBaseAPI tessBaseAPI = this.a(Language.languageCodes(collection));
        try {
            Page[] pageArray2 = pageArray;
            int n2 = pageArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Page page = pageArray2[i2];
                File file = this.h.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
                tessBaseAPI.setImage(file);
                stringBuilder.append(tessBaseAPI.getUTF8Text());
                list = net.doo.snap.intelligence.g.a(tessBaseAPI, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH);
                list2 = net.doo.snap.intelligence.g.a(tessBaseAPI, 2, OcrResultBlock.OcrResultBlockType.LINE);
                list3 = net.doo.snap.intelligence.g.a(tessBaseAPI, 3, OcrResultBlock.OcrResultBlockType.WORD);
            }
        }
        finally {
            tessBaseAPI.end();
        }
        return new OcrResult(stringBuilder.toString(), null, null, list, list2, list3);
    }

    private TessBaseAPI a(String ... stringArray) throws IOException {
        TessBaseAPI tessBaseAPI = new TessBaseAPI();
        tessBaseAPI.init(this.g.getOCRDataDirectory().getParent() + File.separator, TextUtils.join((CharSequence)"+", (Object[])stringArray));
        tessBaseAPI.setPageSegMode(1);
        return tessBaseAPI;
    }

    private boolean a(Set<Language> set, List<Language> list, String string) throws q {
        if (string.isEmpty()) {
            return false;
        }
        try {
            HashSet<Language> hashSet = new HashSet<Language>(this.f.a(string));
            this.a.d("OCR", "Detected languages: " + Arrays.toString(hashSet.toArray()));
            hashSet.retainAll(set);
            if (hashSet.isEmpty()) {
                hashSet.addAll(set);
                this.a.d("OCR", "None of them are available");
            }
            hashSet.retainAll(list);
            if (!hashSet.isEmpty()) {
                this.a.d("OCR", "Continue with current language");
                return true;
            }
            this.a.d("OCR", "Languages are not match. Restart with languages: " + Arrays.toString(hashSet.toArray()));
            throw new q(hashSet);
        }
        catch (IOException iOException) {
            this.a.logException(iOException);
            return true;
        }
    }

    private void b() throws IOException {
        if (this.d.hasActiveDownloads()) {
            throw new IOException("Downloading in progress");
        }
    }
}

