/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import java.util.Collections;
import java.util.List;
import net.doo.snap.R;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.util.snap.PolygonHelper;

public class PolygonView
extends View
implements ContourDetectorFrameHandler.ResultHandler {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    private List<PointF> polygon;
    private float[] points;
    private float[] animationPoints;
    private Paint strokePaint;
    private Paint fillPaint;
    private boolean useFill = false;
    private Path path;
    private ValueAnimator polygonAnimator;
    private ObjectAnimator polygonAlphaAnimator;
    private a polygonEvaluator = new a(0);
    private PolygonHelper polygonHelper;

    public PolygonView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public PolygonView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context, attributeSet);
    }

    private void initView(Context context, AttributeSet attributeSet) {
        this.strokePaint = new Paint();
        this.strokePaint.setColor(-1);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        this.strokePaint.setAntiAlias(true);
        this.fillPaint = new Paint();
        this.fillPaint.setColor(-16711936);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.points = new float[16];
        this.animationPoints = new float[this.points.length];
        this.polygonHelper = new PolygonHelper();
        this.polygon = Collections.emptyList();
        this.path = new Path();
        if (attributeSet != null) {
            this.loadAttributes(context, attributeSet);
        }
    }

    private void loadAttributes(Context context, AttributeSet attributeSet) {
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.PolygonView);
        try {
            int n2 = typedArray.getColor(R.styleable.PolygonView_polygonFillColor, 0);
            this.useFill = n2 != 0;
            this.fillPaint.setColor(n2);
            int n3 = typedArray.getColor(R.styleable.PolygonView_polygonStrokeColor, -1);
            this.strokePaint.setColor(n3);
            float f2 = typedArray.getDimension(R.styleable.PolygonView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
            this.strokePaint.setStrokeWidth(f2);
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setFillColor(int n2) {
        this.useFill = n2 != 0;
        this.fillPaint.setColor(n2);
        this.invalidate();
    }

    public void setStrokeColor(int n2) {
        this.strokePaint.setColor(n2);
        this.invalidate();
    }

    public void setStrokeWidth(float f2) {
        this.strokePaint.setStrokeWidth(f2);
        this.invalidate();
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        this.polygonHelper.setLayout(0, 0, n2, n3);
    }

    @Override
    public boolean handleResult(final ContourDetectorFrameHandler.DetectedFrame detectedFrame) {
        this.post(new Runnable(){

            @Override
            public final void run() {
                PolygonView.this.updatePolygon(detectedFrame);
            }
        });
        return false;
    }

    private void updatePolygon(ContourDetectorFrameHandler.DetectedFrame detectedFrame) {
        this.polygonHelper.setRotation(detectedFrame.frameOrientation);
        if (!this.polygon.isEmpty()) {
            this.animateToPolygon(detectedFrame.polygon);
        } else {
            this.polygonHelper.polygonToPoints(detectedFrame.polygon, this.points);
            if (this.useFill) {
                this.updatePath();
            }
        }
        this.polygon = detectedFrame.polygon;
        this.invalidate();
    }

    private void animateToPolygon(List<PointF> list) {
        if (this.polygonAnimator != null) {
            this.polygonAnimator.cancel();
            this.polygonAnimator = null;
        }
        if (this.polygonAlphaAnimator != null) {
            this.polygonAlphaAnimator.cancel();
            this.polygonAlphaAnimator = null;
        }
        if (list.isEmpty()) {
            this.animatePolygonFadeOut();
            return;
        }
        this.strokePaint.setAlpha(255);
        this.polygonHelper.polygonToPoints(list, this.animationPoints);
        this.polygonAnimator = ValueAnimator.ofObject((TypeEvaluator)this.polygonEvaluator, (Object[])new Object[]{this.points, this.animationPoints});
        this.polygonAnimator.start();
    }

    private void animatePolygonFadeOut() {
        this.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)this.strokePaint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        this.polygonAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator valueAnimator) {
                PolygonView.this.invalidate();
            }
        });
        this.polygonAlphaAnimator.setDuration(250L);
        this.polygonAlphaAnimator.start();
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (!this.polygon.isEmpty()) {
            if (this.useFill) {
                canvas.drawPath(this.path, this.fillPaint);
            }
            canvas.drawLines(this.points, this.strokePaint);
        }
    }

    private void updatePath() {
        this.path.rewind();
        this.path.moveTo(this.points[0], this.points[1]);
        for (int i2 = 2; i2 < this.points.length; i2 += 2) {
            this.path.lineTo(this.points[i2], this.points[i2 + 1]);
        }
    }

    private final class a
    implements TypeEvaluator {
        private a() {
        }

        public final Object evaluate(float f2, Object object, Object object2) {
            float[] fArray = (float[])object2;
            float[] fArray2 = (float[])object;
            a a2 = this;
            for (int i2 = 0; i2 < a2.PolygonView.this.points.length; ++i2) {
                ((PolygonView)a2.PolygonView.this).points[i2] = fArray2[i2] + f2 * (fArray[i2] - fArray2[i2]);
            }
            if (a2.PolygonView.this.useFill) {
                a2.PolygonView.this.updatePath();
            }
            a2.PolygonView.this.invalidate();
            return null;
        }

        private void a(float f2, float[] fArray, float[] fArray2) {
            for (int i2 = 0; i2 < PolygonView.this.points.length; ++i2) {
                ((PolygonView)PolygonView.this).points[i2] = fArray[i2] + f2 * (fArray2[i2] - fArray[i2]);
            }
            if (PolygonView.this.useFill) {
                PolygonView.this.updatePath();
            }
            PolygonView.this.invalidate();
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

