/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import android.hardware.Camera;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.commonsware.cwac.camera.CameraHost;
import com.commonsware.cwac.camera.PictureTransaction;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.doo.snap.ScanbotSDKInitializer;
import net.doo.snap.camera.CameraOpenCallback;
import net.doo.snap.camera.CameraPreviewMode;
import net.doo.snap.camera.CameraView;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.c;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import net.doo.snap.util.snap.Utils;
import net.doo.snap.util.thread.ExecutionUtils;

public class ScanbotCameraView
extends FrameLayout {
    private CameraView cameraView;
    private net.doo.snap.camera.a cameraHost;
    private boolean resumed = false;
    private b state = b.a;
    private int lastMeasuredWidth;
    private int lastMeasuredHeight;
    private final Set<net.doo.snap.camera.b> stateCallbacks = new LinkedHashSet<net.doo.snap.camera.b>();
    private final Set<c> takePictureCallbacks = new LinkedHashSet<c>();
    private final Logger logger = LoggerProvider.getLogger();

    public ScanbotCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public ScanbotCameraView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initView(context);
    }

    private void initView(Context context) {
        if (!ScanbotSDKInitializer.isInitialized()) {
            throw new IllegalStateException("Scanbot SDK is not initialized. Please use ScanbotSDKInitializer.class for the first SDK initialization.");
        }
        if (!net.doo.snap.c.c.a(context).isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        this.cameraView = new CameraView(context);
        this.cameraHost = new net.doo.snap.camera.a(context);
        this.cameraView.setCameraHost((CameraHost)this.cameraHost);
        this.cameraView.a(new a(0));
        this.addView((View)this.cameraView, 0);
    }

    protected void onMeasure(int n2, int n3) {
        this.logger.logMethod();
        int n4 = ScanbotCameraView.resolveSize((int)this.lastMeasuredWidth, (int)n2);
        int n5 = ScanbotCameraView.resolveSize((int)this.lastMeasuredHeight, (int)n3);
        if (this.lastMeasuredWidth < n4 || this.lastMeasuredHeight < n5) {
            this.lastMeasuredWidth = n4;
            this.lastMeasuredHeight = n5;
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)this.lastMeasuredWidth, (int)View.MeasureSpec.getMode((int)n2)), View.MeasureSpec.makeMeasureSpec((int)this.lastMeasuredHeight, (int)View.MeasureSpec.getMode((int)n3)));
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        this.logger.logMethod();
        super.onLayout(bl, n2, n3, n4, n5);
        View view = this.cameraView.getChildAt(0);
        if (view == null) {
            return;
        }
        int n6 = this.getChildCount();
        int n7 = View.MeasureSpec.makeMeasureSpec((int)view.getWidth(), (int)Integer.MIN_VALUE);
        int n8 = View.MeasureSpec.makeMeasureSpec((int)view.getHeight(), (int)Integer.MIN_VALUE);
        for (int i2 = 1; i2 < n6; ++i2) {
            View view2 = this.getChildAt(i2);
            view2.measure(n7, n8);
            view2.layout(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public PreviewBuffer getPreviewBuffer() {
        return this.cameraView.b();
    }

    public void onResume() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (this.resumed) {
            return;
        }
        this.resumed = net.doo.snap.c.c.a(this.getContext()).isLicenseActive();
        this.state = b.a;
        this.cameraView.onResume();
        this.notifyResumedState();
    }

    public void onPause() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.resumed = false;
        this.state = b.a;
        this.cameraView.onPause();
        this.notifyPausedState();
    }

    private void notifyResumedState() {
        Iterator<net.doo.snap.camera.b> iterator = this.stateCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().a();
        }
    }

    private void notifyPausedState() {
        Iterator<net.doo.snap.camera.b> iterator = this.stateCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().b();
        }
    }

    private void notifyTakePictureCancelled() {
        Iterator<c> iterator = this.takePictureCallbacks.iterator();
        while (iterator.hasNext()) {
            iterator.next().b();
        }
    }

    public void startPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = b.a;
        this.cameraView.startPreview();
    }

    public void stopPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = b.a;
        this.cameraView.stopPreview();
    }

    public void takePicture(boolean bl) {
        this.logger.logMethod();
        if (this.state != b.a) {
            this.state = b.a;
            this.notifyTakePictureCancelled();
            if (!this.resumed) {
                return;
            }
        }
        if (bl) {
            this.state = b.b;
            this.autoFocus();
            return;
        }
        this.performSnapping();
    }

    private void performSnapping() {
        this.state = b.c;
        try {
            Camera.Parameters parameters = this.cameraView.getCameraParameters();
            PictureTransaction pictureTransaction = new PictureTransaction((CameraHost)this.cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true);
            if (parameters != null) {
                pictureTransaction = pictureTransaction.flashMode(parameters.getFlashMode());
            }
            this.cameraView.takePicture(pictureTransaction);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            this.state = b.a;
            this.notifyTakePictureCancelled();
            return;
        }
    }

    public void useFlash(boolean bl) {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        if (Utils.isFlashSupported(this.cameraView.getCameraParameters())) {
            this.cameraView.setFlashMode(bl ? "torch" : "off");
        }
    }

    public void setAutoFocusOnTouch(boolean bl) {
        this.cameraView.a(bl);
    }

    public void autoFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.autoFocus();
    }

    public void continuousFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.cameraView.a();
    }

    public void addPictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.a(pictureCallback);
    }

    public void removePictureCallback(PictureCallback pictureCallback) {
        this.logger.logMethod();
        this.cameraView.b(pictureCallback);
    }

    void addCameraStateCallback(net.doo.snap.camera.b b2) {
        this.logger.logMethod();
        this.stateCallbacks.add(b2);
    }

    void removeCameraStateCallback(net.doo.snap.camera.b b2) {
        this.logger.logMethod();
        this.stateCallbacks.remove(b2);
    }

    void addTakePictureCallback(c c2) {
        this.logger.logMethod();
        this.takePictureCallbacks.add(c2);
    }

    void removeTakePictureCallback(c c2) {
        this.logger.logMethod();
        this.takePictureCallbacks.remove(c2);
    }

    public void setCameraOpenCallback(CameraOpenCallback cameraOpenCallback) {
        this.logger.logMethod();
        this.cameraView.a(cameraOpenCallback);
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        this.logger.logMethod();
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            return parameters.getSupportedPictureSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        this.logger.logMethod();
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            return parameters.getSupportedPreviewSizes();
        }
        return Collections.EMPTY_LIST;
    }

    public void setPictureSize(Camera.Size size) {
        this.logger.logMethod();
        this.cameraHost.a(size);
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPictureSize(size.width, size.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setPreviewSize(Camera.Size size) {
        this.logger.logMethod();
        this.cameraHost.b(size);
        Camera.Parameters parameters = this.cameraView.getCameraParameters();
        if (parameters != null) {
            parameters.setPreviewSize(size.width, size.height);
            this.cameraView.setCameraParameters(parameters);
        }
    }

    public void setAutoFocusSound(boolean bl) {
        this.logger.logMethod();
        this.cameraHost.a(bl);
    }

    @RequiresApi(api=17)
    public void setShutterSound(boolean bl) {
        this.logger.logMethod();
        this.cameraView.b(bl);
    }

    public void setPreviewMode(CameraPreviewMode cameraPreviewMode) {
        this.logger.logMethod();
        this.cameraHost.a(cameraPreviewMode);
    }

    public void lockToPortrait() {
        this.logger.logMethod();
        this.cameraView.lockToPortrait();
    }

    public void lockToLandscape() {
        this.logger.logMethod();
        this.cameraView.lockToLandscape();
    }

    public void unlockOrientation() {
        this.logger.logMethod();
        this.cameraView.unlockOrientation();
    }

    private static enum b {
        a,
        b,
        c;

    }

    private final class a
    implements CameraView.AutofocusCallback {
        private a() {
        }

        @Override
        public final void onAutoFocusCompleted() {
            ScanbotCameraView.this.logger.logMethod();
            if (ScanbotCameraView.this.state == b.b) {
                ScanbotCameraView.this.performSnapping();
                return;
            }
            ScanbotCameraView.this.state = b.a;
            ScanbotCameraView.this.notifyTakePictureCancelled();
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

