/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class DocumentStoreStrategy {
    public static final String a = "thumbnail";
    public static final String b = "tmp_";
    private static final String c = "%s(%d)%s";
    private static final String d = " (1).";
    private final Context e;
    private final SharedPreferences f;
    private final Logger g = LoggerProvider.getLogger();

    @Inject
    public DocumentStoreStrategy(Context context, SharedPreferences sharedPreferences) {
        this.e = context;
        this.f = sharedPreferences;
    }

    public boolean ensureDocumentDir(File file) {
        File[] fileArray;
        return file != null && file.exists() && (fileArray = file.listFiles()) != null && fileArray.length > 0;
    }

    public File getDocumentsDir() throws IOException {
        return net.doo.snap.util.FileUtils.getExternalFilesDirOrShowError(this.e, "snapping_documents");
    }

    public File getDocumentsExternalDir() throws IOException {
        File file;
        String string2 = this.f.getString("EXTERNAL_DIR", "Scanbot");
        if (!TextUtils.isEmpty((CharSequence)string2) && ((file = new File(string2)).exists() || file.mkdirs())) {
            return file;
        }
        return net.doo.snap.util.FileUtils.getExternalStorageDirOrShowError(this.e, "Scanbot");
    }

    public File getDocumentsDirForSharing() throws IOException {
        return net.doo.snap.util.FileUtils.getExternalCacheDirOrShowError(this.e, "documents_for_sharing");
    }

    public File getDocumentDirForSharing(String string2) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDirForSharing(), (String[])new String[]{string2});
    }

    public File getDocumentDir(String string2) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{string2});
    }

    public void ensureDocumentDirectory(String string2) throws IOException {
        FileUtils.forceMkdir((File)this.getDocumentDir(string2));
    }

    public File getDocumentFile(String string2, String string3) throws IOException {
        return FileUtils.getFile((File)this.getDocumentDir(string2), (String[])new String[]{string3});
    }

    public List<File> getDocumentsFiles() throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this.getDocumentsDir().listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File[] fileArray2 = fileArray[i2].listFiles(new FilenameFilter(){

                @Override
                public final boolean accept(File file, String string2) {
                    return string2.endsWith(".jpg") || string2.endsWith(".pdf");
                }
            });
            arrayList.addAll(Arrays.asList(fileArray2));
        }
        return arrayList;
    }

    public File getThumbnailFile(String string2) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{string2, a});
    }

    public File getTemporaryDocumentFile(String string2, String string3) throws IOException {
        return FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{string2, b + string3});
    }

    public File getDocumentFileForSharing(String string2, String string3) throws IOException {
        File file = FileUtils.getFile((File)this.getDocumentsDirForSharing(), (String[])new String[]{string2, string3});
        FileUtils.copyFile((File)this.getDocumentFile(string2, string3), (File)file);
        return file;
    }

    public void eraseDocument(String string2, String string3) {
        try {
            FileUtils.deleteQuietly((File)this.getDocumentFile(string2, string3));
            FileUtils.deleteQuietly((File)this.getDocumentDir(string2));
            FileUtils.deleteQuietly((File)this.getDocumentDirForSharing(string2));
            return;
        }
        catch (IOException iOException) {
            this.g.logException(iOException);
            return;
        }
    }

    public boolean renameDocument(String string2, String string3, String string4) throws IOException {
        string4 = this.getUniqueName(string4);
        File file = this.getDocumentFile(string2, string4);
        return this.getDocumentFile(string2, string3).renameTo(file);
    }

    public String getUniqueName(String string2) {
        while (true) {
            String string3;
            String string4 = TextUtils.isEmpty((CharSequence)(string3 = FilenameUtils.getExtension((String)string2))) ? "" : "." + string3;
            String string5 = FilenameUtils.getBaseName((String)string2);
            int n2 = string5.lastIndexOf("(");
            int n3 = string5.lastIndexOf(")");
            Integer n4 = 0;
            String string6 = FilenameUtils.getBaseName((String)string2);
            if (n2 >= 0 && n3 >= 0 && n3 > n2) {
                try {
                    n4 = Integer.valueOf(string5.substring(n2 + 1, n3));
                    string6 = string5.substring(0, n2 - 1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            try {
                boolean bl = false;
                Iterator<File> iterator = this.getDocumentsFiles().iterator();
                while (iterator.hasNext()) {
                    if (!FilenameUtils.getBaseName((String)iterator.next().getName()).equals(string5)) continue;
                    string2 = string6 + " (" + (n4 + 1) + ")" + string4;
                    bl = true;
                    break;
                }
                if (!bl) break;
            }
            catch (IOException iOException) {
                this.g.logException(iOException);
                break;
            }
        }
        return string2;
    }

    public String getPageImagePath(int n2, Document document) throws IOException {
        return String.format(c, FilenameUtils.removeExtension((String)this.getDocumentFile(document.getId(), document.getName()).getPath()), n2, ".jpg");
    }

    public void migrateDocuments(String string2, List<Document> list) {
        boolean bl = !TextUtils.isEmpty((CharSequence)string2);
        for (Document document : list) {
            try {
                try {
                    String string3 = document.getName();
                    String string4 = document.getId();
                    File file = bl ? new File(string2) : this.getDocumentDir(string4);
                    String string5 = string3;
                    if (FileUtils.getFile((File)file, (String[])new String[]{string3}).exists()) {
                        String string6 = FilenameUtils.getExtension((String)string3);
                        String string7 = FilenameUtils.getBaseName((String)string3);
                        string5 = string7 + d + string6;
                        this.renameDocument(string4, string3, string5);
                    }
                    FileUtils.moveFileToDirectory((File)this.getDocumentFile(string4, string5), (File)file, (boolean)true);
                }
                catch (IOException iOException) {
                    this.g.logException(iOException);
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

