/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistance;

import android.graphics.Bitmap;
import io.scanbot.sdk.persistance.Page;
import io.scanbot.sdk.persistance.PageFileStorage$WhenMappings;
import io.scanbot.sdk.persistance.PageProcessorInteractor;
import io.scanbot.sdk.persistance.PageStorage;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\u0012J\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/persistance/PageFileStorage;", "", "pageProcessorInteractor", "Lio/scanbot/sdk/persistance/PageProcessorInteractor;", "pageStorage", "Lio/scanbot/sdk/persistance/PageStorage;", "(Lio/scanbot/sdk/persistance/PageProcessorInteractor;Lio/scanbot/sdk/persistance/PageStorage;)V", "add", "", "image", "", "getImageURL", "Ljava/net/URI;", "pageId", "type", "Lio/scanbot/sdk/persistance/PageFileStorage$PageFileType;", "getPreviewImageURI", "remove", "", "removeAll", "removeAllExcept", "", "pageIds", "", "setImageForId", "Landroid/graphics/Bitmap;", "existingPageId", "PageFileType", "scanbot-sdk_release"})
public final class PageFileStorage {
    private final PageProcessorInteractor pageProcessorInteractor;
    private final PageStorage pageStorage;

    @NotNull
    public final URI getImageURL(@NotNull String string2, @NotNull PageFileType pageFileType) {
        URI uRI;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pageFileType), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$0[pageFileType.ordinal()]) {
            case 1: {
                URI uRI2 = this.pageStorage.getOriginalImage(string2).toURI();
                uRI = uRI2;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"pageStorage.getOriginalImage(pageId).toURI()");
                break;
            }
            case 2: {
                URI uRI3 = this.pageStorage.getDocumentImage(string2).toURI();
                uRI = uRI3;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI3, (String)"pageStorage.getDocumentImage(pageId).toURI()");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return uRI;
    }

    @NotNull
    public final URI getPreviewImageURI(@NotNull String string2, @NotNull PageFileType pageFileType) {
        URI uRI;
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"pageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pageFileType), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$1[pageFileType.ordinal()]) {
            case 1: {
                URI uRI2 = this.pageStorage.getOriginalImagePreview(string2).toURI();
                uRI = uRI2;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"pageStorage.getOriginalI\u2026gePreview(pageId).toURI()");
                break;
            }
            case 2: {
                URI uRI3 = this.pageStorage.getDocumentImagePreview(string2).toURI();
                uRI = uRI3;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI3, (String)"pageStorage.getDocumentI\u2026gePreview(pageId).toURI()");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return uRI;
    }

    @NotNull
    public final String add(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        Page page = PageProcessorInteractor.createPage$default(this.pageProcessorInteractor, byArray, 0, 2, null);
        return page.getPageId();
    }

    public final void setImageForId(@NotNull byte[] byArray, @NotNull String string2, @NotNull PageFileType pageFileType) {
        File file;
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pageFileType), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$2[pageFileType.ordinal()]) {
            case 1: {
                file2 = this.pageStorage.getOriginalImage(string2);
                break;
            }
            case 2: {
                file2 = this.pageStorage.getDocumentImage(string2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file3 = file2;
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$3[pageFileType.ordinal()]) {
            case 1: {
                file = this.pageStorage.getOriginalImagePreview(string2);
                break;
            }
            case 2: {
                file = this.pageStorage.getDocumentImagePreview(string2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file4 = file;
        this.pageProcessorInteractor.saveBitmapTo(file3, byArray);
        this.pageProcessorInteractor.createPreviewTo(file4, byArray);
    }

    public final void setImageForId(@NotNull Bitmap bitmap, @NotNull String string2, @NotNull PageFileType pageFileType) {
        File file;
        File file2;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"image");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"existingPageId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pageFileType), (String)"type");
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$4[pageFileType.ordinal()]) {
            case 1: {
                file2 = this.pageStorage.getOriginalImage(string2);
                break;
            }
            case 2: {
                file2 = this.pageStorage.getDocumentImage(string2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file3 = file2;
        switch (PageFileStorage$WhenMappings.$EnumSwitchMapping$5[pageFileType.ordinal()]) {
            case 1: {
                file = this.pageStorage.getOriginalImagePreview(string2);
                break;
            }
            case 2: {
                file = this.pageStorage.getDocumentImagePreview(string2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File file4 = file;
        this.pageProcessorInteractor.saveBitmapTo(file3, bitmap);
        this.pageProcessorInteractor.createPreviewTo(file4, bitmap);
    }

    public final boolean remove(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"pageId");
        return this.pageStorage.getPageDir(string2).delete();
    }

    public final boolean removeAll() {
        return this.pageStorage.getPagesDirectory().delete();
    }

    public final void removeAllExcept(@NotNull List<String> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"pageIds");
        List list2 = new ArrayList();
        File[] fileArray = this.pageStorage.getPagesDirectory().listFiles();
        int n2 = fileArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            File file;
            File file2 = file = fileArray[i2];
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"listFile");
            if (list.contains(file2.getName())) continue;
            list2.add(file);
        }
        for (File file : list2) {
            file.delete();
        }
    }

    @Inject
    public PageFileStorage(@NotNull PageProcessorInteractor pageProcessorInteractor, @NotNull PageStorage pageStorage) {
        Intrinsics.checkParameterIsNotNull((Object)pageProcessorInteractor, (String)"pageProcessorInteractor");
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        this.pageProcessorInteractor = pageProcessorInteractor;
        this.pageStorage = pageStorage;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistance/PageFileStorage$PageFileType;", "", "(Ljava/lang/String;I)V", "ORIGINAL", "DOCUMENT", "scanbot-sdk_release"})
    public static final class PageFileType
    extends Enum<PageFileType> {
        public static final /* enum */ PageFileType ORIGINAL;
        public static final /* enum */ PageFileType DOCUMENT;
        private static final /* synthetic */ PageFileType[] $VALUES;

        static {
            PageFileType[] pageFileTypeArray = new PageFileType[2];
            PageFileType[] pageFileTypeArray2 = pageFileTypeArray;
            pageFileTypeArray[0] = ORIGINAL = new PageFileType();
            pageFileTypeArray[1] = DOCUMENT = new PageFileType();
            $VALUES = pageFileTypeArray;
        }

        public static PageFileType[] values() {
            return (PageFileType[])$VALUES.clone();
        }

        public static PageFileType valueOf(String string2) {
            return Enum.valueOf(PageFileType.class, string2);
        }
    }
}

