/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.util.SparseArray;

public enum OptimizationType {
    NONE(0, "none"),
    COLOR_ENHANCED(1, "color_enhanced"),
    GRAYSCALE(2, "grayscale"),
    BLACK_AND_WHITE(3, "black_and_white"),
    COLOR_DOCUMENT(4, "color_document");

    private static final SparseArray<OptimizationType> code2Type;
    private final int code;
    private final String name;

    private OptimizationType(int n3, String string3) {
        this.code = n3;
        this.name = string3;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static OptimizationType getByCode(int n2) {
        OptimizationType optimizationType = (OptimizationType)((Object)code2Type.get(n2));
        if (optimizationType == null) {
            throw new IllegalStateException("No Optimization type for code: " + n2);
        }
        return optimizationType;
    }

    static {
        code2Type = new SparseArray();
        for (OptimizationType optimizationType : OptimizationType.values()) {
            code2Type.put(optimizationType.getCode(), (Object)optimizationType);
        }
    }
}

