/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.mrzscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sap.SapManager;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class MRZScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private MRZScanner mrzScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static MRZScannerFrameHandler attach(ScanbotCameraView scanbotCameraView, MRZScanner mRZScanner) {
        MRZScannerFrameHandler mRZScannerFrameHandler = new MRZScannerFrameHandler(scanbotCameraView.getContext(), mRZScanner);
        scanbotCameraView.getPreviewBuffer().addFrameHandler(mRZScannerFrameHandler);
        return mRZScannerFrameHandler;
    }

    public MRZScannerFrameHandler(Context context, MRZScanner mRZScanner) {
        this.mrzScanner = mRZScanner;
        this.sapManager = c.a(context);
    }

    @Override
    public synchronized boolean handleFrame(byte[] byArray, int n2, int n3, int n4, Rect rect) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        MRZRecognitionResult mRZRecognitionResult = rect == null ? this.mrzScanner.recognizeMRZ(byArray, n2, n3, n4) : this.mrzScanner.recognizeMRZWithFinderOverlay(byArray, n2, n3, n4, rect);
        return this.notifyHandlers(mRZRecognitionResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(MRZRecognitionResult mRZRecognitionResult) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(mRZRecognitionResult);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(MRZRecognitionResult var1);
    }
}

