/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.persistence;

import android.app.Application;
import android.content.Context;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.doo.snap.entity.Blob;
import net.doo.snap.util.FileUtils;
import org.jetbrains.annotations.NotNull;

public class BlobStoreStrategy {
    public static final String TRAINEDDATA_EXTENSION = ".traineddata";
    public static final String BIN_EXTENSION = ".bin";
    private final Application application;

    @Inject
    public BlobStoreStrategy(Application application) {
        this.application = application;
    }

    @NotNull
    public File getBinariesDirectory() throws IOException {
        return FileUtils.getExternalFilesDirOrShowError((Context)this.application, "binaries");
    }

    @NotNull
    public File getBanksDataFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"banks.csv"});
    }

    @NotNull
    public File getMRZTraindataFile() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getOCRDataDirectory(), (String[])new String[]{"ocrb.traineddata"});
    }

    @NotNull
    public File getOCRDataDirectory() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"tessdata"});
    }

    @NotNull
    public File getDocumentClassifierDirectory() throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{"natalie"});
    }

    @NotNull
    public File getBlobFile(Blob blob) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getBinariesDirectory(), (String[])new String[]{blob.getLocalPath()});
    }
}

