/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.text.TextUtils;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.doo.snap.R;

@Singleton
public class CameraConfiguration {
    private List<String> supportedFlashModes;
    private List<String> supportedFocusModes;
    private List<Integer> supportedPreviewFormats;
    private List<Integer> supportedPictureFormats;
    private List<Camera.Size> supportedPreviewSizes;
    private List<Camera.Size> supportedPictureSizes;
    private boolean isConigured = false;

    @Inject
    public CameraConfiguration() {
    }

    public void loadCameraParameters(Camera.Parameters parameters) {
        this.supportedFlashModes = parameters.getSupportedFlashModes();
        this.supportedFocusModes = parameters.getSupportedFocusModes();
        this.supportedPreviewFormats = parameters.getSupportedPreviewFormats();
        this.supportedPictureFormats = parameters.getSupportedPictureFormats();
        this.supportedPreviewSizes = parameters.getSupportedPreviewSizes();
        this.supportedPictureSizes = parameters.getSupportedPictureSizes();
        this.isConigured = true;
    }

    public List<String> getSupportedFlashModes() {
        return this.supportedFlashModes;
    }

    public List<String> getSupportedFocusModes() {
        return this.supportedFocusModes;
    }

    public List<Integer> getSupportedPreviewFormats() {
        return this.supportedPreviewFormats;
    }

    public List<Integer> getSupportedPictureFormats() {
        return this.supportedPictureFormats;
    }

    public List<Camera.Size> getSupportedPreviewSizes() {
        return this.supportedPreviewSizes;
    }

    public List<Camera.Size> getSupportedPictureSizes() {
        return this.supportedPictureSizes;
    }

    public boolean isConigured() {
        return this.isConigured;
    }

    public String toString(Context context) {
        String string2 = context.getString(R.string.device_configuration, new Object[]{Build.PRODUCT, Build.DEVICE, Build.BOARD, Build.HARDWARE, Build.MANUFACTURER, Build.BRAND, Build.MODEL, Build.HARDWARE, Build.SERIAL, Build.FINGERPRINT});
        if (this.isConigured) {
            string2 = string2 + context.getString(R.string.camera_configuration, new Object[]{this.getSupportedFlashModes() == null ? "" : TextUtils.join((CharSequence)", ", this.getSupportedFlashModes()), this.getSupportedFocusModes() == null ? "" : TextUtils.join((CharSequence)", ", this.getSupportedFocusModes()), this.getSupportedPreviewFormats() == null ? "" : TextUtils.join((CharSequence)", ", this.getSupportedPreviewFormats()), this.getSupportedPictureFormats() == null ? "" : TextUtils.join((CharSequence)", ", this.getSupportedPictureFormats()), this.getSupportedPreviewSizes() == null ? "" : this.joinSizes(", ", this.getSupportedPreviewSizes()), this.getSupportedPictureSizes() == null ? "" : this.joinSizes(", ", this.getSupportedPictureSizes())});
        }
        return string2;
    }

    private String joinSizes(String string2, List<Camera.Size> list) {
        String string3 = "";
        for (Camera.Size size : list) {
            if (!string3.isEmpty()) {
                string3 = string3 + string2;
            }
            string3 = string3 + size.width + "x" + size.height;
        }
        return string3;
    }
}

